package com.engisis.sysphs.serialization.simulink;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simulink.SSystem;

/**
 * Writes the Simscape part of Simulink model in XML
 * 
 * @author barbau
 *
 */
public class SimulinkSimscapeXMLWriter extends SimulinkXMLWriter
{
    public SimulinkSimscapeXMLWriter(XMLStreamWriter xmlsw)
    {
        super(xmlsw);
    }
    
    public void visit(SPhysicalBlock object) throws XMLStreamException
    {
        introBlock();
        attribute("BlockType", "Reference");
        defaultBlock(object);
        SComponent scomponent = object.getComponent();
        if (scomponent != null)
        {
            property("Ports", "[" + scomponent.getInports().size() + "," + scomponent.getOutports().size() + ",0,0,0,"
                    + scomponent.getLConnectionPorts().size() + "," + scomponent.getRConnectionPorts().size() + "]");
            property("SourceBlock", scomponent.getBlockName());
            property("SourceType", scomponent.getName());
            if (scomponent.getSubClass() == null)
            {
                property("SourceFile", scomponent.getQualifiedName());
                property("ComponentPath", scomponent.getQualifiedName());
                property("ClassName", scomponent.getName());
            }
            else
            {
                property("PhysicalDomain", scomponent.getPhysicalDomain());
                property("SubClassName", scomponent.getSubClass());
            }
            
            for (SMemberAssignment sassignment : object.getAssignments())
            {
                SMember svar = sassignment.getMemberPath().size() == 1 ? sassignment.getMemberPath().get(0) : null;
                if (svar != null)
                {
                    startElement("P");
                    attribute("Name", svar.getName());
                    // if there is an assigned value
                    if (sassignment.getAssignedValue() != null)
                        sassignment.getAssignedValue().accept(getDispatcher());
                    // if there is a parameter
                    else if (sassignment.getAssignedReference().size() == 1)
                    {
                        SMember sm = sassignment.getAssignedReference().get(0);
                        if (sm instanceof SParameter)
                        {
                            SParameter sp = (SParameter) sm;
                            if (sp.getValue() != null)
                                sp.accept(getDispatcher());
                        }
                    }
                    endElement();
                    if (svar instanceof SVariable)
                    {
                        property(svar.getName() + "_specify", "on");
                        property(svar.getName() + "_priority", "High");
                    }
                }
            }
        }
        positionBlock(object);
        outroBlock();
    }
    
    public void visit(SConnectionPortBlock object) throws XMLStreamException
    {
        introBlock();
        attribute("BlockType", "PMIOPort");
        defaultBlock(object);
        if (object.getLocation() == SLocation.LEFT)
            attribute("Side", "Left");
        else if (object.getLocation() == SLocation.RIGHT)
            attribute("Side", "Right");
        positionBlock(object);
        outroBlock();
        
    }
    
    public void visit(SPhysicalLine object) throws XMLStreamException
    {
        startElement("Line");
        attribute("LineType", "Connection");
        if (object.getPoints().size() > 0)
        {
            SPhysicalConnectionPoint sconnector = object.getPoints().get(0);
            property(
                    "Src",
                    sconnector.getBlock().getSID() + "#"
                            + getPortString(sconnector.getPort()));
        }
        if (object.getPoints().size() == 2)
        {
            SPhysicalConnectionPoint sdestination = object.getPoints().get(1);
            property(
                    "Dst",
                    sdestination.getBlock().getSID() + "#"
                            + getPortString(sdestination.getPort()));
        }
        else if (object.getPoints().size() > 2)
        {
            for (int i = 1; i < object.getPoints().size(); i++)
            {
                SPhysicalConnectionPoint ssource = object.getPoints().get(i);
                
                if (i > 1 && i < object.getPoints().size() - 1)
                {
                    startElement("Branch");
                    attribute("ConnectType", "DEST_SRC");
                }
                
                startElement("Branch");
                attribute("ConnectType", "DEST_DEST");
                
                property(
                        "Src",
                        ssource.getBlock().getSID() + "#"
                                + getPortString(ssource.getPort()));
                endElement();
            }
            for (int j = 2; j < object.getPoints().size() - 1; j++)
            {
                endElement();
            }
        }
        endElement();
    }
    
    public static String getPortString(SConnectionPortBlock scpb)
    {
        SSystem ssystem = scpb.getOwningSystem();
        int i = ssystem.getLConnectionPorts().indexOf(scpb);
        if (i != -1)
            return "lconn:" + (i + 1);
        i = ssystem.getRConnectionPorts().indexOf(scpb);
        if (i != -1)
            return "rconn:" + (i + 1);
        return "";
    }
}
