package com.engisis.sysphs.serialization.simulink;

import java.io.IOException;
import java.io.Writer;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SSystem;

/**
 * Writes the Simscape part of Simulink model in MDL
 * 
 * @author barbau
 *
 */
public class SimulinkSimscapeMDLWriter extends SimulinkMDLWriter
{
    
    public SimulinkSimscapeMDLWriter(Writer w)
    {
        super(w);
    }
    
    public void visit(SDoubleValue object) throws IOException
    {
        append(Double.toString(object.getValue()));
    }
    
    public void visit(SExpressionValue object) throws IOException
    {
        append(object.getValue());
    }
    
    public void visit(SPhysicalBlock object) throws IOException
    {
        introBlock();
        append("BlockType Reference");
        SComponent scomponent = object.getComponent();
        if (scomponent != null)
        {
            append("Ports [" + scomponent.getInports().size() + "," + scomponent.getOutports().size() + ",0,0,0,"
                    + scomponent.getLConnectionPorts().size() + "," + scomponent.getRConnectionPorts().size() + "]", TL);
            append("SourceBlock \"" + scomponent.getBlockName() + "\"", TL);
            append("SourceType \"" + scomponent.getName() + "\"", TL);
            if (scomponent.getSubClass() != null)
            {
                append("SourceFile \"" + scomponent.getQualifiedName() + "\"", TL);
                append("ComponentPath \"" + scomponent.getQualifiedName() + "\"", TL);
                append("ClassName \"" + scomponent.getName() + "\"", TL);
            }
            else
            {
                append("PhysicalDomain \"" + scomponent.getPhysicalDomain() + "\"", TL);
                append("SubClassName \"" + scomponent.getSubClass() + "\"", TL);
            }
            
            for (SMemberAssignment sassignment : object.getAssignments())
            {
                String svar = sassignment.getMemberPath().size() == 1 ? sassignment.getMemberPath().get(0).getName()
                        : null;
                if (svar != null)
                {
                    append(svar + " \"", T);
                    sassignment.getAssignedValue().accept(getDispatcher());
                    append("\"", L);
                }
            }
        }
        outroBlock();
    }
    
    public void visit(SPhysicalLine object) throws IOException
    {
        append("Line", TL);
        append("{", TL);
        append("LineType \"Connection\"", TL);
        if (object.getPoints().size() > 0)
        {
            SPhysicalConnectionPoint sconnector = object.getPoints().get(0);
            String srcblock = sconnector.getBlock().getName();
            append("SrcBlock \"" + srcblock + "\"", TL);
            append("SrcPort " + getPortString(sconnector.getPort()), TL);
        }
        if (object.getPoints().size() == 2)
        {
            SPhysicalConnectionPoint sdestination = object.getPoints().get(1);
            String dstblock = sdestination.getBlock().getName();
            append("DstBlock \"" + dstblock + "\"", TL);
            append("DstPort " + getPortString(sdestination.getPort()), TL);
        }
        else if (object.getPoints().size() > 2)
        {
            for (int i = 1; i < object.getPoints().size(); i++)
            {
                SPhysicalConnectionPoint ssource = object.getPoints().get(i);
                String srcblock = ssource.getBlock().getName();
                
                if (i > 1 && i < object.getPoints().size() - 1)
                {
                    append("Branch", TL);
                    append("{", TL);
                    append("ConnectType \"DEST_SRC\"", TL);
                }
                
                append("Branch", TL);
                append("{", TL);
                append("ConnectType \"DEST_DEST\"", TL);
                append("SrcBlock \"" + srcblock + "\"", TL);
                
                append("SrcPort " + getPortString(ssource.getPort()), TL);
                append("}", TL);
            }
            for (int j = 2; j < object.getPoints().size() - 1; j++)
            {
                append("}", TL);
            }
        }
        append("}", TL);
    }
    
    private static String getPortString(SConnectionPortBlock scpb)
    {
        SSystem ssystem = scpb.getOwningSystem();
        int i = ssystem.getLConnectionPorts().indexOf(scpb);
        if (i != -1)
            return "LConn" + (i + 1);
        i = ssystem.getRConnectionPorts().indexOf(scpb);
        if (i != -1)
            return "RConn" + (i + 1);
        return "";
    }
}
