/**
 */
package com.engisis.sysphs.language.modelica;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>MComponent</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getType <em>Type</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getAccessControl <em>Access Control</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getVariability <em>Variability</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getDataFlow <em>Data Flow</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getDirection <em>Direction</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getOwningClass <em>Owning Class</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getValue <em>Value</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getModifications <em>Modifications</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getHierarchy <em>Hierarchy</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getDimensions <em>Dimensions</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getRedefinedComponent <em>Redefined Component</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MComponent#getRedefiningComponent <em>Redefining Component</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent()
 * @model kind="class"
 * @generated
 */
public class MComponent extends MNamedElement
{
    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' reference.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
    protected MClass type;
    /**
     * The default value of the '{@link #getAccessControl() <em>Access Control</em>}' attribute.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @see #getAccessControl()
     * @generated
     * @ordered
     */
    protected static final MAccessControl ACCESS_CONTROL_EDEFAULT = MAccessControl.PUBLIC;
    /**
     * The cached value of the '{@link #getAccessControl() <em>Access Control</em>}' attribute.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @see #getAccessControl()
     * @generated
     * @ordered
     */
    protected MAccessControl accessControl = ACCESS_CONTROL_EDEFAULT;
    /**
     * The default value of the '{@link #getVariability() <em>Variability</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getVariability()
     * @generated
     * @ordered
     */
    protected static final MVariability VARIABILITY_EDEFAULT = MVariability.CONTINUOUS;
    /**
     * The cached value of the '{@link #getVariability() <em>Variability</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getVariability()
     * @generated
     * @ordered
     */
    protected MVariability variability = VARIABILITY_EDEFAULT;
    /**
     * The default value of the '{@link #getDataFlow() <em>Data Flow</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getDataFlow()
     * @generated
     * @ordered
     */
    protected static final MDataFlow DATA_FLOW_EDEFAULT = MDataFlow.NONE;
    /**
     * The cached value of the '{@link #getDataFlow() <em>Data Flow</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getDataFlow()
     * @generated
     * @ordered
     */
    protected MDataFlow dataFlow = DATA_FLOW_EDEFAULT;
    /**
     * The default value of the '{@link #getDirection() <em>Direction</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getDirection()
     * @generated
     * @ordered
     */
    protected static final MDirection DIRECTION_EDEFAULT = MDirection.NONE;
    /**
     * The cached value of the '{@link #getDirection() <em>Direction</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getDirection()
     * @generated
     * @ordered
     */
    protected MDirection direction = DIRECTION_EDEFAULT;
    /**
     * The cached value of the '{@link #getValue() <em>Value</em>}' containment reference.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getValue()
     * @generated
     * @ordered
     */
    protected MDataValue value;
    /**
     * The cached value of the '{@link #getModifications() <em>Modifications</em>}' containment reference list.
     * <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * @see #getModifications()
     * @generated
     * @ordered
     */
    protected EList<MModification> modifications;
    
    /**
     * The default value of the '{@link #getHierarchy() <em>Hierarchy</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getHierarchy()
     * @generated
     * @ordered
     */
    protected static final MHierarchy HIERARCHY_EDEFAULT = MHierarchy.NONE;
    /**
     * The cached value of the '{@link #getHierarchy() <em>Hierarchy</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getHierarchy()
     * @generated
     * @ordered
     */
    protected MHierarchy hierarchy = HIERARCHY_EDEFAULT;
    
    /**
     * The cached value of the '{@link #getDimensions() <em>Dimensions</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDimensions()
     * @generated
     * @ordered
     */
    protected EList<Integer> dimensions;
    
    /**
     * The cached value of the '{@link #getRedefinedComponent() <em>Redefined Component</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRedefinedComponent()
     * @generated
     * @ordered
     */
    protected MComponent redefinedComponent;

    /**
     * The cached value of the '{@link #getRedefiningComponent() <em>Redefining Component</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRedefiningComponent()
     * @generated
     * @ordered
     */
    protected EList<MComponent> redefiningComponent;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected MComponent()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return ModelicaPackage.Literals.MCOMPONENT;
    }
    
    /**
     * Returns the value of the '<em><b>Type</b></em>' reference. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Type</em>' reference isn't clear, there really
     * should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>Type</em>' reference.
     * @see #setType(MClass)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Type()
     * @model
     * @generated
     */
    public MClass getType()
    {
        if (type != null && type.eIsProxy())
        {
            InternalEObject oldType = (InternalEObject)type;
            type = (MClass)eResolveProxy(oldType);
            if (type != oldType)
            {
            }
        }
        return type;
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public MClass basicGetType()
    {
        return type;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getType <em>Type</em>}' reference.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' reference.
     * @see #getType()
     * @generated
     */
    public void setType(MClass newType)
    {
        type = newType;
    }
    
    /**
     * Returns the value of the '<em><b>Access Control</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.modelica.MAccessControl}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Access Control</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Access Control</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MAccessControl
     * @see #setAccessControl(MAccessControl)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_AccessControl()
     * @model
     * @generated
     */
    public MAccessControl getAccessControl()
    {
        return accessControl;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getAccessControl <em>Access Control</em>}' attribute.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Access Control</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MAccessControl
     * @see #getAccessControl()
     * @generated
     */
    public void setAccessControl(MAccessControl newAccessControl)
    {
        accessControl = newAccessControl == null ? ACCESS_CONTROL_EDEFAULT : newAccessControl;
    }
    
    /**
     * Returns the value of the '<em><b>Variability</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.modelica.MVariability}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Variability</em>' attribute isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Variability</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MVariability
     * @see #setVariability(MVariability)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Variability()
     * @model
     * @generated
     */
    public MVariability getVariability()
    {
        return variability;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getVariability <em>Variability</em>}' attribute.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Variability</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MVariability
     * @see #getVariability()
     * @generated
     */
    public void setVariability(MVariability newVariability)
    {
        variability = newVariability == null ? VARIABILITY_EDEFAULT : newVariability;
    }
    
    /**
     * Returns the value of the '<em><b>Data Flow</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.modelica.MDataFlow}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Data Flow</em>' attribute isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Data Flow</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MDataFlow
     * @see #setDataFlow(MDataFlow)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_DataFlow()
     * @model
     * @generated
     */
    public MDataFlow getDataFlow()
    {
        return dataFlow;
    }
    
    /**
     * Sets the value of the '
     * {@link com.engisis.sysphs.language.modelica.MComponent#getDataFlow
     * <em>Data Flow</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @param value
     *            the new value of the '<em>Data Flow</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MDataFlow
     * @see #getDataFlow()
     * @generated
     */
    public void setDataFlow(MDataFlow newDataFlow)
    {
        dataFlow = newDataFlow == null ? DATA_FLOW_EDEFAULT : newDataFlow;
    }
    
    /**
     * Returns the value of the '<em><b>Direction</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.modelica.MDirection}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Direction</em>' attribute isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Direction</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MDirection
     * @see #setDirection(MDirection)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Direction()
     * @model
     * @generated
     */
    public MDirection getDirection()
    {
        return direction;
    }
    
    /**
     * Sets the value of the '
     * {@link com.engisis.sysphs.language.modelica.MComponent#getDirection
     * <em>Direction</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @param value
     *            the new value of the '<em>Direction</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MDirection
     * @see #getDirection()
     * @generated
     */
    public void setDirection(MDirection newDirection)
    {
        direction = newDirection == null ? DIRECTION_EDEFAULT : newDirection;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Class</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MClass#getComponents <em>Components</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Class</em>' container reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Class</em>' container reference.
     * @see #setOwningClass(MClass)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_OwningClass()
     * @see com.engisis.sysphs.language.modelica.MClass#getComponents
     * @model opposite="components" transient="false"
     * @generated
     */
    public MClass getOwningClass()
    {
        if (eContainerFeatureID() != ModelicaPackage.MCOMPONENT__OWNING_CLASS) return null;
        return (MClass)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningClass(MClass newOwningClass, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningClass, ModelicaPackage.MCOMPONENT__OWNING_CLASS, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getOwningClass <em>Owning Class</em>}' container reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Owning Class</em>' container reference.
     * @see #getOwningClass()
     * @generated
     */
    public void setOwningClass(MClass newOwningClass)
    {
        if (newOwningClass != eInternalContainer() || (eContainerFeatureID() != ModelicaPackage.MCOMPONENT__OWNING_CLASS && newOwningClass != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningClass))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningClass != null)
                msgs = ((InternalEObject)newOwningClass).eInverseAdd(this, ModelicaPackage.MCLASS__COMPONENTS, MClass.class, msgs);
            msgs = basicSetOwningClass(newOwningClass, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Value</em>' reference isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Value</em>' containment reference.
     * @see #setValue(MDataValue)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Value()
     * @model containment="true"
     * @generated
     */
    public MDataValue getValue()
    {
        return value;
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetValue(MDataValue newValue, NotificationChain msgs)
    {
        MDataValue oldValue = value;
        value = newValue;
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getValue <em>Value</em>}' containment reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Value</em>' containment reference.
     * @see #getValue()
     * @generated
     */
    public void setValue(MDataValue newValue)
    {
        if (newValue != value)
        {
            NotificationChain msgs = null;
            if (value != null)
                msgs = ((InternalEObject)value).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ModelicaPackage.MCOMPONENT__VALUE, null, msgs);
            if (newValue != null)
                msgs = ((InternalEObject)newValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ModelicaPackage.MCOMPONENT__VALUE, null, msgs);
            msgs = basicSetValue(newValue, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Modifications</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MModification}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Modifications</em>' reference list isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Modifications</em>' containment reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Modifications()
     * @model containment="true"
     * @generated
     */
    public EList<MModification> getModifications()
    {
        if (modifications == null)
        {
            modifications = new BasicInternalEList<MModification>(MModification.class);
        }
        return modifications;
    }
    
    /**
     * Returns the value of the '<em><b>Hierarchy</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.modelica.MHierarchy}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Hierarchy</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Hierarchy</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MHierarchy
     * @see #setHierarchy(MHierarchy)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Hierarchy()
     * @model
     * @generated
     */
    public MHierarchy getHierarchy()
    {
        return hierarchy;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getHierarchy <em>Hierarchy</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Hierarchy</em>' attribute.
     * @see com.engisis.sysphs.language.modelica.MHierarchy
     * @see #getHierarchy()
     * @generated
     */
    public void setHierarchy(MHierarchy newHierarchy)
    {
        hierarchy = newHierarchy == null ? HIERARCHY_EDEFAULT : newHierarchy;
    }
    
    /**
     * Returns the value of the '<em><b>Dimensions</b></em>' attribute list.
     * The list contents are of type {@link java.lang.Integer}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Dimensions</em>' attribute list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Dimensions</em>' attribute list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_Dimensions()
     * @model unique="false"
     * @generated
     */
    public EList<Integer> getDimensions()
    {
        if (dimensions == null)
        {
            dimensions = new BasicInternalEList<Integer>(Integer.class);
        }
        return dimensions;
    }
    
    /**
     * Returns the value of the '<em><b>Redefined Component</b></em>' reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MComponent#getRedefiningComponent <em>Redefining Component</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Redefined Component</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Redefined Component</em>' reference.
     * @see #setRedefinedComponent(MComponent)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_RedefinedComponent()
     * @see com.engisis.sysphs.language.modelica.MComponent#getRedefiningComponent
     * @model opposite="redefiningComponent"
     * @generated
     */
    public MComponent getRedefinedComponent()
    {
        if (redefinedComponent != null && redefinedComponent.eIsProxy())
        {
            InternalEObject oldRedefinedComponent = (InternalEObject)redefinedComponent;
            redefinedComponent = (MComponent)eResolveProxy(oldRedefinedComponent);
            if (redefinedComponent != oldRedefinedComponent)
            {
            }
        }
        return redefinedComponent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MComponent basicGetRedefinedComponent()
    {
        return redefinedComponent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetRedefinedComponent(MComponent newRedefinedComponent, NotificationChain msgs)
    {
        MComponent oldRedefinedComponent = redefinedComponent;
        redefinedComponent = newRedefinedComponent;
        return msgs;
    }

    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MComponent#getRedefinedComponent <em>Redefined Component</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Redefined Component</em>' reference.
     * @see #getRedefinedComponent()
     * @generated
     */
    public void setRedefinedComponent(MComponent newRedefinedComponent)
    {
        if (newRedefinedComponent != redefinedComponent)
        {
            NotificationChain msgs = null;
            if (redefinedComponent != null)
                msgs = ((InternalEObject)redefinedComponent).eInverseRemove(this, ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT, MComponent.class, msgs);
            if (newRedefinedComponent != null)
                msgs = ((InternalEObject)newRedefinedComponent).eInverseAdd(this, ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT, MComponent.class, msgs);
            msgs = basicSetRedefinedComponent(newRedefinedComponent, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }

    /**
     * Returns the value of the '<em><b>Redefining Component</b></em>' reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MComponent}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MComponent#getRedefinedComponent <em>Redefined Component</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Redefining Component</em>' reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Redefining Component</em>' reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMComponent_RedefiningComponent()
     * @see com.engisis.sysphs.language.modelica.MComponent#getRedefinedComponent
     * @model opposite="redefinedComponent"
     * @generated
     */
    public EList<MComponent> getRedefiningComponent()
    {
        if (redefiningComponent == null)
        {
            redefiningComponent = new BasicInternalEList<MComponent>(MComponent.class);
        }
        return redefiningComponent;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningClass((MClass)otherEnd, msgs);
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                if (redefinedComponent != null)
                    msgs = ((InternalEObject)redefinedComponent).eInverseRemove(this, ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT, MComponent.class, msgs);
                return basicSetRedefinedComponent((MComponent)otherEnd, msgs);
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getRedefiningComponent()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                return basicSetOwningClass(null, msgs);
            case ModelicaPackage.MCOMPONENT__VALUE:
                return basicSetValue(null, msgs);
            case ModelicaPackage.MCOMPONENT__MODIFICATIONS:
                return ((InternalEList<?>)getModifications()).basicRemove(otherEnd, msgs);
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                return basicSetRedefinedComponent(null, msgs);
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                return ((InternalEList<?>)getRedefiningComponent()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                return eInternalContainer().eInverseRemove(this, ModelicaPackage.MCLASS__COMPONENTS, MClass.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__TYPE:
                if (resolve) return getType();
                return basicGetType();
            case ModelicaPackage.MCOMPONENT__ACCESS_CONTROL:
                return getAccessControl();
            case ModelicaPackage.MCOMPONENT__VARIABILITY:
                return getVariability();
            case ModelicaPackage.MCOMPONENT__DATA_FLOW:
                return getDataFlow();
            case ModelicaPackage.MCOMPONENT__DIRECTION:
                return getDirection();
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                return getOwningClass();
            case ModelicaPackage.MCOMPONENT__VALUE:
                return getValue();
            case ModelicaPackage.MCOMPONENT__MODIFICATIONS:
                return getModifications();
            case ModelicaPackage.MCOMPONENT__HIERARCHY:
                return getHierarchy();
            case ModelicaPackage.MCOMPONENT__DIMENSIONS:
                return getDimensions();
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                if (resolve) return getRedefinedComponent();
                return basicGetRedefinedComponent();
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                return getRedefiningComponent();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__TYPE:
                setType((MClass)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__ACCESS_CONTROL:
                setAccessControl((MAccessControl)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__VARIABILITY:
                setVariability((MVariability)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__DATA_FLOW:
                setDataFlow((MDataFlow)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__DIRECTION:
                setDirection((MDirection)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                setOwningClass((MClass)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__VALUE:
                setValue((MDataValue)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__MODIFICATIONS:
                getModifications().clear();
                getModifications().addAll((Collection<? extends MModification>)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__HIERARCHY:
                setHierarchy((MHierarchy)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__DIMENSIONS:
                getDimensions().clear();
                getDimensions().addAll((Collection<? extends Integer>)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                setRedefinedComponent((MComponent)newValue);
                return;
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                getRedefiningComponent().clear();
                getRedefiningComponent().addAll((Collection<? extends MComponent>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__TYPE:
                setType((MClass)null);
                return;
            case ModelicaPackage.MCOMPONENT__ACCESS_CONTROL:
                setAccessControl(ACCESS_CONTROL_EDEFAULT);
                return;
            case ModelicaPackage.MCOMPONENT__VARIABILITY:
                setVariability(VARIABILITY_EDEFAULT);
                return;
            case ModelicaPackage.MCOMPONENT__DATA_FLOW:
                setDataFlow(DATA_FLOW_EDEFAULT);
                return;
            case ModelicaPackage.MCOMPONENT__DIRECTION:
                setDirection(DIRECTION_EDEFAULT);
                return;
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                setOwningClass((MClass)null);
                return;
            case ModelicaPackage.MCOMPONENT__VALUE:
                setValue((MDataValue)null);
                return;
            case ModelicaPackage.MCOMPONENT__MODIFICATIONS:
                getModifications().clear();
                return;
            case ModelicaPackage.MCOMPONENT__HIERARCHY:
                setHierarchy(HIERARCHY_EDEFAULT);
                return;
            case ModelicaPackage.MCOMPONENT__DIMENSIONS:
                getDimensions().clear();
                return;
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                setRedefinedComponent((MComponent)null);
                return;
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                getRedefiningComponent().clear();
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCOMPONENT__TYPE:
                return type != null;
            case ModelicaPackage.MCOMPONENT__ACCESS_CONTROL:
                return accessControl != ACCESS_CONTROL_EDEFAULT;
            case ModelicaPackage.MCOMPONENT__VARIABILITY:
                return variability != VARIABILITY_EDEFAULT;
            case ModelicaPackage.MCOMPONENT__DATA_FLOW:
                return dataFlow != DATA_FLOW_EDEFAULT;
            case ModelicaPackage.MCOMPONENT__DIRECTION:
                return direction != DIRECTION_EDEFAULT;
            case ModelicaPackage.MCOMPONENT__OWNING_CLASS:
                return getOwningClass() != null;
            case ModelicaPackage.MCOMPONENT__VALUE:
                return value != null;
            case ModelicaPackage.MCOMPONENT__MODIFICATIONS:
                return modifications != null && !modifications.isEmpty();
            case ModelicaPackage.MCOMPONENT__HIERARCHY:
                return hierarchy != HIERARCHY_EDEFAULT;
            case ModelicaPackage.MCOMPONENT__DIMENSIONS:
                return dimensions != null && !dimensions.isEmpty();
            case ModelicaPackage.MCOMPONENT__REDEFINED_COMPONENT:
                return redefinedComponent != null;
            case ModelicaPackage.MCOMPONENT__REDEFINING_COMPONENT:
                return redefiningComponent != null && !redefiningComponent.isEmpty();
        }
        return super.eIsSet(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (accessControl: ");
        result.append(accessControl);
        result.append(", variability: ");
        result.append(variability);
        result.append(", dataFlow: ");
        result.append(dataFlow);
        result.append(", direction: ");
        result.append(direction);
        result.append(", hierarchy: ");
        result.append(hierarchy);
        result.append(", dimensions: ");
        result.append(dimensions);
        result.append(')');
        return result.toString();
    }
    
    public MComponent getComponentByName(String name)
    {
        MClass mclass = getType();
        if (mclass == null)
            return null;
        return mclass.getComponentByName(name);
    }
    
    @Override
    public MElement createClone()
    {
        return ModelicaFactory.eINSTANCE.createMComponent();
    }
    
    @Override
    public void copyElement(MElement melement)
    {
        super.copyElement(melement);
        if (melement instanceof MComponent)
        {
            MComponent mcomponent = (MComponent) melement;
            setType(mcomponent.getType());
            setAccessControl(mcomponent.getAccessControl());
            setVariability(mcomponent.getVariability());
            setDataFlow(mcomponent.getDataFlow());
            setDirection(mcomponent.getDirection());
            setHierarchy(mcomponent.getHierarchy());
            MDataValue mdatavalue = mcomponent.getValue();
            getDimensions().addAll(mcomponent.getDimensions());
            if (mdatavalue != null)
            {
                MDataValue mdatavalue2 = (MDataValue) mdatavalue.createClone();
                mdatavalue2.copyElement(mdatavalue);
                setValue(mdatavalue2);
            }
            for (MModification mmodification : mcomponent.getModifications())
            {
                MModification mmodification2 = (MModification) mmodification.createClone();
                mmodification2.copyElement(mmodification);
                getModifications().add(mmodification2);
            }
        }
        else
            throw new IllegalArgumentException("The argument should be a MComponent");
    }
    
} // MComponent
