# Overview

This software is to validate an extension of SysML for physical interaction and signal flow simulation by translation between extended SysML models and Simulink, Simscape, and Modelica and simulation files.

# Notable source directories and files

- The tests files are located in "sysphs/src/test/resources/SysML". They can be opened with MagicDraw 18.5. Notable examples are CruiseControlPaper, SignalProcessorMD, HumidifierSystemMD, TwoTanksSystemMD, and CircuitMD.
- The metamodels for Modelica, Simulink, and Simscape were created in Ecore. These metamodels are located in "sysphs/models/" 
- The translation code is located in "sysphs/src/main/java/com/engisis/sysphs/translation/(language)".
- The serialization code is located in "sysphs/src/main/java/com/engisis/sysphs/serialization/(language)".
- The deserialization code is located in "sysphs/src/main/java/com/engisis/sysphs/deserialization/(language)".
- The preprocessing code is located in "sysphs/src/main/java/com/engisis/sysphs/util/SysMLPreProcessor.java".

# Compilation

Maven is needed to compile the source code.

Use `mvn compile` to compile the source code.
Use `mvn assembly:assembly` to create a standalone JAR file.

Here are a few things to note regarding the source code:
- JAR dependencies are located in "sysphs/repository/". The command to add new JARs is `mvn install-file -Dfile=path.jar -DgroupId=groupId -DartifactId=artifactId -Dversion=version -Dpackaging=jar -DlocalRepositoryPath=repository`
- To translate individual test file, see the corresponding test function names in the test class and run `mvn test -dTest=*#*FunctionName*`

# Authors

**Raphael Barbau, Engisis LLC.**
For any questions, send email at: first name dot last name at engisis dot com

# License

This software is a U.S. Government work.  It is based in part on work supported by U.S. National Institute of Standards and Technology (NIST, http://www.nist.gov) contract SB1341-13-RQ-0709 and grant award 70NANB14H249 to Engisis, LLC, and in part on work supported by the NIST-ARRA Measurement Science and Engineering Fellowship Program award 70NANB10H026, through the University of Maryland, and in part on work supported by NIST grant award 70NANB11H148 to the University of Maryland.

NIST assumes no responsibility whatsoever for its use by other parties, and makes no guarantees, expressed or implied, about its quality, reliability, or any other characteristic.

This software can be redistributed and/or modified freely provided that any derivative works bear some notice that they are derived from it, and any modified versions bear some notice that they have been modified.  We would appreciate acknowledgement if the software is used.

Disclaimer: Certain commercial firms and trade names are identified in this document in order to specify the installation and usage procedures adequately. Such identification is not intended to imply recommendation or endorsement by the National Institute of Standards and Technology <http://www.nist.gov/> , nor is it intended to imply that related products are necessarily the best available for the purpose.
