model StateMachineBlockModel
  StateMachineBlock _StateMachineBlock;
  model StateMachineBlock
    StateMachine _StateMachine;
    block StateMachine
      Real temp;
      Real rate;
      Modelica.StateGraph.InitialStep StateMachine_region3_pseudostate6(nIn=0,nOut=1);
      Modelica.StateGraph.Step Off(nIn=3,nOut=1);
      Modelica.StateGraph.Step On(nIn=2,nOut=2);
      Modelica.StateGraph.Step PowerSaving(nIn=1,nOut=2);
      Modelica.StateGraph.Transition StateMachine_region3_transition0(condition=true);
      Modelica.StateGraph.Transition StateMachine_region3_transition1(condition=true);
      Modelica.StateGraph.Transition temp200(condition=temp>200);
      Modelica.StateGraph.Transition temp100(condition=temp>100);
      Modelica.StateGraph.Transition StateMachine_region3_transition4(condition=temp<100);
      Modelica.StateGraph.Transition StateMachine_region3_transition5(condition=temp>200);
    equation
      ;
      connect(StateMachine_region3_pseudostate6.outPort[1], StateMachine_region3_transition0.inPort);
      connect(StateMachine_region3_transition0.outPort, Off.inPort[1]);
      connect(Off.outPort[1], StateMachine_region3_transition1.inPort);
      connect(StateMachine_region3_transition1.outPort, On.inPort[1]);
      connect(On.outPort[1], temp200.inPort);
      connect(temp200.outPort, Off.inPort[2]);
      connect(On.outPort[2], temp100.inPort);
      connect(temp100.outPort, PowerSaving.inPort[1]);
      connect(PowerSaving.outPort[1], StateMachine_region3_transition4.inPort);
      connect(StateMachine_region3_transition4.outPort, On.inPort[2]);
      connect(PowerSaving.outPort[2], StateMachine_region3_transition5.inPort);
      connect(StateMachine_region3_transition5.outPort, Off.inPort[3]);
    algorithm
      if Off.active then ratenull1null end if;
      if On.active then ratenull2null end if;
      if PowerSaving.active then ratenull1.5null end if;
    end StateMachine;
  end StateMachineBlock;
end StateMachineBlockModel;
