model SourceToSinkModel
  SourceToSink _SourceToSink;
  model SourceToSink
    SignalProcessor dsp;
    SignalSource inputSignal(amp.start=3.0,amp.fixed=true);
    SignalSink scopeSignalOutput;
  equation
    connect(inputSignal.y,dsp.u);
    connect(dsp.y,scopeSignalOutput.u);
  end SourceToSink;
  model SignalSink
    input Real u;
    Real scope;
  equation
    scope=u;
  end SignalSink;
  model SignalSource
    output Real y;
    parameter Real amp(start=3.0,fixed=true);
  equation
    y=amp*sin(2*3.14*time)+3*sin(3.14*time)+10*sin(2*time);
  end SignalSource;
  model SignalProcessor
    extends TwoPinSignalComponent;
    Amplifier a(g.start=2.0,g.fixed=true);
    HighPassFilter hpf(xi.start=0.0,xi.fixed=true,alpha.start=0.01,alpha.fixed=true);
    LowPassFilter lpf(xi.start=0.0,xi.fixed=true,alpha.start=3.0,alpha.fixed=true);
    Mixer m;
  equation
    connect(u,a.u);
    connect(a.y,hpf.u);
    connect(a.y,lpf.u);
    connect(lpf.y,m.u2);
    connect(hpf.y,m.u1);
    connect(m.y,y);
  end SignalProcessor;
  model Mixer
    input Real u1;
    input Real u2;
    output Real y;
  equation
    y=(u1+u2)/2;
  end Mixer;
  model LowPassFilter
    extends TwoPinSignalComponent;
    parameter Real alpha(start=3.0,fixed=true);
    Real xi;
  equation
    y=xi;
    der(xi)=1/alpha*u-1/alpha*xi;
  end LowPassFilter;
  model HighPassFilter
    extends TwoPinSignalComponent;
    parameter Real alpha(start=0.01,fixed=true);
    Real xi;
  equation
    der(xi)=1/alpha*u-1/alpha*xi;
    y=u-xi;
  end HighPassFilter;
  model Amplifier
    extends TwoPinSignalComponent;
    parameter Real g(start=2.0,fixed=true);
  equation
    y=u*g;
  end Amplifier;
  model TwoPinSignalComponent
    input Real u;
    output Real y;
  end TwoPinSignalComponent;
end SourceToSinkModel;
