function FilterSystem_mssc_FilterSystemConstraint(block)
  setup(block);
end
function setup(block)
  block.NumInputPorts =1;
  block.InputPort(1).DirectFeedthrough=1;
  block.NumOutputPorts =1;
  block.OutputPort(1).SamplingMode = 'sample';
  block.NumContStates = 1;
  block.RegBlockMethod('PostPropagationSetup',@DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',@InitConditions);
  block.RegBlockMethod('Derivatives',@Derivatives);
  block.RegBlockMethod('Outputs',@Outputs);
  block.SampleTimes = [0 0];
end
function DoPostPropSetup(block)
  block.NumDworks=4;
  block.Dwork(1).Name = 'A';
  block.Dwork(1).Dimensions = 1;
  block.Dwork(1).DatatypeID = 0;
  block.Dwork(1).Complexity = 'Real';
  block.Dwork(1).UsedAsDiscState = false;
  block.Dwork(2).Name = 'B';
  block.Dwork(2).Dimensions = 1;
  block.Dwork(2).DatatypeID = 0;
  block.Dwork(2).Complexity = 'Real';
  block.Dwork(2).UsedAsDiscState = false;
  block.Dwork(3).Name = 'C';
  block.Dwork(3).Dimensions = 1;
  block.Dwork(3).DatatypeID = 0;
  block.Dwork(3).Complexity = 'Real';
  block.Dwork(3).UsedAsDiscState = false;
  block.Dwork(4).Name = 'D';
  block.Dwork(4).Dimensions = 1;
  block.Dwork(4).DatatypeID = 0;
  block.Dwork(4).Complexity = 'Real';
  block.Dwork(4).UsedAsDiscState = false;
end
function InitConditions(block)
  A=;
  B=;
  C=;
  D=;
end
function Derivatives(block)
  block.Derivatives.Data(1)=block.Dwork(1).Data*block.ContStates.Data(1)+block.Dwork(2).Data*block.InputPort(1).Data;
end
function Outputs(block)
  C=[0.5 -0.5];
  C=[0.5 -0.5];
  C=[0.5 -0.5];
  C=[0.5 -0.5];
  C=[0.5 -0.5];
end
