model FilterSystemModel
  FilterSystem _FilterSystem;
  model FilterSystem
    parameter Real gain(start=2.0,fixed=true);
    parameter Real a1(start=3.0,fixed=true);
    parameter Real a2(start=0.01,fixed=true);
    input Real inSignal;
    output Real outSignal;
    Real x0;
  equation
    der(x0)=A*x0+B*inSignal;
    outSignal=C*x0+D*inSignal;
    A={{-1/a1,0},{0,-1/a2}};
    B={{g/a1},{g/a2}};
    D={{0.5}};
    C={{0.5,-0.5}};
  end FilterSystem;
end FilterSystemModel;
