model SignalPhysicalSystemModel
  SignalPhysicalSystem _SignalPhysicalSystem;
  model SignalPhysicalSystem
    PhysicalComponent component;
    Modelica.Blocks.Sources.Constant c(k=1.0,k.fixed=true);
  equation
    connect(c.y,component.u);
    connect(component.l,component.r);
  end SignalPhysicalSystem;
  connector LMomFlowElement
    flow Force f;
    Velocity lV;
  end LMomFlowElement;
  type Velocity=Real(unit="m/s");
  type Force=Real(unit="N");
  type Force=Real(unit="N");
  model PhysicalComponent
    input Force u;
    output Velocity y;
    LMomFlowElement l;
    LMomFlowElement r;
    Velocity v;
    Force f;
    parameter Mass m(start=1.0,fixed=true);
  equation
    v=l.lV-r.lV;
    f=l.f;
    l.f+r.f=0;
    f=m*der(v);
    u=f;
    y=v;
  end PhysicalComponent;
  type Mass=Real(unit="kg");
  type Velocity=Real(unit="kg");
end SignalPhysicalSystemModel;
