model PressureSystem1Model
  PressureSystem1 _PressureSystem1;
  model PressureSystem1
    extends PressureSystem;
    Inlet inlet(pressure.start=2700.0,pressure.fixed=true);
    Outlet outlet(pressure.start=0.0,pressure.fixed=true);
    Pipe p1(length.start=1.35,length.fixed=true,diameter.start=0.005,diameter.fixed=true);
    Pipe p2(length.start=1.8,length.fixed=true,diameter.start=0.007,diameter.fixed=true);
    Chamber c1(pressure.start=700.0,pressure.fixed=true,volume.start=0.005,volume.fixed=true);
  equation
    connect(p1.end1,inlet.end1);
    connect(p1.end2,c1.end1);
    connect(p2.end1,c1.end2);
    connect(outlet.end1,p2.end2);
  end PressureSystem1;
  connector VolumeFlowElement
    flow VolumeFlowRate q;
    Pressure p;
  end VolumeFlowElement;
  type Pressure=Real(unit="Pa");
  type VolumeFlowRate=Real(unit="m³/s");
  model Chamber
    extends TwoEndsPressureComponent;
    parameter Volume volume;
  equation
    der(pressure)=pressure*flowrate/volume;
    pressure=end1.p-end2.p;
    flowrate=end1.q;
    end1.q+end2.q=0;
  end Chamber;
  type Volume=Real(unit="m^3");
  model TwoEndsPressureComponent
    Pressure pressure;
    VolumeFlowRate flowrate;
    VolumeFlowElement end1;
    VolumeFlowElement end2;
  end TwoEndsPressureComponent;
  model Pipe
    extends TwoEndsPressureComponent;
    parameter Length length;
    parameter Length diameter;
    parameter Viscosity viscosity(start=0.5,fixed=true);
  equation
    flowrate=(pressure*3.14*diameter^4)/(length*128*viscosity);
    pressure=end1.p-end2.p;
    flowrate=end1.q;
    end1.q+end2.q=0;
  end Pipe;
  type Viscosity=Real(unit="daP");
  type Length=Real(unit="m");
  model Outlet
    parameter Pressure pressure;
    VolumeFlowElement end1;
  equation
    end1.p=pressure;
  end Outlet;
  model Inlet
    parameter Pressure pressure;
    VolumeFlowElement end1;
  equation
    end1.p=pressure;
  end Inlet;
  model PressureSystem
  end PressureSystem;
end PressureSystem1Model;
