model SignalProcessorModel
  SignalProcessor _SignalProcessor;
  model SignalProcessor
    extends TwoPinSignalComponent;
    Amplifier a;
    HighPassFilter hpf;
    LowPassFilter lpf;
    Mixer m;
  equation
    connect(u,a.u);
    connect(a.y,hpf.u);
    connect(a.y,lpf.u);
    connect(lpf.y,m.u2);
    connect(hpf.y,m.u1);
    connect(m.y,y);
  end SignalProcessor;
  model Mixer
    input Real u1;
    input Real u2;
    output Real y;
  equation
    y=(u1+u2)/2;
  end Mixer;
  model LowPassFilter
    extends TwoPinSignalComponent;
    parameter Real alpha(start=3.0,fixed=true);
    Real xi(start=0.0,fixed=true);
  equation
    y=xi;
    der(xi)=1/alpha*u-1/alpha*xi;
  end LowPassFilter;
  model HighPassFilter
    extends TwoPinSignalComponent;
    parameter Real alpha(start=0.01,fixed=true);
    Real xi(start=0.0,fixed=true);
  equation
    der(xi)=1/alpha*u-1/alpha*xi;
    y=u-xi;
  end HighPassFilter;
  model Amplifier
    extends TwoPinSignalComponent;
    parameter Real g(start=2.0,fixed=true);
  equation
    y=u*g;
  end Amplifier;
  model TwoPinSignalComponent
    input Real u;
    output Real y;
  end TwoPinSignalComponent;
end SignalProcessorModel;
