model HumidifierSystemModel
  HumidifierSystem _HumidifierSystem;
  model HumidifierSystem
    HumidifiedRoom room;
    Humidifier humidifierSystem;
  equation
    connect(room.vaporIn,humidifierSystem.vaporOut);
    connect(humidifierSystem.humidityIn,room.humidityOut);
  end HumidifierSystem;
  model Humidifier
    input Real humidityIn;
    output Real vaporOut;
    HeaterControl heaterControl(prLow.start=0.0,prLow.fixed=true,prHigh.start=1.0,prHigh.fixed=true,threshold.start=1.0,threshold.fixed=true,targetHumidityIn.start=70.0,targetHumidityIn.fixed=true);
    UsageScenario usage;
    WaterTank watertank(tankVolume.start=50000.0,tankVolume.fixed=true,litpSec2mLitpHr.start=3600000.0,litpSec2mLitpHr.fixed=true);
    Control control(safeTemperature.start=50.0,safeTemperature.fixed=true);
    VaporGenerationPlant vaporGenerationPlant;
  equation
    connect(heaterControl.humidityIn,humidityIn);
    connect(control.mode,heaterControl.modeIn);
    connect(vaporGenerationPlant.temperatureOut,control.waterTemperatureIn);
    connect(vaporOut,vaporGenerationPlant.vaporOut);
    connect(watertank.waterVolumeOut,control.waterVolumeIn);
    connect(vaporGenerationPlant.fanWatIn,control.fanPowerOut);
    connect(vaporGenerationPlant.vaporOut,watertank.consumptionIn);
    connect(heaterControl.heaterPowerRatioOut,vaporGenerationPlant.heaterPowerRatioIn);
    connect(control.swtch,usage.swtch);
  end Humidifier;
  model VaporGenerationPlant
    input Real fanWatIn;
    input Real heaterPowerRatioIn;
    output Real temperatureOut;
    output Real vaporOut;
    Heating h;
    Evaporation e;
    Radiation r(roomTemperature.start=30.0,roomTemperature.fixed=true,radiationFactor.start=0.1,radiationFactor.fixed=true,fanEfficiency.start=0.1,fanEfficiency.fixed=true);
    VaporGenerationPlantCalculation vGPC(maxHeaterPower.start=400.0,maxHeaterPower.fixed=true);
  equation
    connect(temperatureOut,h.temperatureOut);
    connect(r.fanWatIn,fanWatIn);
    connect(h.temperatureOut,r.temperatureIn);
    connect(h.temperatureOut,e.temperatureIn);
    connect(vaporOut,e.vaporOut);
    connect(vGPC.ipHtrPwr,heaterPowerRatioIn);
    connect(r.radiationWaterOut,vGPC.ipRadiation);
    connect(vGPC.opEnergy,h.energyWatIn);
    connect(vGPC.opEnergy,e.energyWatIn);
  end VaporGenerationPlant;
  model VaporGenerationPlantCalculation
    input Real ipHtrPwr;
    input Real ipRadiation;
    output Real opEnergy;
    parameter Real maxHeaterPower;
  equation
    opEnergy=((maxHeaterPower*ipHtrPwr)-ipRadiation);
  end VaporGenerationPlantCalculation;
  model Radiation
    input Real temperatureIn;
    input Real fanWatIn;
    output Real radiationWaterOut;
    parameter Real roomTemperature;
    parameter Real radiationFactor;
    parameter Real fanEfficiency;
  equation
    radiationWaterOut=(temperatureIn-roomTemperature)*(radiationFactor+(fanWatIn*fanEfficiency));
  end Radiation;
  model Evaporation
    input Real temperatureIn;
    input Real energyWatIn;
    output Real vaporOut;
    EvaporationCalculation eC(evaporationHeat.start=2270.0,evaporationHeat.fixed=true,specificHeat.start=1.996,specificHeat.fixed=true,boilingTemperature.start=100.0,boilingTemperature.fixed=true,environmentTemperature.start=20.0,environmentTemperature.fixed=true);
    EvaporationCalculation2 eC2(boilingTemperature.start=99.99,boilingTemperature.fixed=true,noPower.start=0.0,noPower.fixed=true,litPSec2mLitPHour.start=3600000.0,litPSec2mLitPHour.fixed=true);
  equation
    connect(eC.energy,energyWatIn);
    connect(eC2.opVapor,vaporOut);
    connect(eC.vapor,eC2.ipVapor);
    connect(temperatureIn,eC2.ipTemperature);
  end Evaporation;
  model EvaporationCalculation2
    input Real ipVapor;
    input Real ipTemperature;
    output Real opVapor;
    parameter Real boilingTemperature;
    parameter Real noPower;
    parameter Real litPSec2mLitPHour;
  equation
    opVapor=litPSec2mLitPHour*(((max(min(ipVapor,1),0))*max((ipTemperature-boilingTemperature),0)/(ipTemperature-boilingTemperature))+noPower*(max((boilingTemperature-ipTemperature),0)/(boilingTemperature-ipTemperature)));
  end EvaporationCalculation2;
  model EvaporationCalculation
    parameter Real evaporationHeat;
    parameter Real specificHeat;
    parameter Real boilingTemperature;
    input Real energy;
    output Real vapor;
    parameter Real environmentTemperature;
  equation
    vapor=energy/(evaporationHeat+specificHeat*(boilingTemperature-environmentTemperature));
  end EvaporationCalculation;
  model Heating
    input Real energyWatIn;
    output Real temperatureOut;
    TemperatureIncrease tI(specificHeat.start=4180.0,specificHeat.fixed=true,waterVolume.start=0.1,waterVolume.fixed=true);
    HeatingCalculation hC;
  equation
    connect(tI.energy,energyWatIn);
    connect(hC.opTemp,temperatureOut);
    connect(hC.ipTempInc,tI.increase);
  end Heating;
  model HeatingCalculation
    input Real ipTempInc;
    output Real opTemp;
    Real xIntg;
  equation
    opTemp=max(min(100,xIntg),0);
    der(xIntg)=ipTempInc;
  end HeatingCalculation;
  model TemperatureIncrease
    input Real energy;
    output Real increase;
    parameter Real specificHeat;
    parameter Real waterVolume;
  equation
    increase=energy/(specificHeat*waterVolume);
  end TemperatureIncrease;
  model Control
    input Real waterVolumeIn;
    input Real waterTemperatureIn;
    output Real mode;
    output Real fanPowerOut;
    input Real swtch;
    parameter Real safeTemperature;
    ControlStateMachine _ControlStateMachine;
    block ControlStateMachine
      Modelica.StateGraph.InitialStep ControlStateMachine_region0_pseudostate7(nIn=0,nOut=1);
      Modelica.StateGraph.Step Off(nIn=2,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=2);
      Modelica.StateGraph.Step WarmUp(nIn=1,nOut=2);
      Modelica.StateGraph.Step CoolDown(nIn=3,nOut=1);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition0(condition=true);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition1(condition=swtch==1);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition2(condition=swtch==0);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition3(condition=waterVolumeIn==0);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition4(condition=waterTemperatureIn>=99);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition5(condition=waterTemperatureIn<=safeTemperature);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition6(condition=swtch==0);
      Real waterVolumeIn;
      Real waterTemperatureIn;
      Real mode;
      Real fanPowerOut;
      Real swtch;
      Real safeTemperature;
    equation
      connect(ControlStateMachine_region0_pseudostate7.outPort[1], ControlStateMachine_region0_transition0.inPort);
      connect(ControlStateMachine_region0_transition0.outPort, Off.inPort[1]);
      connect(Off.outPort[1], ControlStateMachine_region0_transition1.inPort);
      connect(ControlStateMachine_region0_transition1.outPort, WarmUp.inPort[1]);
      connect(On.outPort[1], ControlStateMachine_region0_transition2.inPort);
      connect(ControlStateMachine_region0_transition2.outPort, CoolDown.inPort[1]);
      connect(On.outPort[2], ControlStateMachine_region0_transition3.inPort);
      connect(ControlStateMachine_region0_transition3.outPort, CoolDown.inPort[2]);
      connect(WarmUp.outPort[1], ControlStateMachine_region0_transition4.inPort);
      connect(ControlStateMachine_region0_transition4.outPort, On.inPort[1]);
      connect(CoolDown.outPort[1], ControlStateMachine_region0_transition5.inPort);
      connect(ControlStateMachine_region0_transition5.outPort, Off.inPort[2]);
      connect(WarmUp.outPort[2], ControlStateMachine_region0_transition6.inPort);
      connect(ControlStateMachine_region0_transition6.outPort, CoolDown.inPort[3]);
    algorithm
      if Off.active then mode:=0;fanPowerOut:=0; end if;
      if On.active then mode:=1;fanPowerOut:=1; end if;
      if WarmUp.active then mode:=1;fanPowerOut:=0; end if;
      if CoolDown.active then mode:=0;fanPowerOut:=1; end if;
    end ControlStateMachine;
  equation
    waterVolumeIn=_ControlStateMachine.waterVolumeIn;
    waterTemperatureIn=_ControlStateMachine.waterTemperatureIn;
    mode=_ControlStateMachine.mode;
    fanPowerOut=_ControlStateMachine.fanPowerOut;
    swtch=_ControlStateMachine.swtch;
    safeTemperature=_ControlStateMachine.safeTemperature;
  end Control;
  model WaterTank
    output Real waterVolumeOut;
    input Real consumptionIn;
    parameter Real tankVolume;
    parameter Real litpSec2mLitpHr;
    Real xInteg;
  equation
    waterVolumeOut=tankVolume-min(50000,xInteg);
    der(xInteg)=consumptionIn/litpSec2mLitpHr;
  end WaterTank;
  model UsageScenario
    output Real swtch;
    UsageScenarioStateMachine _UsageScenarioStateMachine;
    block UsageScenarioStateMachine
      Modelica.StateGraph.InitialStep UsageScenarioStateMachine_region0_pseudostate3(nIn=0,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=1);
      Modelica.StateGraph.Step Off(nIn=1,nOut=0);
      Modelica.StateGraph.Step Started(nIn=1,nOut=1);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition0(condition=time>300);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition1(condition=time>3300);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition2(condition=true);
      Real swtch;
    equation
      connect(Started.outPort[1], UsageScenarioStateMachine_region0_transition0.inPort);
      connect(UsageScenarioStateMachine_region0_transition0.outPort, On.inPort[1]);
      connect(On.outPort[1], UsageScenarioStateMachine_region0_transition1.inPort);
      connect(UsageScenarioStateMachine_region0_transition1.outPort, Off.inPort[1]);
      connect(UsageScenarioStateMachine_region0_pseudostate3.outPort[1], UsageScenarioStateMachine_region0_transition2.inPort);
      connect(UsageScenarioStateMachine_region0_transition2.outPort, Started.inPort[1]);
    algorithm
      if On.active then swtch:=1; end if;
      if Off.active then swtch:=0; end if;
    end UsageScenarioStateMachine;
  equation
    swtch=_UsageScenarioStateMachine.swtch;
  end UsageScenario;
  model HeaterControl
    input Real modeIn;
    input Real humidityIn;
    output Real heaterPowerRatioOut;
    parameter Real prLow;
    parameter Real prHigh;
    parameter Real threshold;
    parameter Real targetHumidityIn;
    HeaterControlSM _HeaterControlSM;
    block HeaterControlSM
      Modelica.StateGraph.InitialStep HeaterControlSM_region0_pseudostate4(nIn=0,nOut=1);
      Modelica.StateGraph.Step Off(nIn=3,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=2);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition0(condition=true);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition1(condition=modeIn==1 and humidityIn<targetHumidityIn-threshold);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition2(condition=modeIn==0);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition3(condition=humidityIn>targetHumidityIn);
      Real modeIn;
      Real humidityIn;
      Real heaterPowerRatioOut;
      Real prLow;
      Real prHigh;
      Real threshold;
      Real targetHumidityIn;
    equation
      connect(HeaterControlSM_region0_pseudostate4.outPort[1], HeaterControlSM_region0_transition0.inPort);
      connect(HeaterControlSM_region0_transition0.outPort, Off.inPort[1]);
      connect(Off.outPort[1], HeaterControlSM_region0_transition1.inPort);
      connect(HeaterControlSM_region0_transition1.outPort, On.inPort[1]);
      connect(On.outPort[1], HeaterControlSM_region0_transition2.inPort);
      connect(HeaterControlSM_region0_transition2.outPort, Off.inPort[2]);
      connect(On.outPort[2], HeaterControlSM_region0_transition3.inPort);
      connect(HeaterControlSM_region0_transition3.outPort, Off.inPort[3]);
    algorithm
      if Off.active then heaterPowerRatioOut:=prLow; end if;
      if On.active then heaterPowerRatioOut:=prHigh; end if;
    end HeaterControlSM;
  equation
    modeIn=_HeaterControlSM.modeIn;
    humidityIn=_HeaterControlSM.humidityIn;
    heaterPowerRatioOut=_HeaterControlSM.heaterPowerRatioOut;
    prLow=_HeaterControlSM.prLow;
    prHigh=_HeaterControlSM.prHigh;
    threshold=_HeaterControlSM.threshold;
    targetHumidityIn=_HeaterControlSM.targetHumidityIn;
  end HeaterControl;
  model HumidifiedRoom
    output Real humidityOut;
    input Real vaporIn;
    SaturationVaporPressure sVP(p2.start=7.5,p2.fixed=true,roomTemperature.start=30.0,roomTemperature.fixed=true,p1.start=6.11,p1.fixed=true,logBase.start=10.0,logBase.fixed=true,celciusOffset.start=273.0,celciusOffset.fixed=true,hPa2Pa.start=100.0,hPa2Pa.fixed=true);
    RelativeHumidity rH;
    VolumeConversion mLpH2mLpS(gain.start=2.8E-4,gain.fixed=true);
    PercentageConversion toPercentage(gain.start=100.0,gain.fixed=true);
  equation
    connect(rH.satVaporPressureIn,sVP.satVaporPressureOut);
    connect(rH.humidityOut,rH.humidityIn);
    connect(toPercentage.ip,rH.humidityOut);
    connect(toPercentage.op,humidityOut);
    connect(mLpH2mLpS.op,rH.vaporIn);
    connect(mLpH2mLpS.ip,vaporIn);
  end HumidifiedRoom;
  model PercentageConversion
    input Real ip;
    output Real op;
    parameter Real gain;
  equation
    op=ip*gain;
  end PercentageConversion;
  model VolumeConversion
    parameter Real gain;
    input Real ip;
    output Real op;
  equation
    op=ip*gain;
  end VolumeConversion;
  model RelativeHumidity
    input Real vaporIn;
    input Real satVaporPressureIn;
    output Real humidityOut;
    input Real humidityIn;
    HumidityBalance hB(airExchangeRate.start=1.0E-8,airExchangeRate.fixed=true,envHumidity.start=0.35,envHumidity.fixed=true,volume.start=25000.0,volume.fixed=true);
    VaporPressureCalculation vPC(roomTemperature.start=30.0,roomTemperature.fixed=true,gasConst.start=8.314,gasConst.fixed=true,molecularW.start=18.015,molecularW.fixed=true,celciusOffset.start=273.0,celciusOffset.fixed=true,volume.start=25000.0,volume.fixed=true);
    RelativeHumidityCalculation relHumCalc;
  equation
    connect(vaporIn,vPC.vapor);
    connect(hB.humidity,humidityIn);
    connect(relHumCalc.opHum,humidityOut);
    connect(relHumCalc.ipChange,hB.change);
    connect(vPC.pressure,relHumCalc.ipPress);
    connect(satVaporPressureIn,relHumCalc.ipSat);
  end RelativeHumidity;
  model RelativeHumidityCalculation
    input Real ipPress;
    input Real ipSat;
    output Real opHum;
    input Real ipChange;
    Real xInt;
  equation
    opHum=max(min(1,xInt),0);
    der(xInt)=(ipPress/ipSat)-ipChange;
  end RelativeHumidityCalculation;
  model VaporPressureCalculation
    parameter Real roomTemperature;
    parameter Real gasConst;
    parameter Real molecularW;
    parameter Real celciusOffset;
    input Real vapor;
    output Real pressure;
    parameter Real volume;
  equation
    pressure=vapor*(gasConst*((roomTemperature+celciusOffset)/(molecularW*volume)));
  end VaporPressureCalculation;
  model HumidityBalance
    parameter Real airExchangeRate;
    parameter Real envHumidity;
    input Real humidity;
    output Real change;
    parameter Real volume;
  equation
    change=((humidity-envHumidity)*(volume*airExchangeRate));
  end HumidityBalance;
  model SaturationVaporPressure
    output Real satVaporPressureOut;
    parameter Real p2;
    parameter Real roomTemperature;
    parameter Real p1;
    parameter Real logBase;
    parameter Real celciusOffset;
    parameter Real hPa2Pa;
  equation
    satVaporPressureOut=hPa2Pa*(p1*exp((log(logBase)*((p2*roomTemperature)/(roomTemperature+celciusOffset)))));
  end SaturationVaporPressure;
end HumidifierSystemModel;
