model TotalSystemModel
  TotalSystem _TotalSystem;
  model TotalSystem
    Car car(g=g,velocity.start=0.0,velocity.fixed=true);
    parameter Real g(start=9.81,fixed=true);
    parameter Real airdensity(start=1.2,fixed=true);
    Environment env;
    AirLMTransmitter airlmtrans(crossSectionalArea=frontArea,airdensity=airdensity);
    parameter Surface frontArea(start=10.0,fixed=true);
  equation
    connect(car.pLMWheel,car.pLM);
    connect(env.pHRoad,car.pHWheel);
    connect(car.pLM,airlmtrans.pLM1);
    connect(airlmtrans.pLM2,env.pTAir);
    car.slope=env.road.slope;
  end TotalSystem;
  connector LMomFlowElement
    flow Force f;
    Velocity lV;
  end LMomFlowElement;
  type Velocity=Real(unit="m/s");
  type Force=Real(unit="N");
  type Density=Real(unit="kg/m^3");
  type Surface=Real(unit="m^2");
  connector EntropyFlowElement
    flow EntropyFlowRate sFR;
    Temperature t;
  end EntropyFlowElement;
  type Temperature=Real(unit="K");
  type EntropyFlowRate=Real(unit="W/K");
  type Acceleration=Real(unit="m/s^2");
  model AirLMTransmitter
    extends LMTransmitter;
    parameter Surface crossSectionalArea(start=10.0,fixed=true);
    parameter Real dragCoefficient(start=0.25,fixed=true);
    parameter Density airdensity(start=1.2,fixed=true);
  equation
    force=sign(velocity)*crossSectionalArea*airdensity*dragCoefficient*velocity^2/2;
    velocity=pLM1.lV-pLM2.lV;
    force=pLM1.f;
    pLM1.f+pLM2.f=0;
  end AirLMTransmitter;
  model LMTransmitter
    LMomFlowElement pLM1;
    LMomFlowElement pLM2;
    Force force;
    Velocity velocity;
  end LMTransmitter;
  model Environment
    Air air;
    Road road;
    LMomFlowElement pTAir;
    EntropyFlowElement pHRoad;
  equation
    connect(road.pH,pHRoad);
    connect(air.pT,pTAir);
    connect(pHRoad,road.pH);
  end Environment;
  model Road
    parameter Temperature temperature(start=293.0,fixed=true);
    EntropyFlowElement pH;
    Angle slope;
    parameter Time slopestop(start=160.0,fixed=true);
    parameter Angle incline(start=0.1,fixed=true);
    parameter Time slopestart(start=150.0,fixed=true);
    parameter Angle flat(start=0.0,fixed=true);
  equation
    pH.t=temperature;
    if time>slopestart and time<slopestop then
slope=incline;
else
slope=flat;
end if;
  end Road;
  type Angle=Real(unit="rad");
  type Time=Real(unit="s");
  model Air
    Velocity windvelocity(start=0.0,fixed=true);
    LMomFlowElement pT;
    parameter Velocity nowind(start=0.0,fixed=true);
    parameter Velocity windgust(start=-10.0,fixed=true);
    parameter Time starttime(start=100.0,fixed=true);
    parameter Time stoptime(start=120.0,fixed=true);
  equation
    pT.lV=windvelocity;
    if time>starttime and time<stoptime then
windvelocity=windgust;
else
windvelocity=nowind;
end if;
  end Air;
  model Car
    extends LMComponent;
    CruiseControlSystem ccs;
    Engine e;
    WheelSet w(rollingresistancecoefficient=rrc);
    parameter Mass mass(start=1000.0,fixed=true);
    parameter Acceleration g(start=9.81,fixed=true);
    Angle slope(start=0.0,fixed=true);
    Force nf;
    parameter Real rrc(start=0.01,fixed=true);
    LMomFlowElement pLMWheel;
    EntropyFlowElement pHWheel;
  equation
    connect(e.pAM,w.pAM);
    connect(ccs.speed,w.speed);
    connect(ccs.throttle,e.throttle);
    connect(w.pLM,pLMWheel);
    connect(w.pH,pHWheel);
    nf=w.normalforce;
    force=mass*der(velocity)+mass*g*sin(slope);
    nf=mass*g*cos(slope);
    force=pLM.f;
    velocity=pLM.lV;
  end Car;
  type Torque=Real(unit="N·m");
  connector AMomFlowElement
    flow Torque trq;
    AngularVelocity aV;
  end AMomFlowElement;
  type AngularVelocity=Real(unit="rad/s");
  type Mass=Real(unit="kg");
  model WheelSet
    extends AMLMConverterComponent;
    output Velocity speed;
    parameter Length radius(start=0.42,fixed=true);
    Force drivingforce;
    Force rollingresistance;
    parameter Real rollingresistancecoefficient;
    Force actualrollingresistance;
    Force normalforce;
    EntropyFlowElement pH;
    Temperature temperature;
    EntropyFlowRate entropyflowrate;
  equation
    force=drivingforce-actualrollingresistance;
    velocity=radius*angularVelocity;
    speed=velocity;
    drivingforce=torque/radius;
    rollingresistance=sign(drivingforce)*rollingresistancecoefficient*normalforce;
    if drivingforce>0 then
if drivingforce<rollingresistance then
actualrollingresistance=drivingforce;
else
actualrollingresistance=rollingresistance;
end if;
else
if drivingforce>rollingresistance then
actualrollingresistance=drivingforce;
else
actualrollingresistance=rollingresistance;
end if;
end if;
    temperature=pH.t;
    entropyflowrate=pH.sFR;
    entropyflowrate*temperature=actualrollingresistance*velocity;
    angularVelocity=pAM.aV;
    torque=pAM.trq;
    velocity=pLM.lV;
    force=pLM.f;
  end WheelSet;
  type Length=Real(unit="m");
  model AMLMConverterComponent
    AMomFlowElement pAM;
    LMomFlowElement pLM;
    AngularVelocity angularVelocity;
    Force force;
    Torque torque;
    Velocity velocity;
  end AMLMConverterComponent;
  model Engine
    extends AMComponent;
    input Torque throttle;
  equation
    torque=throttle;
    pAM.aV=angularVelocity;
    pAM.trq=torque;
  end Engine;
  model AMComponent
    AngularVelocity angularVelocity;
    Torque torque;
    AMomFlowElement pAM;
  end AMComponent;
  model CruiseControlSystem
    input Velocity speed;
    output Torque throttle;
    parameter Velocity target(start=27.0,fixed=true);
    parameter VelocityCoefficient kp(start=200.0,fixed=true);
    Position x;
    parameter PositionCoefficient ki(start=30.0,fixed=true);
    parameter Torque min(start=0.0,fixed=true);
    parameter Torque max(start=1000.0,fixed=true);
    Torque trq;
    Velocity v;
  equation
    der(x)=v;
    trq=kp*v+ki*x;
    if trq<min then
throttle=min;
elseif trq>max then
throttle=max;
else
throttle=trq;
end if;
    v=target-speed;
  end CruiseControlSystem;
  type PositionCoefficient=Real(unit="N*m/m");
  type Position=Real(unit="m");
  type VelocityCoefficient=Real(unit="N*s");
  model LMComponent
    LMomFlowElement pLM;
    Velocity velocity;
    Force force;
  end LMComponent;
end TotalSystemModel;
