model EnvironmentModel
  Environment _Environment;
  model Environment
    Room room;
    HumidifierSystem humidifiersystem;
  equation
    connect(room.vapor_in,humidifiersystem.vapor_out);
    connect(humidifiersystem.humidity_in,room.humidity_out);
  end Environment;
  model HumidifierSystem
    input Real humidity_in;
    output Real vapor_out;
    HeaterControl heatercontrol;
    UsageScenario usage;
    WaterTank watertank;
    Control control;
    VaporGenerationPlant vaporgenerationplant;
    parameter Real target_humidity(start=50.0,fixed=true);
    Modelica.Blocks.Sources.Constant targetHumidity(k=target_humidity);
  equation
    connect(heatercontrol.humidity_in,humidity_in);
    connect(control.mode,heatercontrol.mode_in);
    connect(vaporgenerationplant.temperature_out,control.water_temperature_in);
    connect(vapor_out,vaporgenerationplant.vapor_out);
    connect(watertank.water_volume_out,control.water_volume_in);
    connect(vaporgenerationplant.fan_wat_in,control.fan_power_out);
    connect(vaporgenerationplant.vapor_out,watertank.consumption_in);
    connect(heatercontrol.heater_power_ratio_out,vaporgenerationplant.heater_power_ratio_in);
    connect(control.swtch,usage.swtch);
    connect(heatercontrol.target_humidity_in,targetHumidity.y);
  end HumidifierSystem;
  model VaporGenerationPlant
    input Real fan_wat_in;
    input Real heater_power_ratio_in;
    output Real temperature_out;
    output Real vapor_out;
    Heating h;
    Evaporation e;
    Radiation r;
    Modelica.Blocks.Math.Add s1;
    parameter Real max_heater_power(start=400.0,fixed=true);
    Modelica.Blocks.Sources.Constant maxPower(k=max_heater_power);
    Modelica.Blocks.Math.Product pro1;
  equation
    connect(temperature_out,h.temperature_out);
    connect(r.fan_wat_in,fan_wat_in);
    connect(h.temperature_out,r.temperature_in);
    connect(h.temperature_out,e.temperature_in);
    connect(vapor_out,e.vapor_out);
    connect(r.radiation_wat_out,s1.u2);
    connect(h.energy_wat_in,s1.y);
    connect(s1.y,e.energy_wat_in);
    connect(heater_power_ratio_in,pro1.u1);
    connect(pro1.y,s1.u1);
    connect(pro1.u2,maxPower.y);
  end VaporGenerationPlant;
  model Radiation
    input Real temperature_in;
    input Real fan_wat_in;
    output Real radiation_wat_out;
    parameter Real room_temperature(start=30.0,fixed=true);
    Modelica.Blocks.Math.Add s1;
    Modelica.Blocks.Math.Product p1;
    parameter Real radiation_factor(start=0.1,fixed=true);
    Modelica.Blocks.Math.Add s2;
    parameter Real fan_efficiency(start=0.1,fixed=true);
    Modelica.Blocks.Sources.Constant roomTmp(k=room_temperature);
    Modelica.Blocks.Sources.Constant radiationFactor(k=radiation_factor);
    Modelica.Blocks.Sources.Constant fanEfficiency(k=fan_efficiency);
    Modelica.Blocks.Math.Product pro1;
  equation
    connect(s1.u1,temperature_in);
    connect(p1.u1,s1.y);
    connect(radiation_wat_out,p1.y);
    connect(roomTmp.y,s1.u2);
    connect(radiationFactor.y,s2.u2);
    connect(s2.y,p1.u2);
    connect(fan_wat_in,pro1.u1);
    connect(pro1.u2,fanEfficiency.y);
    connect(pro1.y,s2.u1);
  end Radiation;
  model Evaporation
    input Real temperature_in;
    input Real energy_wat_in;
    output Real vapor_out;
    Modelica.Blocks.Nonlinear.Limiter sat1(uMin=0.0,uMin.fixed=true,uMax=1.0,uMax.fixed=true);
    Modelica.Blocks.Logical.Switch sw1;
    Modelica.Blocks.Math.Gain litpsec2mlitphour(k=3600000.0,k.fixed=true);
    parameter Real boiling_temperature(start=99.99,fixed=true);
    parameter Real no_power(start=0.0,fixed=true);
    parameter Real room_temperature(start=20.0,fixed=true);
    Modelica.Blocks.Sources.Constant boilingTmp(k=boiling_temperature);
    Modelica.Blocks.Sources.Constant noPwr(k=no_power);
    Modelica.Blocks.Sources.Constant roomTemperature(k=room_temperature);
    EvaporationCalculation ec;
    Modelica.Blocks.Logical.GreaterEqual ge1;
  equation
    connect(vapor_out,litpsec2mlitphour.y);
    connect(litpsec2mlitphour.u,sw1.y);
    connect(sat1.y,sw1.u1);
    connect(noPwr.y,sw1.u3);
    connect(ec.energy,energy_wat_in);
    connect(roomTemperature.y,ec.environment_temperature);
    connect(sat1.u,ec.vapor);
    connect(ge1.y,sw1.u2);
    connect(ge1.u1,temperature_in);
    connect(ge1.u2,boilingTmp.y);
  end Evaporation;
  model EvaporationCalculation
    parameter Real evaporation_heat(start=2270.0,fixed=true);
    parameter Real specific_heat(start=1.996,fixed=true);
    parameter Real boiling_temperature(start=100.0,fixed=true);
    input Real energy;
    input Real environment_temperature;
    output Real vapor;
    Modelica.Blocks.Sources.Constant specificHeat(k=specific_heat);
    Modelica.Blocks.Sources.Constant boilingTemperature(k=boiling_temperature);
    Modelica.Blocks.Sources.Constant evaporationHeat(k=evaporation_heat);
    Modelica.Blocks.Math.Add sub1;
    Modelica.Blocks.Math.Product prod1;
    Modelica.Blocks.Math.Add sum1;
    Modelica.Blocks.Math.Division div1;
  equation
    connect(sub1.u1,boilingTemperature.y);
    connect(sub1.u2,environment_temperature);
    connect(sub1.y,prod1.u2);
    connect(specificHeat.y,prod1.u1);
    connect(prod1.y,sum1.u1);
    connect(evaporationHeat.y,sum1.u2);
    connect(sum1.y,div1.u2);
    connect(energy,div1.u1);
    connect(div1.y,vapor);
  end EvaporationCalculation;
  model Heating
    input Real energy_wat_in;
    output Real temperature_out;
    Modelica.Blocks.Continuous.Integrator i1;
    Modelica.Blocks.Nonlinear.Limiter sat1(uMin=0.0,uMin.fixed=true,uMax=100.0,uMax.fixed=true);
    TemperatureIncrease ti;
  equation
    connect(i1.y,sat1.u);
    connect(temperature_out,sat1.y);
    connect(ti.energy,energy_wat_in);
    connect(i1.u,ti.increase);
  end Heating;
  model TemperatureIncrease
    input Real energy;
    output Real increase;
    parameter Real specific_heat(start=4180.0,fixed=true);
    parameter Real water_volume(start=0.1,fixed=true);
    Modelica.Blocks.Sources.Constant specificHeat(k=specific_heat);
    Modelica.Blocks.Sources.Constant waterVolume(k=water_volume);
    Modelica.Blocks.Math.Product pro1;
    Modelica.Blocks.Math.Division div1;
  equation
    connect(pro1.u1,specificHeat.y);
    connect(waterVolume.y,pro1.u2);
    connect(div1.u1,energy);
    connect(pro1.y,div1.u2);
    connect(div1.y,increase);
  end TemperatureIncrease;
  model Control
    input Real water_volume_in;
    input Real water_temperature_in;
    output Real mode;
    output Real fan_power_out;
    input Real swtch;
    parameter Real safe_temperature(start=50.0,fixed=true);
    ControlStateMachine _ControlStateMachine;
    block ControlStateMachine
      Modelica.StateGraph.InitialStep ControlStateMachine_region0_pseudostate7(nIn=0,nOut=1);
      Modelica.StateGraph.Step Off(nIn=2,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=2);
      Modelica.StateGraph.Step WarmUp(nIn=1,nOut=2);
      Modelica.StateGraph.Step CoolDown(nIn=3,nOut=1);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition0(condition=true);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition1(condition=swtch==1);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition2(condition=swtch==0);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition3(condition=water_volume_in==0);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition4(condition=water_temperature_in>=99);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition5(condition=water_temperature_in<=safe_temperature);
      Modelica.StateGraph.Transition ControlStateMachine_region0_transition6(condition=swtch==0);
      Real water_volume_in;
      Real water_temperature_in;
      Real mode;
      Real fan_power_out;
      Real swtch;
      Real safe_temperature;
    equation
      connect(ControlStateMachine_region0_pseudostate7.outPort[1], ControlStateMachine_region0_transition0.inPort);
      connect(ControlStateMachine_region0_transition0.outPort, Off.inPort[1]);
      connect(Off.outPort[1], ControlStateMachine_region0_transition1.inPort);
      connect(ControlStateMachine_region0_transition1.outPort, WarmUp.inPort[1]);
      connect(On.outPort[1], ControlStateMachine_region0_transition2.inPort);
      connect(ControlStateMachine_region0_transition2.outPort, CoolDown.inPort[1]);
      connect(On.outPort[2], ControlStateMachine_region0_transition3.inPort);
      connect(ControlStateMachine_region0_transition3.outPort, CoolDown.inPort[2]);
      connect(WarmUp.outPort[1], ControlStateMachine_region0_transition4.inPort);
      connect(ControlStateMachine_region0_transition4.outPort, On.inPort[1]);
      connect(CoolDown.outPort[1], ControlStateMachine_region0_transition5.inPort);
      connect(ControlStateMachine_region0_transition5.outPort, Off.inPort[2]);
      connect(WarmUp.outPort[2], ControlStateMachine_region0_transition6.inPort);
      connect(ControlStateMachine_region0_transition6.outPort, CoolDown.inPort[3]);
    algorithm
      if Off.active then mode:=0;fan_power_out:=0; end if;
      if On.active then mode:=1;fan_power_out:=1; end if;
      if WarmUp.active then mode:=1;fan_power_out:=0; end if;
      if CoolDown.active then mode:=0;fan_power_out:=1; end if;
    end ControlStateMachine;
  equation
    water_volume_in=_ControlStateMachine.water_volume_in;
    water_temperature_in=_ControlStateMachine.water_temperature_in;
    mode=_ControlStateMachine.mode;
    fan_power_out=_ControlStateMachine.fan_power_out;
    swtch=_ControlStateMachine.swtch;
    safe_temperature=_ControlStateMachine.safe_temperature;
  end Control;
  model WaterTank
    output Real water_volume_out;
    input Real consumption_in;
    Modelica.Blocks.Sources.Constant tankVolume(k=tank_volume);
    Modelica.Blocks.Math.Add sub1;
    Modelica.Blocks.Continuous.Integrator int;
    parameter Real tank_volume(start=50000.0,fixed=true);
    Modelica.Blocks.Nonlinear.Limiter sat(uMax=tank_volume,uMin=0.0,uMin.fixed=true);
    Modelica.Blocks.Sources.Constant litpsec2mlitphour(k=3600000.0,k.fixed=true);
    Modelica.Blocks.Math.Division div;
  equation
    connect(sub1.u1,tankVolume.y);
    connect(sub1.y,water_volume_out);
    connect(int.y,sat.u);
    connect(sat.y,sub1.u2);
    connect(div.y,int.u);
    connect(div.u2,litpsec2mlitphour.y);
    connect(div.u1,consumption_in);
  end WaterTank;
  model UsageScenario
    output Real swtch;
    UsageScenarioStateMachine _UsageScenarioStateMachine;
    block UsageScenarioStateMachine
      Modelica.StateGraph.InitialStep UsageScenarioStateMachine_region0_pseudostate3(nIn=0,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=1);
      Modelica.StateGraph.Step Off(nIn=1,nOut=0);
      Modelica.StateGraph.Step Started(nIn=1,nOut=1);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition0(condition=time>300);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition1(condition=time>3300);
      Modelica.StateGraph.Transition UsageScenarioStateMachine_region0_transition2(condition=true);
      Real swtch;
    equation
      connect(Started.outPort[1], UsageScenarioStateMachine_region0_transition0.inPort);
      connect(UsageScenarioStateMachine_region0_transition0.outPort, On.inPort[1]);
      connect(On.outPort[1], UsageScenarioStateMachine_region0_transition1.inPort);
      connect(UsageScenarioStateMachine_region0_transition1.outPort, Off.inPort[1]);
      connect(UsageScenarioStateMachine_region0_pseudostate3.outPort[1], UsageScenarioStateMachine_region0_transition2.inPort);
      connect(UsageScenarioStateMachine_region0_transition2.outPort, Started.inPort[1]);
    algorithm
      if On.active then swtch:=1; end if;
      if Off.active then swtch:=0; end if;
    end UsageScenarioStateMachine;
  equation
    swtch=_UsageScenarioStateMachine.swtch;
  end UsageScenario;
  model HeaterControl
    input Real target_humidity_in;
    input Real mode_in;
    input Real humidity_in;
    output Real heater_power_ratio_out;
    parameter Real pr_low(start=0.0,fixed=true);
    parameter Real pr_high(start=1.0,fixed=true);
    parameter Real threshold(start=1.0,fixed=true);
    HeaterControlSM _HeaterControlSM;
    block HeaterControlSM
      Modelica.StateGraph.InitialStep HeaterControlSM_region0_pseudostate4(nIn=0,nOut=1);
      Modelica.StateGraph.Step Off(nIn=3,nOut=1);
      Modelica.StateGraph.Step On(nIn=1,nOut=2);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition0(condition=true);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition1(condition=mode_in==1 and humidity_in<target_humidity_in-threshold);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition2(condition=mode_in==0);
      Modelica.StateGraph.Transition HeaterControlSM_region0_transition3(condition=humidity_in>target_humidity_in);
      Real target_humidity_in;
      Real mode_in;
      Real humidity_in;
      Real heater_power_ratio_out;
      Real pr_low;
      Real pr_high;
      Real threshold;
    equation
      connect(HeaterControlSM_region0_pseudostate4.outPort[1], HeaterControlSM_region0_transition0.inPort);
      connect(HeaterControlSM_region0_transition0.outPort, Off.inPort[1]);
      connect(Off.outPort[1], HeaterControlSM_region0_transition1.inPort);
      connect(HeaterControlSM_region0_transition1.outPort, On.inPort[1]);
      connect(On.outPort[1], HeaterControlSM_region0_transition2.inPort);
      connect(HeaterControlSM_region0_transition2.outPort, Off.inPort[2]);
      connect(On.outPort[2], HeaterControlSM_region0_transition3.inPort);
      connect(HeaterControlSM_region0_transition3.outPort, Off.inPort[3]);
    algorithm
      if Off.active then heater_power_ratio_out:=pr_low; end if;
      if On.active then heater_power_ratio_out:=pr_high; end if;
    end HeaterControlSM;
  equation
    target_humidity_in=_HeaterControlSM.target_humidity_in;
    mode_in=_HeaterControlSM.mode_in;
    humidity_in=_HeaterControlSM.humidity_in;
    heater_power_ratio_out=_HeaterControlSM.heater_power_ratio_out;
    pr_low=_HeaterControlSM.pr_low;
    pr_high=_HeaterControlSM.pr_high;
    threshold=_HeaterControlSM.threshold;
  end HeaterControl;
  model Room
    output Real humidity_out;
    input Real vapor_in;
    SaturationVaporPressure svp;
    RelativeHumidity rh;
    Modelica.Blocks.Math.Gain mLpH2mLpsec(k=2.8E-4,k.fixed=true);
    Modelica.Blocks.Math.Gain toPercent(k=100.0,k.fixed=true);
  equation
    connect(mLpH2mLpsec.u,vapor_in);
    connect(humidity_out,toPercent.y);
    connect(rh.saturation_vapor_pressure_in,svp.saturation_vapor_pressure_out);
    connect(rh.vapor_in,mLpH2mLpsec.y);
    connect(rh.humidity_out,toPercent.u);
    connect(rh.humidity_out,rh.humidity_in);
  end Room;
  model RelativeHumidity
    input Real vapor_in;
    input Real humidity_in;
    input Real saturation_vapor_pressure_in;
    output Real humidity_out;
    Modelica.Blocks.Math.Division div1;
    Modelica.Blocks.Math.Add sub1;
    Modelica.Blocks.Continuous.Integrator int1;
    parameter Real room_volume(start=25000.0,fixed=true);
    Modelica.Blocks.Nonlinear.Limiter sat1(uMin=0.0,uMin.fixed=true,uMax=1.0,uMax.fixed=true);
    HumidityBalance hb;
    VaporPressureCalculation vpc;
    Modelica.Blocks.Sources.Constant roomVolume(k=room_volume);
  equation
    connect(saturation_vapor_pressure_in,div1.u2);
    connect(int1.u,sub1.y);
    connect(sub1.u1,div1.y);
    connect(sat1.u,int1.y);
    connect(sat1.y,humidity_out);
    connect(vapor_in,vpc.vapor);
    connect(vpc.pressure,div1.u1);
    connect(roomVolume.y,vpc.volume);
    connect(hb.humidity,humidity_in);
    connect(hb.change,sub1.u2);
    connect(roomVolume.y,hb.volume);
  end RelativeHumidity;
  model VaporPressureCalculation
    parameter Real room_temperature(start=30.0,fixed=true);
    parameter Real gas_const(start=8.314,fixed=true);
    parameter Real molecular_w(start=18.015,fixed=true);
    parameter Real celcius_offset(start=273.0,fixed=true);
    input Real vapor;
    output Real pressure;
    Modelica.Blocks.Sources.Constant roomTemperature(k=room_temperature);
    Modelica.Blocks.Sources.Constant gasConst(k=gas_const);
    Modelica.Blocks.Sources.Constant molecularW(k=molecular_w);
    Modelica.Blocks.Sources.Constant celciusOffset(k=celcius_offset);
    Modelica.Blocks.Math.Product pro1;
    Modelica.Blocks.Math.Add sum1;
    Modelica.Blocks.Math.Division div1;
    Modelica.Blocks.Math.Product pro2;
    Modelica.Blocks.Math.Product pro3;
    input Real volume;
  equation
    connect(pro3.y,pressure);
    connect(pro3.u1,vapor);
    connect(pro2.y,pro3.u2);
    connect(gasConst.y,pro2.u1);
    connect(div1.y,pro2.u2);
    connect(celciusOffset.y,sum1.u2);
    connect(roomTemperature.y,sum1.u1);
    connect(sum1.y,div1.u1);
    connect(pro1.y,div1.u2);
    connect(molecularW.y,pro1.u1);
    connect(volume,pro1.u2);
  end VaporPressureCalculation;
  model HumidityBalance
    parameter Real air_exchange_rate(start=1.0E-8,fixed=true);
    parameter Real env_humidity(start=0.35,fixed=true);
    Modelica.Blocks.Sources.Constant envHumidity(k=env_humidity);
    input Real humidity;
    input Real volume;
    output Real change;
    Modelica.Blocks.Math.Product pro1;
    Modelica.Blocks.Math.Add sub1;
    Modelica.Blocks.Sources.Constant airExchangeRate(k=air_exchange_rate);
    Modelica.Blocks.Math.Product pro2;
  equation
    connect(sub1.u1,humidity);
    connect(envHumidity.y,sub1.u2);
    connect(volume,pro1.u1);
    connect(airExchangeRate.y,pro1.u2);
    connect(pro2.u1,sub1.y);
    connect(pro1.y,pro2.u2);
    connect(change,pro2.y);
  end HumidityBalance;
  model SaturationVaporPressure
    output Real saturation_vapor_pressure_out;
    parameter Real room_temperature(start=30.0,fixed=true);
    Modelica.Blocks.Math.Gain hPa2Pa(k=100.0,k.fixed=true);
    parameter Real p2(start=7.5,fixed=true);
    parameter Real p1(start=6.11,fixed=true);
    parameter Real log_base(start=10.0,fixed=true);
    parameter Real celcius_offset(start=273.0,fixed=true);
    Modelica.Blocks.Sources.Constant roomTemperature(k=room_temperature);
    Modelica.Blocks.Sources.Constant c2(k=p2);
    Modelica.Blocks.Sources.Constant c1(k=p1);
    Modelica.Blocks.Sources.Constant logBase(k=log_base);
    Modelica.Blocks.Sources.Constant celciusOffset(k=celcius_offset);
    Modelica.Blocks.Math.Add sum1;
    Modelica.Blocks.Math.Division div1;
    Modelica.Blocks.Math.Product pro1;
    Modelica.Blocks.Math.Product pro3;
    Modelica.Blocks.Math.Product pro2;
    Modelica.Blocks.Math.Exp exp1;
    Modelica.Blocks.Math.Log log1;
  equation
    connect(hPa2Pa.y,saturation_vapor_pressure_out);
    connect(pro3.u1,c1.y);
    connect(pro3.y,hPa2Pa.u);
    connect(exp1.y,pro3.u2);
    connect(pro2.y,exp1.u);
    connect(logBase.y,log1.u);
    connect(log1.y,pro2.u2);
    connect(pro1.u1,c2.y);
    connect(pro1.u2,roomTemperature.y);
    connect(pro1.y,div1.u1);
    connect(sum1.y,div1.u2);
    connect(celciusOffset.y,sum1.u2);
    connect(div1.y,pro2.u1);
    connect(sum1.u1,roomTemperature.y);
  end SaturationVaporPressure;
end EnvironmentModel;
