model CircuitTemperatureModel
  CircuitTemperature _CircuitTemperature;
  model CircuitTemperature
    Source s;
    NP0Capacitor c(C.start=0.01,C.fixed=true,t.start=0.0,t.fixed=true);
    NickelResistor ri(R.start=10.0,R.fixed=true,t.start=0.0,t.fixed=true);
    Inductor i(L.start=0.1,L.fixed=true);
    Ground g;
    parameter Real temperature(start=50.0,fixed=true);
    NickelResistor rc(R.start=20.0,R.fixed=true,t.start=0.0,t.fixed=true);
  equation
    connect(ri.n,i.p);
    connect(g.p,s.n);
    connect(s.p,rc.p);
    connect(ri.p,rc.p);
    connect(i.n,c.n);
    connect(rc.n,c.p);
    connect(c.n,s.n);
  end CircuitTemperature;
  connector ChargeFlowElement
    flow Current i;
    Voltage v;
  end ChargeFlowElement;
  type Voltage=Real(unit="V");
  type Current=Real(unit="A");
  model NickelResistor
    extends TwoPinElectricalComponent;
    parameter Resistance R;
    parameter Real t;
  equation
    vDrop=iThru*R*(1+0.005866*(t-20));
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end NickelResistor;
  type Resistance=Real(unit="Ohm");
  model TwoPinElectricalComponent
    flow Current iThru;
    Voltage vDrop;
    ChargeFlowElement p;
    ChargeFlowElement n;
  end TwoPinElectricalComponent;
  type Voltage=Real(unit="V");
  type Current=Real(unit="A");
  model Ground
    ChargeFlowElement p;
  equation
    p.v=0;
  end Ground;
  model Inductor
    extends TwoPinElectricalComponent;
    parameter Inductance L;
  equation
    L*der(iThru)=vDrop;
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Inductor;
  type Inductance=Real(unit="H");
  model NP0Capacitor
    extends TwoPinElectricalComponent;
    parameter Capacitance C;
    parameter Real t;
  equation
    iThru=C*(1+0.00003*(t-25))*der(vDrop);
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end NP0Capacitor;
  type Capacitance=Real(unit="F");
  model Source
    extends TwoPinElectricalComponent;
    Time t;
    parameter Voltage amp(start=220.0,fixed=true);
  equation
    t=time;
    vDrop=amp*sin(2*3.14*t);
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Source;
  type Time=Real(unit="s");
end CircuitTemperatureModel;
