package com.engisis.sysphs.util;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.resource.UMLResource;

/**
 * Generates id mappings to be added to properties.config
 * 
 * @author barbau
 *
 */
public class MappingGenerator
{
    public static final Logger log = Logger.getLogger(MappingGenerator.class);
    
    
    private Hashtable<String, TreeSet<NamedElement>> resources;
    private Comparator<NamedElement> comp;
    private ResourceSet rs = null;
    
    public MappingGenerator() throws FileNotFoundException
    {
        resources = new Hashtable<String, TreeSet<NamedElement>>();
        comp = new Comparator<NamedElement>()
        {
            @Override
            public int compare(NamedElement o1, NamedElement o2)
            {
                return o1.getQualifiedName().compareTo(o2.getQualifiedName());
            }
        };
        rs = EMFUtil.createBasicResourceSet();
    }
    
    public void map()
    {
        // resources files (sources of IDs): SysML_1.3.xmi, SysML.xmi
        // sources: resource file -> URI. Idenfifies elements from resource file
        // as URI#id
        String[][] sources = new String[][] { { "SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20120401/SysML.xmi" },
                { "SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20131201/SysML.xmi" },
                { "SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20150709/SysML.xmi" }, 
                { "SysML_1.4.xmi", "http://www.omg.org/spec/SysML/20150709/SysML.xmi" }, };
        
        String[] used = new String[] { "SysML.xmi", "http://www.omg.org/spec/SysML/20161101/SysML.xmi" };
        
        String[][] targets = new String[][] {
                { "MD", "SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20120401/SysML.xmi" },
                { "OMG", "SysML.xmi", "http://www.omg.org/spec/SysML/20161101/SysML.xmi" }, };
        
        // create resource set
        
        TreeSet<NamedElement> tsUsed = getTreeSet(used[0]);

        // map elements from sources to used one
        for (int i = 0; i < sources.length; i++)
        {
            TreeSet<NamedElement> tsSource = getTreeSet(sources[i][0]);
            // simple case
            if (tsSource == tsUsed)
            {
                for (NamedElement ne : tsUsed)
                {
                    String id = ((UMLResource) ne.eResource()).getID(ne);
                    System.out.println("idmap_r\t" + sources[i][1] + "#" + id + "\t" + used[1] + "#" + id);
                }
            }
            // second treeset
            else
            {
                // intersect, map intersection
                Iterator<NamedElement> it0 = tsSource.iterator();
                Iterator<NamedElement> it1 = tsUsed.iterator();
                if (it0.hasNext() && it1.hasNext())
                {
                    NamedElement ne0 = it0.next();
                    NamedElement ne1 = it1.next();
                    while (true)
                    {
                        int c = comp.compare(ne0, ne1);
                        if (c == 0)
                        {
                            String idSource = ((UMLResource)ne0.eResource()).getID(ne0);
                            String idUsed = ((UMLResource)ne1.eResource()).getID(ne1);
                            System.out.println("idmap_r\t" + sources[i][1] + "#" + idSource + "\t" + used[1] + "#"
                                        + idUsed);
                            if (!it0.hasNext() || !it1.hasNext())
                                break;
                            ne0 = it0.next();
                            ne1 = it1.next();
                        }
                        else if (c > 0)
                        {
                            if (!it1.hasNext())
                                break;
                            ne1 = it1.next();
                        }
                        else
                        {
                            if (!it0.hasNext())
                                break;
                            ne0 = it0.next();
                        }
                    }
                }
            }
        }
        
        // map elements from used ones to target ones
        for (int i = 0; i < targets.length; i++)
        {
            TreeSet<NamedElement> tsTarget = getTreeSet(targets[i][1]);
            // simple case
            if (tsTarget == tsUsed)
            {
                for (NamedElement ne : tsUsed)
                {
                    String id = ((UMLResource) ne.eResource()).getID(ne);
                    System.out.println("idmap_w\t" + targets[i][0] + "\t" + used[1] + "#" + id + "\t" + targets[i][2] + "#" + id);
                }
            }
            // second treeset
            else
            {
                // intersect, map intersection
                Iterator<NamedElement> it0 = tsTarget.iterator();
                Iterator<NamedElement> it1 = tsUsed.iterator();
                if (it0.hasNext() && it1.hasNext())
                {
                    NamedElement ne0 = it0.next();
                    NamedElement ne1 = it1.next();
                    while (true)
                    {
                        int c = comp.compare(ne0, ne1);
                        if (c == 0)
                        {
                            String idTarget = ((UMLResource)ne0.eResource()).getID(ne0);
                            String idUsed = ((UMLResource)ne1.eResource()).getID(ne1);
                            System.out.println("idmap_w\t" + targets[i][0] + "\t" + used[1] + "#" + idUsed + "\t" + targets[i][2] + "#"
                                        + idTarget);
                            if (!it0.hasNext() || !it1.hasNext())
                                break;
                            ne0 = it0.next();
                            ne1 = it1.next();
                        }
                        else if (c > 0)
                        {
                            if (!it1.hasNext())
                                break;
                            ne1 = it1.next();
                        }
                        else
                        {
                            if (!it0.hasNext())
                                break;
                            ne0 = it0.next();
                        }
                    }
                }
            }
        }
        
    }
    
    private TreeSet<NamedElement> getTreeSet(String resourcefile)
    {
        TreeSet<NamedElement> ret = resources.get(resourcefile);
        if (ret == null)
        {
            ret = new TreeSet<NamedElement>(comp);
            URL res = MappingGenerator.class.getResource("/" + resourcefile);
            log.info("Populating " + res + " for " + resourcefile);
            
            UMLResource r0 = (UMLResource) rs.createResource(URI.createURI(res.toString()));
            try
            {
                r0.load(null);
            }
            catch (Exception e)
            {
                log.error(e);
            }
            // put named elements in sorted list
            TreeIterator<EObject> ti0 = r0.getAllContents();
            while (ti0.hasNext())
            {
                EObject eo = ti0.next();
                if (eo instanceof NamedElement)
                {
                    NamedElement ne = (NamedElement) eo;
                    if (ne.getName() != null)
                        ret.add(ne);
                }
            }
            log.info(ret.size() + " elements added");
            resources.put(resourcefile, ret);
        }
        return ret;
    }
    
    public static void main(String[] args)
    {
        try
        {
            MappingGenerator mg = new MappingGenerator();
            mg.map();
        }
        catch (FileNotFoundException e)
        {
            log.error("Error", e);
        }
    }
}
