package com.engisis.sysphs.serialization.modelica;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

import org.apache.log4j.Logger;

import com.engisis.sysphs.language.modelica.MModel;
import com.engisis.sysphs.util.Dispatcher;

/**
 * Class in charge of serializing Modelica models
 * 
 * @author barbau
 *
 */
public class ModelicaSerializer
{
    private static final Logger log = Logger.getLogger(ModelicaSerializer.class);
    
    /**
     * Serialize the given model
     * 
     * @param directory
     *            output directory
     * @param mmodel
     *            Modelica model to serialize
     * @param suffix
     *            suffix added to the file name
     * @return the full path of the generated file
     * @throws IOException
     */
    public String serialize(String directory, MModel mmodel, String suffix) throws IOException
    {
        String filename = directory + File.separator + mmodel.getName() + suffix + ".mo";
        log.debug("Saving model to " + filename);
        OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(filename), StandardCharsets.UTF_8);
        
        Dispatcher dispatcher = new Dispatcher();
        ModelicaWriter ms = new ModelicaWriter(osw);
        dispatcher.addVisitor(ms);
        mmodel.accept(dispatcher);
        osw.close();
        return filename;
    }
    
}
