/**
 */
package com.engisis.sysphs.language.stateflow;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SLink Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.stateflow.SLinkNode#getOwningTreeNode <em>Owning Tree Node</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSLinkNode()
 * @model kind="class" abstract="true"
 * @generated
 */
public abstract class SLinkNode extends SIdentifiedElement
{
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SLinkNode()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return StateflowPackage.Literals.SLINK_NODE;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Tree Node</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.stateflow.STreeNode#getLinkNode <em>Link Node</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Tree Node</em>' container reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Tree Node</em>' container reference.
     * @see #setOwningTreeNode(STreeNode)
     * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSLinkNode_OwningTreeNode()
     * @see com.engisis.sysphs.language.stateflow.STreeNode#getLinkNode
     * @model opposite="linkNode" transient="false"
     * @generated
     */
    public STreeNode getOwningTreeNode()
    {
        if (eContainerFeatureID() != StateflowPackage.SLINK_NODE__OWNING_TREE_NODE) return null;
        return (STreeNode)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningTreeNode(STreeNode newOwningTreeNode, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningTreeNode, StateflowPackage.SLINK_NODE__OWNING_TREE_NODE, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.stateflow.SLinkNode#getOwningTreeNode <em>Owning Tree Node</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning Tree Node</em>' container reference.
     * @see #getOwningTreeNode()
     * @generated
     */
    public void setOwningTreeNode(STreeNode newOwningTreeNode)
    {
        if (newOwningTreeNode != eInternalContainer() || (eContainerFeatureID() != StateflowPackage.SLINK_NODE__OWNING_TREE_NODE && newOwningTreeNode != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningTreeNode))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningTreeNode != null)
                msgs = ((InternalEObject)newOwningTreeNode).eInverseAdd(this, StateflowPackage.STREE_NODE__LINK_NODE, STreeNode.class, msgs);
            msgs = basicSetOwningTreeNode(newOwningTreeNode, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningTreeNode((STreeNode)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                return basicSetOwningTreeNode(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                return eInternalContainer().eInverseRemove(this, StateflowPackage.STREE_NODE__LINK_NODE, STreeNode.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                return getOwningTreeNode();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                setOwningTreeNode((STreeNode)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                setOwningTreeNode((STreeNode)null);
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case StateflowPackage.SLINK_NODE__OWNING_TREE_NODE:
                return getOwningTreeNode() != null;
        }
        return super.eIsSet(featureID);
    }
    
    public SChart getChart()
    {
        STreeNode owner = getOwningTreeNode();
        if (owner == null)
            return null;
        if (owner instanceof SChart)
            return (SChart) owner;
        return ((SState) owner).getChart();
    }
    
    public String getLinkNodeString()
    {
        // owner, next, previous
        int owner = 0, pre = 0, nex = 0;
        
        if (getOwningTreeNode() != null)
        {
            owner = getOwningTreeNode().getId();
            // get list of node of the same type
            List<SLinkNode> list = new LinkedList<SLinkNode>();
            for (SLinkNode slinknode : getOwningTreeNode().getLinkNode())
                if (slinknode.getClass() == this.getClass())
                    list.add(slinknode);
            
            for (int i = 0; i < list.size(); i++)
            {
                if (list.get(i) == this)
                {
                    if (i - 1 >= 0)
                        pre = list.get(i - 1).getId();
                    if (i + 1 < list.size())
                        nex = list.get(i + 1).getId();
                    break;
                }
            }
        }
        
        return "[" + owner + " " + pre + " " + nex + "]";
    }
    
    public void setID()
    {
    	SStateflow stateflow = getStateflow();
    	if (stateflow != null)
    		setId(stateflow.generateID());
    	else
    		throw new RuntimeException("Wrong usage!!!");
    }
    
    public SStateflow getStateflow()
    {
    	if (getOwningTreeNode() != null)
    		return getOwningTreeNode().getStateflow();
    	return null;
    }
    
} // SLinkNode
