/**
 */
package com.engisis.sysphs.language.modelica;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>MClass</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getOwnedClasses <em>Owned Classes</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getComponents <em>Components</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getEquations <em>Equations</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getExtensions <em>Extensions</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getOwningClass <em>Owning Class</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.modelica.MClass#getAlgorithms <em>Algorithms</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass()
 * @model kind="class"
 * @generated
 */
public class MClass extends MNamedElement
{
    /**
     * The cached value of the '{@link #getOwnedClasses() <em>Owned Classes</em>}' containment reference list.
     * <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * @see #getOwnedClasses()
     * @generated
     * @ordered
     */
    protected EList<MClass> ownedClasses;
    
    /**
     * The cached value of the '{@link #getComponents() <em>Components</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getComponents()
     * @generated
     * @ordered
     */
    protected EList<MComponent> components;
    
    /**
     * The cached value of the '{@link #getEquations() <em>Equations</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getEquations()
     * @generated
     * @ordered
     */
    protected EList<MEquation> equations;
    
    /**
     * The cached value of the '{@link #getExtensions() <em>Extensions</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getExtensions()
     * @generated
     * @ordered
     */
    protected EList<MExtension> extensions;
    
    /**
     * The cached value of the '{@link #getAlgorithms() <em>Algorithms</em>}' reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getAlgorithms()
     * @generated
     * @ordered
     */
    protected EList<MAlgorithm> algorithms;
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected MClass()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return ModelicaPackage.Literals.MCLASS;
    }
    
    /**
     * Returns the value of the '<em><b>Owned Classes</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MClass}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MClass#getOwningClass <em>Owning Class</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Classes</em>' containment reference list
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Classes</em>' containment reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_OwnedClasses()
     * @see com.engisis.sysphs.language.modelica.MClass#getOwningClass
     * @model opposite="owningClass" containment="true"
     * @generated
     */
    public EList<MClass> getOwnedClasses()
    {
        if (ownedClasses == null)
        {
            ownedClasses = new BasicInternalEList<MClass>(MClass.class);
        }
        return ownedClasses;
    }
    
    /**
     * Returns the value of the '<em><b>Components</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MComponent}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MComponent#getOwningClass <em>Owning Class</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Components</em>' containment reference list
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Components</em>' containment reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_Components()
     * @see com.engisis.sysphs.language.modelica.MComponent#getOwningClass
     * @model opposite="owningClass" containment="true"
     * @generated
     */
    public EList<MComponent> getComponents()
    {
        if (components == null)
        {
            components = new BasicInternalEList<MComponent>(MComponent.class);
        }
        return components;
    }
    
    /**
     * Returns the value of the '<em><b>Equations</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MEquation}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MEquation#getOwningClass <em>Owning Class</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Equations</em>' containment reference list
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Equations</em>' containment reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_Equations()
     * @see com.engisis.sysphs.language.modelica.MEquation#getOwningClass
     * @model opposite="owningClass" containment="true"
     * @generated
     */
    public EList<MEquation> getEquations()
    {
        if (equations == null)
        {
            equations = new BasicInternalEList<MEquation>(MEquation.class);
        }
        return equations;
    }
    
    /**
     * Returns the value of the '<em><b>Extensions</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MExtension}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MExtension#getOwningClass <em>Owning Class</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Extensions</em>' containment reference list
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Extensions</em>' containment reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_Extensions()
     * @see com.engisis.sysphs.language.modelica.MExtension#getOwningClass
     * @model opposite="owningClass" containment="true"
     * @generated
     */
    public EList<MExtension> getExtensions()
    {
        if (extensions == null)
        {
            extensions = new BasicInternalEList<MExtension>(MExtension.class);
        }
        return extensions;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Class</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.modelica.MClass#getOwnedClasses <em>Owned Classes</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Class</em>' container reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Class</em>' container reference.
     * @see #setOwningClass(MClass)
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_OwningClass()
     * @see com.engisis.sysphs.language.modelica.MClass#getOwnedClasses
     * @model opposite="ownedClasses" transient="false"
     * @generated
     */
    public MClass getOwningClass()
    {
        if (eContainerFeatureID() != ModelicaPackage.MCLASS__OWNING_CLASS) return null;
        return (MClass)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningClass(MClass newOwningClass, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningClass, ModelicaPackage.MCLASS__OWNING_CLASS, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.modelica.MClass#getOwningClass <em>Owning Class</em>}' container reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Owning Class</em>' container reference.
     * @see #getOwningClass()
     * @generated
     */
    public void setOwningClass(MClass newOwningClass)
    {
        if (newOwningClass != eInternalContainer() || (eContainerFeatureID() != ModelicaPackage.MCLASS__OWNING_CLASS && newOwningClass != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningClass))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningClass != null)
                msgs = ((InternalEObject)newOwningClass).eInverseAdd(this, ModelicaPackage.MCLASS__OWNED_CLASSES, MClass.class, msgs);
            msgs = basicSetOwningClass(newOwningClass, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Algorithms</b></em>' reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.modelica.MAlgorithm}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Algorithms</em>' reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Algorithms</em>' reference list.
     * @see com.engisis.sysphs.language.modelica.ModelicaPackage#getMClass_Algorithms()
     * @model
     * @generated
     */
    public EList<MAlgorithm> getAlgorithms()
    {
        if (algorithms == null)
        {
            algorithms = new BasicInternalEList<MAlgorithm>(MAlgorithm.class);
        }
        return algorithms;
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getOwnedClasses()).basicAdd(otherEnd, msgs);
            case ModelicaPackage.MCLASS__COMPONENTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getComponents()).basicAdd(otherEnd, msgs);
            case ModelicaPackage.MCLASS__EQUATIONS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getEquations()).basicAdd(otherEnd, msgs);
            case ModelicaPackage.MCLASS__EXTENSIONS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getExtensions()).basicAdd(otherEnd, msgs);
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningClass((MClass)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                return ((InternalEList<?>)getOwnedClasses()).basicRemove(otherEnd, msgs);
            case ModelicaPackage.MCLASS__COMPONENTS:
                return ((InternalEList<?>)getComponents()).basicRemove(otherEnd, msgs);
            case ModelicaPackage.MCLASS__EQUATIONS:
                return ((InternalEList<?>)getEquations()).basicRemove(otherEnd, msgs);
            case ModelicaPackage.MCLASS__EXTENSIONS:
                return ((InternalEList<?>)getExtensions()).basicRemove(otherEnd, msgs);
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                return basicSetOwningClass(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                return eInternalContainer().eInverseRemove(this, ModelicaPackage.MCLASS__OWNED_CLASSES, MClass.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                return getOwnedClasses();
            case ModelicaPackage.MCLASS__COMPONENTS:
                return getComponents();
            case ModelicaPackage.MCLASS__EQUATIONS:
                return getEquations();
            case ModelicaPackage.MCLASS__EXTENSIONS:
                return getExtensions();
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                return getOwningClass();
            case ModelicaPackage.MCLASS__ALGORITHMS:
                return getAlgorithms();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                getOwnedClasses().clear();
                getOwnedClasses().addAll((Collection<? extends MClass>)newValue);
                return;
            case ModelicaPackage.MCLASS__COMPONENTS:
                getComponents().clear();
                getComponents().addAll((Collection<? extends MComponent>)newValue);
                return;
            case ModelicaPackage.MCLASS__EQUATIONS:
                getEquations().clear();
                getEquations().addAll((Collection<? extends MEquation>)newValue);
                return;
            case ModelicaPackage.MCLASS__EXTENSIONS:
                getExtensions().clear();
                getExtensions().addAll((Collection<? extends MExtension>)newValue);
                return;
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                setOwningClass((MClass)newValue);
                return;
            case ModelicaPackage.MCLASS__ALGORITHMS:
                getAlgorithms().clear();
                getAlgorithms().addAll((Collection<? extends MAlgorithm>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                getOwnedClasses().clear();
                return;
            case ModelicaPackage.MCLASS__COMPONENTS:
                getComponents().clear();
                return;
            case ModelicaPackage.MCLASS__EQUATIONS:
                getEquations().clear();
                return;
            case ModelicaPackage.MCLASS__EXTENSIONS:
                getExtensions().clear();
                return;
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                setOwningClass((MClass)null);
                return;
            case ModelicaPackage.MCLASS__ALGORITHMS:
                getAlgorithms().clear();
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case ModelicaPackage.MCLASS__OWNED_CLASSES:
                return ownedClasses != null && !ownedClasses.isEmpty();
            case ModelicaPackage.MCLASS__COMPONENTS:
                return components != null && !components.isEmpty();
            case ModelicaPackage.MCLASS__EQUATIONS:
                return equations != null && !equations.isEmpty();
            case ModelicaPackage.MCLASS__EXTENSIONS:
                return extensions != null && !extensions.isEmpty();
            case ModelicaPackage.MCLASS__OWNING_CLASS:
                return getOwningClass() != null;
            case ModelicaPackage.MCLASS__ALGORITHMS:
                return algorithms != null && !algorithms.isEmpty();
        }
        return super.eIsSet(featureID);
    }
    
    protected String getClassPrefix()
    {
        return "class";
    }
    
    public MComponent getComponentByName(String name)
    {
        for (MExtension mextension : getExtensions())
        {
            MClass mclass = mextension.getExtendedClass();
            MComponent mcomponent = mclass.getComponentByName(name);
            if (mcomponent != null)
                return mcomponent;
        }
        for (MComponent mcomponent : getComponents())
        {
            if (mcomponent.getName().equals(name))
                return mcomponent;
        }
        return null;
    }
    
    @Override
    public MElement createClone()
    {
        return ModelicaFactory.eINSTANCE.createMClass();
    }
    
    @Override
    public void copyElement(MElement melement)
    {
        super.copyElement(melement);
        if (melement instanceof MClass)
        {
            MClass mclass = (MClass) melement;
            setOwningClass(mclass.getOwningClass());
            for (MComponent mcomponent : mclass.getComponents())
            {
                
                MComponent mcomponent2 = (MComponent) mcomponent.createClone();
                mcomponent2.copyElement(mcomponent);
                getComponents().add(mcomponent2);
            }
            // equations
            for (MEquation mequation : mclass.getEquations())
            {
                MEquation mequation2 = mequation.createClone();
                mequation2.copyElement(mequation);
                getEquations().add(mequation2);
            }
            // extensions
            for (MExtension mextension : mclass.getExtensions())
            {
                MExtension mextension2 = (MExtension) mextension.createClone();
                mextension2.copyElement(mextension);
                getExtensions().add(mextension2);
            }
            // algorithms
            for (MAlgorithm malgorithm : mclass.getAlgorithms())
            {
                MAlgorithm malgorithm2 = (MAlgorithm) malgorithm.createClone();
                malgorithm2.copyElement(malgorithm);
                getAlgorithms().add(malgorithm2);
            }
        }
        else
            throw new IllegalArgumentException("The argument should be a MClass");
    }
    
    public List<MEquation> getAllEquations()
    {
    	LinkedList<MEquation> ret = new LinkedList<MEquation>();
    	Stack<MClass> st = new Stack<MClass>();
    	st.add(this);
    	while(!st.isEmpty())
    	{
    		MClass mc = st.pop();
    		ret.addAll(mc.getEquations());
    		for(MExtension me : mc.getExtensions())
    		{
        		st.push(me.getExtendedClass());
    		}
    	}
    	return ret;
    }
    
    public List<MComponent> getAllComponents()
    {
    	LinkedList<MComponent> ret = new LinkedList<MComponent>();
    	Stack<MClass> st = new Stack<MClass>();
    	st.add(this);
    	while(!st.isEmpty())
    	{
    		MClass mc = st.pop();
    		ret.addAll(mc.getComponents());
    		for(MExtension me : mc.getExtensions())
    		{
        		st.push(me.getExtendedClass());
    		}
    	}
    	return ret;
    }
    
} // MClass
