package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.generation.simulink.MDLBaseListener;

import java.util.Collection;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

/**
 * Reader of Simulink MDL file (unimplemented)
 * 
 * @author barbau
 *
 */
public class SimulinkMDLReader extends MDLBaseListener implements SimulinkReader
{
    /**
     * Collection of references
     */
    private Collection<SimulinkReference> references;
    
    /**
     * Root of the syntax tree
     */
    private ParserRuleContext prc;
    
    /**
     * Constructs a Simulink MDL parser
     * 
     * @param prc
     *            root of the syntax tree
     */
    public SimulinkMDLReader(ParserRuleContext prc)
    {
        this.prc = prc;
    }
    
    @Override
    public void process()
    {
        new ParseTreeWalker().walk(this, prc);
    }
    
    @Override
    public Collection<SimulinkReference> getReferences()
    {
        return references;
    }
    
    @Override
    public int getPriority()
    {
        return 1;
    }
    
    @Override
    public SElement getRootElement()
    {
        return null;
    }
    
}
