grammar Simscape;
import MATLABCore;

file:
    domain|
    component
    ;

component:
    'component' ID modifiers? (LST reference)? stmt_end 
    (nodes | variables | inputs | outputs | parameters | components | setup | branches |equations | connections)* END stmt_end?
    ;

domain:
    'domain' ID stmt_end 
    (variables | parameters)* END stmt_end?
    ;

modifiers:
    LPAREN (declaration (COMMA declaration)*)? RPAREN
    ;

assignment : 
    reference EQ expr
    ;

variables:
    'variables' modifiers? NL (declaration SEMI NL)* END stmt_end
    ;

nodes:
    'nodes' modifiers? NL (declaration SEMI ('%' )? NL)* END stmt_end
     ;

inputs:
    'inputs' modifiers? NL (declaration SEMI NL)* END stmt_end
     ;

outputs:
    'outputs' modifiers? NL (declaration SEMI NL)* END stmt_end
     ;

parameters:
    'parameters' modifiers? NL (declaration SEMI NL)* END stmt_end
     ;

components:
    'components' modifiers? NL (declaration SEMI NL)* END stmt_end
     ;

statement : 
    assignment |
    expr |
    for_command |
    if_command |
    while_command 
    ;	

declaration :
    ID EQ expr
    ;

for_command : 
    FOR ID '=' expr stmt_end
    (statement stmt_end)*
    END 
    ;

if_command : 
    IF expr stmt_end
    (statement stmt_end)*
    END 
    ;

while_command : 
    WHILE expr stmt_end
    (statement stmt_end)*
    END 
    ;

if_clause :
	IF expr stmt_end
    (equation stmt_end)*
    (
	ELSEIF expr stmt_end
    (equation stmt_end)*
    )*
	ELSE stmt_end
    (equation stmt_end)*
    END
    ;

setup:
    'function' 'setup' stmt_end (statement stmt_end)* END stmt_end
    ;

branches:
    'branches' stmt_end (branch stmt_end)* END stmt_end
    ;

branch:
    ID ':' branchpoint '->' branchpoint
    ;

branchpoint:
    (reference | '*')
    ;

// is inline if supported?
equations:
    'equations' stmt_end (equation stmt_end)* END stmt_end
    ;

equation:
    expr6 DOUBLE_EQ expr6 | let_clause | if_clause
;

let_clause:
	'let' (expr)+ 'in' (equation)+ END
	;

connections:
    'connections' stmt_end (connection SEMI NL)* END stmt_end
    ;

connection:
    'connect' LPAREN reference (COMMA reference)+ RPAREN
    ;

END : 'end';

FOR	   : 'for';
IF	   : 'if';
ELSEIF	   : 'elseif';
ELSE	   : 'else';
WHILE	   : 'while';
