package com.engisis.sysphs.test;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.xml.stream.XMLStreamException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import com.engisis.sysphs.SimulationToSysMLTranslationManager;
import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.sysphs.translation.modelica.ModelicaToSysMLTranslator;
import com.engisis.sysphs.translation.modelica.SysMLToModelicaTranslator;
import com.engisis.sysphs.translation.simulink.SimulinkToSysMLTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator.Domains;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator.SFunction;
import com.engisis.sysphs.util.UMLModelErrorException;

public class GenerationTest
{
    static final Logger log = Logger.getLogger(GenerationTest.class);
    private String circuitblock = "TestCaseCircuit::Circuit";
    private String circuittemperatureblock = "TestCaseCircuitTemperature::CircuitTemperature";
    private String signalprocessorblock = "TestCaseSignalProcessor::SignalProcessor";
    private String signalprocessormdblock = "TestCaseSignalProcessor::SourceToSink";
    
    private String statemachineblock = "TestCaseStateMachine::StateMachineBlock";
    private String signalphysicalblock = "TestCaseSignalPhysical::SignalPhysicalSystem";
    private String filterblock = "TestCaseFilter::FilterSystem";
    private String pressuresystemblock = "TestCasePressureSystem::PressureSystem1";
    private String twotankssystemmd = "Data::ConnectedTanksddd";
    private String humidifiersystemblock = "TestCaseHumidifier::Environment";
    private String humidifiersystemmdblock = "TestCaseHumidifier::HumidifierSystem";
    private String SMblock = "Data::RootBlock";
    private String cruisecontrolblock = "Data::TotalSystem";
    private String cruisecontrolpaperblock = "Model::CruiseControlTotalSystemScenario1";
    private String newmappingsblock = "Data::System";
    private String librarytestblock = "Data::Test::Test";
    
    private static String path;
    private static File ftarget;
    
    private static Set<Object> optMo = new HashSet<Object>();
    private static Set<Object> optSimu2 = new HashSet<Object>();
    private static Set<Object> optSims1 = new HashSet<Object>();
    private static Set<Object> optSims2 = new HashSet<Object>();
    
    @BeforeClass
    public static void init()
    {
        optSimu2.add(SFunction.Level2);
        
        optSims1.add(SFunction.Simscape);
        optSims1.add(Domains.CREATE);
        
        optSims2.add(SFunction.Simscape);
        optSims2.add(Domains.REUSE);
        
        ftarget = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/").getPath());
        path = ftarget.getAbsolutePath();
    }
    
    @Test
    public void testCircuitSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        translateModelicaF(circuitSysML, optMo, "CirM");
        
        translateSimulinkF(circuitSysML, optSims1, "CirCr");
        translateSimulinkF(circuitSysML, optSims2, "CirRe");
    }
    
    @Test
    public void testCircuitMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CircuitMD.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        translateModelicaFRF(circuitSysML, optMo, "MDCM");
        
        translateSimulinkFRF(circuitSysML, optSims1, "MDCS");
    }
    
    /*
     * @Test public void testSignalProcessorUML() throws UMLModelErrorException,
     * IOException, XMLStreamException { SysML2Simulation signalprocessorUML =
     * new SysML2Simulation(GenerationTest.class.getResource(
     * "/UML/UseCaseSignalProcessor.xmi").getPath());
     * signalprocessorUML.setRootClass(signalprocessorblock);
     * 
     * roundtripModelica(signalprocessorUML, optMo1);
     * roundtripModelica(signalprocessorUML, optMo2);
     * 
     * roundtripSimulink(signalprocessorUML, optSimu2); }
     */
    @Test
    public void testSignalProcessorSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        translateModelicaF(signalprocessorSysML, optMo, "SPM");
        
        translateSimulinkF(signalprocessorSysML, optSimu2, "SPSF2");
    }
    
    @Test
    public void testSignalProcessorMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessorMD.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessormdblock);
        
        translateModelicaFRF(signalprocessorSysML, optMo, "MDSPM");
        
        translateSimulinkFRF(signalprocessorSysML, optSimu2, "MDSPS");
    }
    
    @Test
    public void testFilterSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager filterSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Filter.xmi").getPath(), null);
        filterSysML.setInputRootName(filterblock);
        
        translateModelicaF(filterSysML, optMo, "FM");
        
        translateSimulinkF(filterSysML, optSimu2, "FSF2");
    }
    
    @Test
    public void testCircuitTemperatureSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuittemperatureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CircuitTemperature.xmi").getPath(), null);
        circuittemperatureSysML.setInputRootName(circuittemperatureblock);
        
        translateModelicaF(circuittemperatureSysML, optMo, "CTM");
        
        translateSimulinkF(circuittemperatureSysML, optSims1, "CTCr");
        translateSimulinkF(circuittemperatureSysML, optSims2, "CTRe");
    }
    
    @Test
    public void testStateMachineSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager statemachineSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/StateMachine.xmi").getPath(), null);
        statemachineSysML.setInputRootName(statemachineblock);
        
        translateModelicaF(statemachineSysML, optMo, "SSM");
        translateSimulinkF(statemachineSysML, optSimu2, "SSSF2");
    }
    
    @Test
    public void testPressureSystemSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager pressureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PressureSystem.xmi").getPath(), null);
        pressureSysML.setInputRootName(pressuresystemblock);
        
        translateModelicaF(pressureSysML, optMo, "PSM");
        translateSimulinkF(pressureSysML, optSims1, "PSCr");
    }
    
    @Test
    public void testTwoTanksSystemMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager pressureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/TwoTanksSystemMD.xmi").getPath(), null);
        pressureSysML.setInputRootName(twotankssystemmd);
        
        translateModelicaFRF(pressureSysML, optMo, "MDTTSM");
        translateSimulinkFRF(pressureSysML, optSims1, "MDTTSS");
    }
    
    @Test
    public void testHumidifierSystemSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystem.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateModelicaF(humidifierSysML, optMo, "HSM");
        translateSimulinkF(humidifierSysML, optSimu2, "HSSF2");
    }
    
    @Test
    public void testHumidifierSystemMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemMD.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemmdblock);
        
        translateModelicaFRF(humidifierSysML, optMo, "MDHSM");
        translateSimulinkFRF(humidifierSysML, optSimu2, "MDHSS");
    }
    
    @Test
    public void testSignalPhysicalSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalphysical = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalPhysicalModel.xmi").getPath(),
                null);
        signalphysical.setInputRootName(signalphysicalblock);
        
        translateModelicaF(signalphysical, optMo, "S2MM");
        translateSimulinkF(signalphysical, optSims1, "S2MCr");
    }
    
    @Test
    public void testSMSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SM.xmi").getPath(), null);
        sm.setInputRootName(SMblock);
        
        translateModelicaF(sm, optMo, "SMS");
        translateSimulinkF(sm, optSimu2, "SMSF2");
    }
    
    @Test
    public void testCruiseControlSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        sm.setInputRootName(cruisecontrolblock);
        
        translateModelicaF(sm, optMo, "CCM");
        translateSimulinkF(sm, optSims1, "CCCr");
    }
    
    @Test
    public void testCruiseControlPaperSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControlPaper.xmi").getPath(), null);
        sm.setPreprocessing(true);
        sm.setInputRootName(cruisecontrolpaperblock);
        
        translateModelicaFRF(sm, optMo, "CCPM");
        translateSimulinkFRF(sm, optSims1, "CCPCr");
    }
    
    @Test
    public void testCruiseControlPaperRoundtripSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControlPaper.xmi").getPath(), null);
        sm.setPreprocessing(true);
        sm.setInputRootName(cruisecontrolpaperblock);
        
        translateModelicaFR(sm, optMo, "CCPM");
        translateSimulinkFR(sm, optSims1, "CCPCr");
    }
    
    @Test
    public void testNewMappingsSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/NewFeatures.xmi").getPath(), null);
        sm.setInputRootName(newmappingsblock);
        sm.setPreprocessing(true);
        
        translateModelicaF(sm, optMo, "NMN");
        translateSimulinkF(sm, optSims1, "NMCr");
    }
    
    @Test
    public void testLibraryTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/LibraryTest.xmi").getPath(), null);
        sm.setInputRootName(librarytestblock);
        
        translateModelicaF(sm, optMo, "LTM");
        translateSimulinkF(sm, optSimu2, "LTSF2");
    }
    
    @Test
    public void testSimulinkSF() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        // roundtripSimulink(signalprocessorSysML, optSimu2, "SSF");
        translateSimulinkFRF(signalprocessorSysML, optSimu2, "SSF");
    }
    
    @Test
    public void testSimulinkSM() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystem.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        // roundtripSimulink(humidifierSysML, optSimu2, "SSM");
        translateSimulinkFRF(humidifierSysML, optSimu2, "SSM");
    }
    
    @Test
    public void testSimulinkPI() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        // roundtripSimulink(circuitSysML, optSims1, "SPI");
        translateSimulinkFRF(circuitSysML, optSims1, "SPI");
    }
    
    @Test
    public void testSimulinkCC() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        circuitSysML.setInputRootName(cruisecontrolblock);
        
        // roundtripSimulink(circuitSysML, optSims1, "SPI");
        translateSimulinkFRF(circuitSysML, optSims1, "SCC");
    }
    
    @Test
    public void testSimulinkHS() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystem.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateSimulinkFRF(humidifierSysML, optSimu2, "SHS");
    }
    
    @Test
    public void testModelicaSF() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        // roundtripModelica(signalprocessorSysML, optMo, "MSF");
        translateModelicaFRF(signalprocessorSysML, optMo, "MSF");
    }
    
    @Test
    public void testModelicaPI() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        // roundtripModelica(circuitSysML, optMo, "MPI");
        translateModelicaFRF(circuitSysML, optMo, "MPI");
    }
    
    @Test
    public void testModelicaCC() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        circuitSysML.setInputRootName(cruisecontrolblock);
        
        // roundtripModelica(circuitSysML, optMo, "MPI");
        translateModelicaFRF(circuitSysML, optMo, "MCC");
    }
    
    @Test
    public void testModelicaHS() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystem.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateModelicaFRF(humidifierSysML, optMo, "MHS");
    }
    
    /*
     * F for forward, R for reverse
     */
    
    private static void translateModelicaF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd = new File(ftarget, suffix);
        fd.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        
        simulation.setOutputDirectory(fd);
        simulation.setTranslator(mg);
        simulation.execute();
        
    }
    
    private static void translateSimulinkF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd = new File(ftarget, suffix);
        fd.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd);
        simulation.setTranslator(sg);
        simulation.execute();
        
    }
    
    private static void translateModelicaFR(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(mg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        ModelicaToSysMLTranslator sg = new ModelicaToSysMLTranslator(options);
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(mg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg);
        sysml.setTarget("MD");
        sysml.execute();
        
    }
    
    private static void translateSimulinkFR(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(sg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        SimulinkToSysMLTranslator sg2 = new SimulinkToSysMLTranslator();
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(sg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg2);
        sysml.setTarget("MD");
        sysml.execute();
        
    }
    
    private static void translateModelicaFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException, XMLStreamException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(mg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        ModelicaToSysMLTranslator sg = new ModelicaToSysMLTranslator(options);
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(mg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg);
        sysml.setTarget("MD");
        sysml.execute();
        
        File fd3 = new File(ftarget, suffix + "3");
        fd3.mkdir();
        
        SysMLToModelicaTranslator mg2 = new SysMLToModelicaTranslator(options);
        
        SysMLToSimulationTranslationManager simulation2 = new SysMLToSimulationTranslationManager(
                sg.getOutputFileName(), new String[] { ftarget.getAbsolutePath(), path });
        simulation2.setOutputDirectory(fd3);
        simulation2.setInputRootName(sg.getOutputRootName());
        simulation2.setTranslator(mg2);
        simulation2.execute();
    }
    
    private static void translateSimulinkFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException, XMLStreamException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(sg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        SimulinkToSysMLTranslator sg2 = new SimulinkToSysMLTranslator();
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(sg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg2);
        
        sysml.setTarget("MD");
        sysml.execute();
        
        File fd3 = new File(ftarget, suffix + "3");
        fd3.mkdir();
        
        SysMLToSimulinkTranslator sg3 = new SysMLToSimulinkTranslator(options);
        
        SysMLToSimulationTranslationManager simulation2 = new SysMLToSimulationTranslationManager(
                sg2.getOutputFileName(), new String[] { ftarget.getAbsolutePath(), path });
        simulation2.setOutputDirectory(fd3);
        simulation2.setInputRootName(sg2.getOutputRootName());
        simulation2.setTranslator(sg3);
        simulation2.execute();
    }
}
