package com.engisis.sysphs.util;

import java.io.InputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * A Class used to
 * 
 * @author barbau
 *
 */
public class XMIReferenceFinder implements Runnable
{
    static final Logger log = Logger.getLogger(XMIReferenceFinder.class);
    private HashSet<URI> references;
    // private OutputStreamWriter osw2;
    private XMLStreamReader xmlr;
    private Map<String, String> objectmap;
    private Map<URI, URI> locationmap;
    private List<URI> baseuris;
    
    // static int i = 0;
    /**
     * Look for references to other files within the file
     * 
     * @param rs
     *            the ResourceSet in which the SysML model is read
     * @param inputstream
     * @param locationmap
     * @param baseuri
     * @throws FileNotFoundException
     * @throws XMLStreamException
     * @throws FactoryConfigurationError
     */
    public XMIReferenceFinder(ResourceSet rs, InputStream inputstream, Map<String, String> objectmap,
            Map<URI, URI> locationmap, URI baseuri, String[] paths)
            throws FileNotFoundException, XMLStreamException, FactoryConfigurationError
    {
        references = new HashSet<URI>();
        this.objectmap = objectmap;
        this.locationmap = locationmap;
        baseuris = new ArrayList<URI>(paths != null ? paths.length : 0 + 1);
        
        if (!baseuri.isHierarchical() || baseuri.isRelative())
            log.error("Relative/non hierarchical URI! " + baseuri);
        else
            baseuris.add(baseuri);
        
        if (paths != null)
            for (String path : paths)
            {
                URI uri = URI.createFileURI(path);
                if (!uri.isHierarchical() || uri.isRelative())
                    log.error("Relative/non hierarchical URI! " + uri);
                else
                    baseuris.add(uri);
            }
        // osw2 = new OutputStreamWriter(new FileOutputStream(new File("test" +
        // (i++))));
        
        XMLInputFactory xmlif = XMLInputFactory.newFactory();
        xmlif.setProperty(XMLInputFactory.IS_REPLACING_ENTITY_REFERENCES, Boolean.valueOf(false));
        xmlr = xmlif.createXMLStreamReader(inputstream);
        
    }
    
    @Override
    public void run()
    {
        
        int eventType;
        
        // check if there are more events
        // in the input stream
        try
        {
            while (xmlr.hasNext())
            {
                eventType = xmlr.next();
                switch (eventType)
                {
                case XMLStreamConstants.START_ELEMENT:
                    for (int i = 0; i < xmlr.getAttributeCount(); i++)
                    {
                        String name = xmlr.getAttributeLocalName(i);
                        String value = xmlr.getAttributeValue(i);
                        if ("href".equals(name) && value != null)
                        {
                            // hrefs will be replaced in the filter
                            if (objectmap.containsKey(value))
                                value = objectmap.get(value);
                            // get the file part
                            URI uri = URI.createURI(value).trimFragment().trimQuery();
                            // need to be a last segment
                            if (uri.lastSegment() == null)
                                continue;
                            for (URI baseuri : baseuris)
                            {
                                URI resuri = uri.resolve(baseuri);
                                boolean stop = false;
                                if (resuri.isFile() && new File(resuri.toFileString()).exists())
                                {
                                    String suri = resuri.toString();
                                    if (suri.indexOf("!") != -1)
                                        suri = "jar:" + suri;
                                    references.add(URI.createURI(suri));
                                    stop = true;
                                }
                                // look at the local map to see if there is a
                                // mapping
                                for (Entry<URI, URI> localmapentry : locationmap.entrySet())
                                {
                                    if (resuri.equals(localmapentry.getKey()))
                                    {
                                        references.add(localmapentry.getValue());
                                        stop = true;
                                        break;
                                    }
                                }
                                if (stop)
                                    break;
                            }
                        }
                    }
                    break;
                default:
                    break;
                }
            }
        }
        catch (XMLStreamException e)
        {
            log.error("Error while parsing the file", e);
        }
    }
    
    public HashSet<URI> getReferences()
    {
        return references;
    }
}
