package com.engisis.sysphs.util;

/**
 * Generic utility class
 * 
 * @author barbau
 *
 */
public class Util
{
    /**
     * Converts a string into an int, returns a default value if unsuccessful
     * 
     * @param s
     *            string to convert
     * @param def
     *            value to return if none found
     * @return converted int
     */
    public static int toInt(String s, int def)
    {
        try
        {
            return Integer.parseInt(s);
        }
        catch (Exception e)
        {
            return def;
        }
    }
    
    /**
     * Converts a string into an Integer, returns a default value if
     * unsuccessful
     * 
     * @param s
     *            string to convert
     * @param def
     *            value to return if none found
     * @return converted Integer
     */
    public static Integer toInteger(String s, Integer def)
    {
        try
        {
            return Integer.valueOf(s);
        }
        catch (Exception e)
        {
            return def;
        }
    }
    
    /**
     * Converts a string into an double, returns a default value if unsuccessful
     * 
     * @param s
     *            string to convert
     * @param def
     *            value to return if none found
     * @return converted double
     */
    public static double toDouble(String s, double def)
    {
        try
        {
            return Double.parseDouble(s);
        }
        catch (Exception e)
        {
            return def;
        }
    }
    
    /**
     * Converts a string into a boolean, returns a default value if unsuccessful
     * 
     * @param s
     *            string to convert
     * @param def
     *            value to return if none found
     * @return converted boolean
     */
    public static boolean toBoolean(String s, boolean def)
    {
        try
        {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e)
        {
            return def;
        }
    }
}
