package com.engisis.sysphs.util;

import org.eclipse.emf.ecore.resource.Resource;

/**
 * Exception that occurs due to an invalid UML model
 * 
 * @author barbau
 *
 */
public class UMLModelErrorException extends Exception
{
    private static final long serialVersionUID = -6889565738208397640L;
    
    /**
     * Constructs an exception
     * 
     * @param r
     *            resource in which the modeling error is detected
     * @param message
     *            error message
     */
    public UMLModelErrorException(Resource r, String message)
    {
        super("In " + r.getURI() + ": " + message);
    }
}
