/**
 */
package com.engisis.sysphs.language.simulink;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>SBlock</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simulink.SBlock#getSID <em>SID</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SBlock#getOwningSystem <em>Owning System</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSBlock()
 * @model kind="class" abstract="true"
 * @generated
 */
public abstract class SBlock extends SNamedElement
{
    /**
     * The default value of the '{@link #getSID() <em>SID</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getSID()
     * @generated
     * @ordered
     */
    protected static final String SID_EDEFAULT = null;
    
    /**
     * The cached value of the '{@link #getSID() <em>SID</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getSID()
     * @generated
     * @ordered
     */
    protected String sid = SID_EDEFAULT;
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected SBlock()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return SimulinkPackage.Literals.SBLOCK;
    }
    
    /**
     * Returns the value of the '<em><b>SID</b></em>' attribute. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>SID</em>' attribute isn't clear, there really
     * should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>SID</em>' attribute.
     * @see #setSID(String)
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSBlock_SID()
     * @model
     * @generated
     */
    public String getSID()
    {
        return sid;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simulink.SBlock#getSID <em>SID</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @param value the new value of the '<em>SID</em>' attribute.
     * @see #getSID()
     * @generated
     */
    public void setSID(String newSID)
    {
        sid = newSID;
    }
    
    /**
     * Returns the value of the '<em><b>Owning System</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simulink.SSystem#getOwnedBlocks <em>Owned Blocks</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning System</em>' container reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning System</em>' container reference.
     * @see #setOwningSystem(SSystem)
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSBlock_OwningSystem()
     * @see com.engisis.sysphs.language.simulink.SSystem#getOwnedBlocks
     * @model opposite="ownedBlocks" transient="false"
     * @generated
     */
    public SSystem getOwningSystem()
    {
        if (eContainerFeatureID() != SimulinkPackage.SBLOCK__OWNING_SYSTEM) return null;
        return (SSystem)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningSystem(SSystem newOwningSystem, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningSystem, SimulinkPackage.SBLOCK__OWNING_SYSTEM, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simulink.SBlock#getOwningSystem <em>Owning System</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning System</em>' container reference.
     * @see #getOwningSystem()
     * @generated
     */
    public void setOwningSystem(SSystem newOwningSystem)
    {
        if (newOwningSystem != eInternalContainer() || (eContainerFeatureID() != SimulinkPackage.SBLOCK__OWNING_SYSTEM && newOwningSystem != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningSystem))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningSystem != null)
                msgs = ((InternalEObject)newOwningSystem).eInverseAdd(this, SimulinkPackage.SSYSTEM__OWNED_BLOCKS, SSystem.class, msgs);
            msgs = basicSetOwningSystem(newOwningSystem, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningSystem((SSystem)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                return basicSetOwningSystem(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                return eInternalContainer().eInverseRemove(this, SimulinkPackage.SSYSTEM__OWNED_BLOCKS, SSystem.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__SID:
                return getSID();
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                return getOwningSystem();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__SID:
                setSID((String)newValue);
                return;
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                setOwningSystem((SSystem)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__SID:
                setSID(SID_EDEFAULT);
                return;
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                setOwningSystem((SSystem)null);
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case SimulinkPackage.SBLOCK__SID:
                return SID_EDEFAULT == null ? sid != null : !SID_EDEFAULT.equals(sid);
            case SimulinkPackage.SBLOCK__OWNING_SYSTEM:
                return getOwningSystem() != null;
        }
        return super.eIsSet(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (SID: ");
        result.append(sid);
        result.append(')');
        return result.toString();
    }
    
    public String getPath()
    {
        StringBuilder sb = new StringBuilder();
        SSystem owningsystem = (SSystem) getOwningSystem();
        if (owningsystem != null)
        {
            SModel owningmodel = owningsystem.getOwningModel();
            if (owningmodel != null)
                sb.append(owningmodel.getName() + "/");
            else
            {
                SBlock sblock = owningsystem.getOwningSubsystem();
                if (sblock != null)
                    sb.append(sblock.getPath() + "/");
            }
        }
        sb.append(getName());
        return sb.toString();
    }
    
    protected String getSystemCode(int tabs)
    {
        return null;
    }
    
    public void setSID()
    {
        if (getOwningSystem() != null)
            setSID(getOwningSystem().generateSID());
        else
            throw new RuntimeException("Wrong usage!!!");
        
    }
    
    public SBlock getBlockBySID(String string)
    {
        if (getSID() == null)
            return null;
        if (getSID().equals(string))
            return this;
        return null;
    }
    
    public SBlock getBlockByName(String[] name)
    {
        if (name == null || name.length ==0)
            return null;

        if (name.length == 1)
        {
            if (name[0].equals(getName()))
                return this;
        }
        return null;
    }
} // SBlock
