/**
 */
package com.engisis.sysphs.language.simscape;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SSystem;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SConnection Port Block</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simscape.SConnectionPortBlock#getLocation <em>Location</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SConnectionPortBlock#getMember <em>Member</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSConnectionPortBlock()
 * @model kind="class"
 * @generated
 */
public class SConnectionPortBlock extends SPhysicalBlock
{
    /**
     * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected static final SLocation LOCATION_EDEFAULT = SLocation.LEFT;
    /**
     * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected SLocation location = LOCATION_EDEFAULT;

    /**
     * The cached value of the '{@link #getMember() <em>Member</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMember()
     * @generated
     * @ordered
     */
    protected SMember member;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SConnectionPortBlock()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return SimscapePackage.Literals.SCONNECTION_PORT_BLOCK;
    }

    /**
     * Returns the value of the '<em><b>Location</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.simscape.SLocation}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Location</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Location</em>' attribute.
     * @see com.engisis.sysphs.language.simscape.SLocation
     * @see #setLocation(SLocation)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSConnectionPortBlock_Location()
     * @model
     * @generated
     */
    public SLocation getLocation()
    {
        return location;
    }

    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SConnectionPortBlock#getLocation <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Location</em>' attribute.
     * @see com.engisis.sysphs.language.simscape.SLocation
     * @see #getLocation()
     * @generated
     */
    public void setLocation(SLocation newLocation)
    {
        location = newLocation == null ? LOCATION_EDEFAULT : newLocation;
    }

    /**
     * Returns the value of the '<em><b>Member</b></em>' reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simscape.SMember#getConnectionPortBlock <em>Connection Port Block</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Member</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Member</em>' reference.
     * @see #setMember(SMember)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSConnectionPortBlock_Member()
     * @see com.engisis.sysphs.language.simscape.SMember#getConnectionPortBlock
     * @model opposite="connectionPortBlock"
     * @generated
     */
    public SMember getMember()
    {
        if (member != null && member.eIsProxy())
        {
            InternalEObject oldMember = (InternalEObject)member;
            member = (SMember)eResolveProxy(oldMember);
            if (member != oldMember)
            {
            }
        }
        return member;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public SMember basicGetMember()
    {
        return member;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetMember(SMember newMember, NotificationChain msgs)
    {
        SMember oldMember = member;
        member = newMember;
        return msgs;
    }

    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SConnectionPortBlock#getMember <em>Member</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Member</em>' reference.
     * @see #getMember()
     * @generated
     */
    public void setMember(SMember newMember)
    {
        if (newMember != member)
        {
            NotificationChain msgs = null;
            if (member != null)
                msgs = ((InternalEObject)member).eInverseRemove(this, SimscapePackage.SMEMBER__CONNECTION_PORT_BLOCK, SMember.class, msgs);
            if (newMember != null)
                msgs = ((InternalEObject)newMember).eInverseAdd(this, SimscapePackage.SMEMBER__CONNECTION_PORT_BLOCK, SMember.class, msgs);
            msgs = basicSetMember(newMember, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                if (member != null)
                    msgs = ((InternalEObject)member).eInverseRemove(this, SimscapePackage.SMEMBER__CONNECTION_PORT_BLOCK, SMember.class, msgs);
                return basicSetMember((SMember)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                return basicSetMember(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__LOCATION:
                return getLocation();
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                if (resolve) return getMember();
                return basicGetMember();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__LOCATION:
                setLocation((SLocation)newValue);
                return;
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                setMember((SMember)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__LOCATION:
                setLocation(LOCATION_EDEFAULT);
                return;
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                setMember((SMember)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SCONNECTION_PORT_BLOCK__LOCATION:
                return location != LOCATION_EDEFAULT;
            case SimscapePackage.SCONNECTION_PORT_BLOCK__MEMBER:
                return member != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(location);
        result.append(')');
        return result.toString();
    }
    
    public SMember getClosestMember()
    {
        //TODO: make recursive
        if (getMember() != null)
            return getMember();
        SSystem system = getOwningSystem();
        if (system == null)
            return null;
        for(SLine line : system.getOwnedLines())
        {
            if (line instanceof SPhysicalLine)
            {
                SPhysicalLine pline = (SPhysicalLine)line;
                SMember sm = null;
                boolean found = false;
                for(SPhysicalConnectionPoint spcp : pline.getPoints())
                {
                    SBlock sbl = spcp.getBlock();
                    SConnectionPortBlock scpb = spcp.getPort();
                    if (sbl != null)
                    {
                        if (sbl == this)
                            found = true;
                        else if (scpb.getMember() != null)
                            sm = scpb.getMember();
                    }
                }
                if (found && sm != null)
                    return sm;
            }
        }
        return null;
    }

} // SConnectionPortBlock
