/**
 */
package com.engisis.sysphs.language.simscape;

import edu.emory.mathcs.backport.java.util.Collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.engisis.sysphs.language.simulink.SSystem;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>SComponent</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getOwnedEquations <em>Owned Equations</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getOwnedMembers <em>Owned Members</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getOwnedAssignments <em>Owned Assignments</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getOwnedConnections <em>Owned Connections</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getPropagation <em>Propagation</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getBaseComponent <em>Base Component</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getOwningPackage <em>Owning Package</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#isHidden <em>Hidden</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getBranches <em>Branches</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getSubClass <em>Sub Class</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SComponent#getPhysicalDomain <em>Physical Domain</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent()
 * @model kind="class"
 * @generated
 */
public class SComponent extends SSystem
{
    /**
     * The cached value of the '{@link #getOwnedEquations() <em>Owned Equations</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOwnedEquations()
     * @generated
     * @ordered
     */
    protected EList<SEquation> ownedEquations;

    /**
     * The cached value of the '{@link #getOwnedMembers() <em>Owned Members</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOwnedMembers()
     * @generated
     * @ordered
     */
    protected EList<SMember> ownedMembers;

    /**
     * The cached value of the '{@link #getOwnedAssignments() <em>Owned Assignments</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOwnedAssignments()
     * @generated
     * @ordered
     */
    protected EList<SMemberAssignment> ownedAssignments;

    /**
     * The cached value of the '{@link #getOwnedConnections() <em>Owned Connections</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOwnedConnections()
     * @generated
     * @ordered
     */
    protected EList<SConnection> ownedConnections;

    /**
     * The default value of the '{@link #getPropagation() <em>Propagation</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getPropagation()
     * @generated
     * @ordered
     */
    protected static final SPropagation PROPAGATION_EDEFAULT = SPropagation.PROPAGATES;
    
    /**
     * The cached value of the '{@link #getPropagation() <em>Propagation</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getPropagation()
     * @generated
     * @ordered
     */
    protected SPropagation propagation = PROPAGATION_EDEFAULT;
    
    /**
     * The cached value of the '{@link #getBaseComponent() <em>Base Component</em>}' reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @see #getBaseComponent()
     * @generated
     * @ordered
     */
    protected SComponent baseComponent;
    
    /**
     * The default value of the '{@link #isHidden() <em>Hidden</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #isHidden()
     * @generated
     * @ordered
     */
    protected static final boolean HIDDEN_EDEFAULT = false;
    
    /**
     * The cached value of the '{@link #isHidden() <em>Hidden</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #isHidden()
     * @generated
     * @ordered
     */
    protected boolean hidden = HIDDEN_EDEFAULT;
    
    /**
     * The cached value of the '{@link #getBranches() <em>Branches</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getBranches()
     * @generated
     * @ordered
     */
    protected EList<SBranch> branches;
    
    /**
     * The default value of the '{@link #getSubClass() <em>Sub Class</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSubClass()
     * @generated
     * @ordered
     */
	protected static final String SUB_CLASS_EDEFAULT = null;

				/**
     * The cached value of the '{@link #getSubClass() <em>Sub Class</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSubClass()
     * @generated
     * @ordered
     */
	protected String subClass = SUB_CLASS_EDEFAULT;

				/**
     * The default value of the '{@link #getPhysicalDomain() <em>Physical Domain</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getPhysicalDomain()
     * @generated
     * @ordered
     */
	protected static final String PHYSICAL_DOMAIN_EDEFAULT = null;

				/**
     * The cached value of the '{@link #getPhysicalDomain() <em>Physical Domain</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getPhysicalDomain()
     * @generated
     * @ordered
     */
	protected String physicalDomain = PHYSICAL_DOMAIN_EDEFAULT;

				/**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected SComponent()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return SimscapePackage.Literals.SCOMPONENT;
    }
    
    /**
     * Returns the value of the '<em><b>Owned Equations</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SEquation}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Equations</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Equations</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_OwnedEquations()
     * @model containment="true"
     * @generated
     */
    public EList<SEquation> getOwnedEquations()
    {
        if (ownedEquations == null)
        {
            ownedEquations = new BasicInternalEList<SEquation>(SEquation.class);
        }
        return ownedEquations;
    }

    /**
     * Returns the value of the '<em><b>Owned Members</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SMember}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Members</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Members</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_OwnedMembers()
     * @model containment="true"
     * @generated
     */
    public EList<SMember> getOwnedMembers()
    {
        if (ownedMembers == null)
        {
            ownedMembers = new BasicInternalEList<SMember>(SMember.class);
        }
        return ownedMembers;
    }

    /**
     * Returns the value of the '<em><b>Owned Assignments</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SMemberAssignment}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Assignments</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Assignments</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_OwnedAssignments()
     * @model containment="true"
     * @generated
     */
    public EList<SMemberAssignment> getOwnedAssignments()
    {
        if (ownedAssignments == null)
        {
            ownedAssignments = new BasicInternalEList<SMemberAssignment>(SMemberAssignment.class);
        }
        return ownedAssignments;
    }

    /**
     * Returns the value of the '<em><b>Owned Connections</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SConnection}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Connections</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Connections</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_OwnedConnections()
     * @model containment="true"
     * @generated
     */
    public EList<SConnection> getOwnedConnections()
    {
        if (ownedConnections == null)
        {
            ownedConnections = new BasicInternalEList<SConnection>(SConnection.class);
        }
        return ownedConnections;
    }

    /**
     * Returns the value of the '<em><b>Propagation</b></em>' attribute.
     * The literals are from the enumeration {@link com.engisis.sysphs.language.simscape.SPropagation}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Propagation</em>' attribute isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Propagation</em>' attribute.
     * @see com.engisis.sysphs.language.simscape.SPropagation
     * @see #setPropagation(SPropagation)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_Propagation()
     * @model
     * @generated
     */
    public SPropagation getPropagation()
    {
        return propagation;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SComponent#getPropagation <em>Propagation</em>}' attribute.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Propagation</em>' attribute.
     * @see com.engisis.sysphs.language.simscape.SPropagation
     * @see #getPropagation()
     * @generated
     */
    public void setPropagation(SPropagation newPropagation)
    {
        propagation = newPropagation == null ? PROPAGATION_EDEFAULT : newPropagation;
    }
    
    /**
     * Returns the value of the '<em><b>Base Component</b></em>' reference. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Base Component</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>Base Component</em>' reference.
     * @see #setBaseComponent(SComponent)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_BaseComponent()
     * @model
     * @generated
     */
    public SComponent getBaseComponent()
    {
        if (baseComponent != null && baseComponent.eIsProxy())
        {
            InternalEObject oldBaseComponent = (InternalEObject)baseComponent;
            baseComponent = (SComponent)eResolveProxy(oldBaseComponent);
            if (baseComponent != oldBaseComponent)
            {
            }
        }
        return baseComponent;
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public SComponent basicGetBaseComponent()
    {
        return baseComponent;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SComponent#getBaseComponent <em>Base Component</em>}' reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Base Component</em>' reference.
     * @see #getBaseComponent()
     * @generated
     */
    public void setBaseComponent(SComponent newBaseComponent)
    {
        baseComponent = newBaseComponent;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Package</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simscape.SPackage#getComponents <em>Components</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Package</em>' container reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Package</em>' container reference.
     * @see #setOwningPackage(SPackage)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_OwningPackage()
     * @see com.engisis.sysphs.language.simscape.SPackage#getComponents
     * @model opposite="components" transient="false"
     * @generated
     */
    public SPackage getOwningPackage()
    {
        if (eContainerFeatureID() != SimscapePackage.SCOMPONENT__OWNING_PACKAGE) return null;
        return (SPackage)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningPackage(SPackage newOwningPackage, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningPackage, SimscapePackage.SCOMPONENT__OWNING_PACKAGE, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SComponent#getOwningPackage <em>Owning Package</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning Package</em>' container reference.
     * @see #getOwningPackage()
     * @generated
     */
    public void setOwningPackage(SPackage newOwningPackage)
    {
        if (newOwningPackage != eInternalContainer() || (eContainerFeatureID() != SimscapePackage.SCOMPONENT__OWNING_PACKAGE && newOwningPackage != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningPackage))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningPackage != null)
                msgs = ((InternalEObject)newOwningPackage).eInverseAdd(this, SimscapePackage.SPACKAGE__COMPONENTS, SPackage.class, msgs);
            msgs = basicSetOwningPackage(newOwningPackage, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Hidden</b></em>' attribute. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Hidden</em>' attribute isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>Hidden</em>' attribute.
     * @see #setHidden(boolean)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_Hidden()
     * @model
     * @generated
     */
    public boolean isHidden()
    {
        return hidden;
    }
    
    /**
     * Sets the value of the '
     * {@link com.engisis.sysphs.language.simscape.SComponent#isHidden
     * <em>Hidden</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     * 
     * @param value
     *            the new value of the '<em>Hidden</em>' attribute.
     * @see #isHidden()
     * @generated
     */
    public void setHidden(boolean newHidden)
    {
        hidden = newHidden;
    }
    
    /**
     * Returns the value of the '<em><b>Branches</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SBranch}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Branches</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Branches</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_Branches()
     * @model containment="true"
     * @generated
     */
    public EList<SBranch> getBranches() {
        if (branches == null)
        {
            branches = new BasicInternalEList<SBranch>(SBranch.class);
        }
        return branches;
    }
    
    /**
     * Returns the value of the '<em><b>Sub Class</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Class</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Sub Class</em>' attribute.
     * @see #setSubClass(String)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_SubClass()
     * @model
     * @generated
     */
	public String getSubClass() {
        return subClass;
    }

				/**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SComponent#getSubClass <em>Sub Class</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Sub Class</em>' attribute.
     * @see #getSubClass()
     * @generated
     */
	public void setSubClass(String newSubClass) {
        subClass = newSubClass;
    }

				/**
     * Returns the value of the '<em><b>Physical Domain</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Physical Domain</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Physical Domain</em>' attribute.
     * @see #setPhysicalDomain(String)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSComponent_PhysicalDomain()
     * @model
     * @generated
     */
	public String getPhysicalDomain() {
        return physicalDomain;
    }

				/**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SComponent#getPhysicalDomain <em>Physical Domain</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Physical Domain</em>' attribute.
     * @see #getPhysicalDomain()
     * @generated
     */
	public void setPhysicalDomain(String newPhysicalDomain) {
        physicalDomain = newPhysicalDomain;
    }

				/**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningPackage((SPackage)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNED_EQUATIONS:
                return ((InternalEList<?>)getOwnedEquations()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SCOMPONENT__OWNED_MEMBERS:
                return ((InternalEList<?>)getOwnedMembers()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SCOMPONENT__OWNED_ASSIGNMENTS:
                return ((InternalEList<?>)getOwnedAssignments()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SCOMPONENT__OWNED_CONNECTIONS:
                return ((InternalEList<?>)getOwnedConnections()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                return basicSetOwningPackage(null, msgs);
            case SimscapePackage.SCOMPONENT__BRANCHES:
                return ((InternalEList<?>)getBranches()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                return eInternalContainer().eInverseRemove(this, SimscapePackage.SPACKAGE__COMPONENTS, SPackage.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNED_EQUATIONS:
                return getOwnedEquations();
            case SimscapePackage.SCOMPONENT__OWNED_MEMBERS:
                return getOwnedMembers();
            case SimscapePackage.SCOMPONENT__OWNED_ASSIGNMENTS:
                return getOwnedAssignments();
            case SimscapePackage.SCOMPONENT__OWNED_CONNECTIONS:
                return getOwnedConnections();
            case SimscapePackage.SCOMPONENT__PROPAGATION:
                return getPropagation();
            case SimscapePackage.SCOMPONENT__BASE_COMPONENT:
                if (resolve) return getBaseComponent();
                return basicGetBaseComponent();
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                return getOwningPackage();
            case SimscapePackage.SCOMPONENT__HIDDEN:
                return isHidden();
            case SimscapePackage.SCOMPONENT__BRANCHES:
                return getBranches();
            case SimscapePackage.SCOMPONENT__SUB_CLASS:
                return getSubClass();
            case SimscapePackage.SCOMPONENT__PHYSICAL_DOMAIN:
                return getPhysicalDomain();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNED_EQUATIONS:
                getOwnedEquations().clear();
                getOwnedEquations().addAll((Collection<? extends SEquation>)newValue);
                return;
            case SimscapePackage.SCOMPONENT__OWNED_MEMBERS:
                getOwnedMembers().clear();
                getOwnedMembers().addAll((Collection<? extends SMember>)newValue);
                return;
            case SimscapePackage.SCOMPONENT__OWNED_ASSIGNMENTS:
                getOwnedAssignments().clear();
                getOwnedAssignments().addAll((Collection<? extends SMemberAssignment>)newValue);
                return;
            case SimscapePackage.SCOMPONENT__OWNED_CONNECTIONS:
                getOwnedConnections().clear();
                getOwnedConnections().addAll((Collection<? extends SConnection>)newValue);
                return;
            case SimscapePackage.SCOMPONENT__PROPAGATION:
                setPropagation((SPropagation)newValue);
                return;
            case SimscapePackage.SCOMPONENT__BASE_COMPONENT:
                setBaseComponent((SComponent)newValue);
                return;
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                setOwningPackage((SPackage)newValue);
                return;
            case SimscapePackage.SCOMPONENT__HIDDEN:
                setHidden((Boolean)newValue);
                return;
            case SimscapePackage.SCOMPONENT__BRANCHES:
                getBranches().clear();
                getBranches().addAll((Collection<? extends SBranch>)newValue);
                return;
            case SimscapePackage.SCOMPONENT__SUB_CLASS:
                setSubClass((String)newValue);
                return;
            case SimscapePackage.SCOMPONENT__PHYSICAL_DOMAIN:
                setPhysicalDomain((String)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNED_EQUATIONS:
                getOwnedEquations().clear();
                return;
            case SimscapePackage.SCOMPONENT__OWNED_MEMBERS:
                getOwnedMembers().clear();
                return;
            case SimscapePackage.SCOMPONENT__OWNED_ASSIGNMENTS:
                getOwnedAssignments().clear();
                return;
            case SimscapePackage.SCOMPONENT__OWNED_CONNECTIONS:
                getOwnedConnections().clear();
                return;
            case SimscapePackage.SCOMPONENT__PROPAGATION:
                setPropagation(PROPAGATION_EDEFAULT);
                return;
            case SimscapePackage.SCOMPONENT__BASE_COMPONENT:
                setBaseComponent((SComponent)null);
                return;
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                setOwningPackage((SPackage)null);
                return;
            case SimscapePackage.SCOMPONENT__HIDDEN:
                setHidden(HIDDEN_EDEFAULT);
                return;
            case SimscapePackage.SCOMPONENT__BRANCHES:
                getBranches().clear();
                return;
            case SimscapePackage.SCOMPONENT__SUB_CLASS:
                setSubClass(SUB_CLASS_EDEFAULT);
                return;
            case SimscapePackage.SCOMPONENT__PHYSICAL_DOMAIN:
                setPhysicalDomain(PHYSICAL_DOMAIN_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SCOMPONENT__OWNED_EQUATIONS:
                return ownedEquations != null && !ownedEquations.isEmpty();
            case SimscapePackage.SCOMPONENT__OWNED_MEMBERS:
                return ownedMembers != null && !ownedMembers.isEmpty();
            case SimscapePackage.SCOMPONENT__OWNED_ASSIGNMENTS:
                return ownedAssignments != null && !ownedAssignments.isEmpty();
            case SimscapePackage.SCOMPONENT__OWNED_CONNECTIONS:
                return ownedConnections != null && !ownedConnections.isEmpty();
            case SimscapePackage.SCOMPONENT__PROPAGATION:
                return propagation != PROPAGATION_EDEFAULT;
            case SimscapePackage.SCOMPONENT__BASE_COMPONENT:
                return baseComponent != null;
            case SimscapePackage.SCOMPONENT__OWNING_PACKAGE:
                return getOwningPackage() != null;
            case SimscapePackage.SCOMPONENT__HIDDEN:
                return hidden != HIDDEN_EDEFAULT;
            case SimscapePackage.SCOMPONENT__BRANCHES:
                return branches != null && !branches.isEmpty();
            case SimscapePackage.SCOMPONENT__SUB_CLASS:
                return SUB_CLASS_EDEFAULT == null ? subClass != null : !SUB_CLASS_EDEFAULT.equals(subClass);
            case SimscapePackage.SCOMPONENT__PHYSICAL_DOMAIN:
                return PHYSICAL_DOMAIN_EDEFAULT == null ? physicalDomain != null : !PHYSICAL_DOMAIN_EDEFAULT.equals(physicalDomain);
        }
        return super.eIsSet(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (propagation: ");
        result.append(propagation);
        result.append(", hidden: ");
        result.append(hidden);
        result.append(", subClass: ");
        result.append(subClass);
        result.append(", physicalDomain: ");
        result.append(physicalDomain);
        result.append(')');
        return result.toString();
    }
    
    public String getQualifiedName()
    {
        if (getOwningPackage() != null)
            return getOwningPackage().getQualifiedName() + "." + getName();
        return getName();
    }
    
    public String getBlockName()
    {
        if (getOwningPackage() != null)
            return getOwningPackage().getBlockName() + "/" + getName();
        return getName();
    }
    
    public List<SEquation> getAllEquations()
    {
        List<SEquation> ret = new LinkedList<SEquation>();
        ret.addAll(getOwnedEquations());
        if (getBaseComponent() != null)
            ret.addAll(getBaseComponent().getAllEquations());
        return java.util.Collections.unmodifiableList(ret);
    }

    public List<SMember> getAllMembers()
    {
        List<SMember> ret = new LinkedList<SMember>();
        ret.addAll(getOwnedMembers());
        if (getBaseComponent() != null)
            ret.addAll(getBaseComponent().getAllMembers());
        return java.util.Collections.unmodifiableList(ret);
    }
    
    public SMember getMember(String name)
    {
        if (name == null || name.isEmpty())
            throw new IllegalArgumentException("you must provide a name");
        for(SMember smember : getOwnedMembers())
            if (name.equals(smember.getName()))
                return smember;
        if (getBaseComponent() != null)
            return getBaseComponent().getMember(name);
        return null;
    }
    
    public List<SNode> getNodes()
    {
    	List<SNode> ret = new ArrayList<SNode>();
    	for(SMember sm : getOwnedMembers())
    		if (sm instanceof SNode)
    			ret.add((SNode)sm);
        return Collections.unmodifiableList(ret);
    }
    
//    public List<SMember> getLMembers()
//    {
//    	List<SMember> ret = new ArrayList<SMember>();
//    	if (getBaseComponent() != null)
//    		ret.addAll(getBaseComponent().getLMembers());
//    	for(SMember sm : getOwnedMembers())
//    		if (sm instanceof SNode && ((SNode)sm).getLocation() != SLocation.RIGHT)
//    			ret.add(sm);
//    		else if (sm instanceof SInput && ((SInput)sm).getLocation() != SLocation.RIGHT)
//    			ret.add(sm);
//    		else if (sm instanceof SOutput && ((SOutput)sm).getLocation() != SLocation.RIGHT)
//    			ret.add(sm);
//        return Collections.unmodifiableList(ret);
//    }
//    
//    public List<SMember> getRMembers()
//    {
//    	List<SMember> ret = new ArrayList<SMember>();
//    	if (getBaseComponent() != null)
//    		ret.addAll(getBaseComponent().getRMembers());
//    	for(SMember sm : getOwnedMembers())
//    		if (sm instanceof SNode && ((SNode)sm).getLocation() == SLocation.RIGHT)
//    			ret.add(sm);
//    		else if (sm instanceof SInput && ((SInput)sm).getLocation() == SLocation.RIGHT)
//    			ret.add(sm);
//    		else if (sm instanceof SOutput && ((SOutput)sm).getLocation() == SLocation.RIGHT)
//    			ret.add(sm);
//    	return Collections.unmodifiableList(ret);
//    }
//    

    
    public List<SConnectionPortBlock> getLConnectionPorts()
    {
        if (getBaseComponent() == null)
            return super.getLConnectionPorts();
        List<SConnectionPortBlock> ret = new LinkedList<SConnectionPortBlock>(super.getLConnectionPorts());
        ret.addAll(getBaseComponent().getLConnectionPorts());
        return Collections.unmodifiableList(ret);
    }
    
    public List<SConnectionPortBlock> getRConnectionPorts()
    {
        if (getBaseComponent() == null)
            return super.getRConnectionPorts();
        List<SConnectionPortBlock> ret = new LinkedList<SConnectionPortBlock>(super.getRConnectionPorts());
        ret.addAll(getBaseComponent().getRConnectionPorts());
        return Collections.unmodifiableList(ret);
    }
    
} // SComponent
