package com.engisis.sysphs.deserialization.simulink;

import java.util.Collection;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.generation.simulink.MDLBaseListener;

/**
 * Reader of the Stateflow part of an MDL file
 * 
 * @author barbau
 *
 */
public class StateflowMDLReader extends MDLBaseListener implements SimulinkReader
{
    /**
     * Root of the syntax tree
     */
    private ParserRuleContext prc;
    
    /**
     * Constructs a reader for the Stateflow part of an MDL file
     * 
     * @param prc
     */
    public StateflowMDLReader(ParserRuleContext prc)
    {
        this.prc = prc;
    }
    
    @Override
    public void process()
    {
        new ParseTreeWalker().walk(this, prc);
    }
    
    @Override
    public Collection<SimulinkReference> getReferences()
    {
        // TODO Auto-generated method stub
        return null;
    }
    
    @Override
    public int getPriority()
    {
        return 5;
    }
    
    @Override
    public SElement getRootElement()
    {
        return null;
    }
    
}
