package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.generation.simulink.MATLABBaseListener;

import java.util.Collection;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

/**
 * Parser of level-1 S-Function
 * 
 * @author barbau
 *
 */
public class SimulinkSF1Reader extends MATLABBaseListener implements SimulinkReader
{
    /**
     * Root of the syntax tree
     */
    private ParserRuleContext prc;
    
    /**
     * Constructs a parser for a Level-1 S-Function
     * 
     * @param prc
     *            root of the syntax tree
     */
    public SimulinkSF1Reader(ParserRuleContext prc)
    {
        this.prc = prc;
    }
    
    @Override
    public void process()
    {
        new ParseTreeWalker().walk(this, prc);
    }
    
    @Override
    public Collection<SimulinkReference> getReferences()
    {
        // TODO Auto-generated method stub
        return null;
    }
    
    @Override
    public int getPriority()
    {
        return 2;
    }
    
    @Override
    public SElement getRootElement()
    {
        return null;
    }
    
}
