package com.engisis.sysphs.deserialization.simulink;

import java.util.Collection;

import com.engisis.sysphs.language.simulink.SElement;

/**
 * Interface for Simulink readers
 * 
 * @author barbau
 *
 */
public interface SimulinkReader
{
    /**
     * Returns the collection of Simulink references found by the reader
     * 
     * @return collection of Simulink references
     */
    public Collection<SimulinkReference> getReferences();
    
    /**
     * Starts the reading process
     */
    public void process();
    
    /**
     * Returns the priority of the reader
     * 
     * @return priority (lower are executed first)
     */
    public int getPriority();
    
    /**
     * Returns the root element
     * 
     * @return root Simulink element
     */
    public SElement getRootElement();
}
