package com.engisis.sysphs.deserialization.simulink;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.engisis.sysphs.language.simulink.SElement;

/**
 * Represents a Simulink file
 * 
 * @author barbau
 *
 */
public class SimulinkFile
{
    private static final Logger log = Logger.getLogger(SimulinkFile.class);
    
    /**
     * Name of the Simulink file
     */
    private String filename;
    /**
     * Format of the Simulink file
     */
    private Format format;
    /**
     * List of readers associated with the file
     */
    private List<SimulinkReader> readers;
    
    /**
     * Constructs a Simulink file object
     * 
     * @param filename
     *            name of the Simulink file
     * @param format
     *            format of the Simulink file
     */
    public SimulinkFile(String filename, Format format)
    {
        this.filename = filename;
        this.format = format;
        readers = new LinkedList<SimulinkReader>();
    }
    
    /**
     * Returns the file name
     * 
     * @return file name
     */
    public String getFilename()
    {
        return filename;
    }
    
    /**
     * Returns the file format
     * 
     * @return file format
     */
    public Format getFormat()
    {
        return format;
    }
    
    /**
     * Returns the associated readers
     * 
     * @return readers associated with the file
     */
    public List<SimulinkReader> getReaders()
    {
        return readers;
    }
    
    /**
     * Returns the root element of the file
     * 
     * @return root Simulink element
     */
    public SElement getRootElement()
    {
        for (SimulinkReader sr : getReaders())
            if (sr.getRootElement() != null)
                return sr.getRootElement();
        log.error("No root element found for " + getFilename() + " #readers: " + getReaders().size());
        return null;
    }
    
}
