package com.engisis.sysphs.client.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.GroupLayout.Alignment;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

/**
 * Dialog used to display progress in the translation
 * 
 * @author barbau
 *
 */
public class WorkerDialog extends JDialog
{
    private static final long serialVersionUID = -3071112052051872540L;
    
    /**
     * Text label
     */
    private JLabel jlText;
    /**
     * Scroll area for the text
     */
    private JScrollPane jspText;
    /**
     * Area where the progress is displayed
     */
    private JTextArea jtaText;
    /**
     * Button to close the dialog
     */
    private JButton jbDone;
    
    /**
     * Appender
     */
    private AppenderSkeleton appender;
    
    /**
     * Constructs a worker dialog
     * 
     * @param frame
     *            Owning frame
     */
    public WorkerDialog(JFrame frame)
    {
        super(frame);
        setPreferredSize(new Dimension(400, 200));
        
        GroupLayout gl = new GroupLayout(getContentPane());
        getContentPane().setLayout(gl);
        
        jlText = new JLabel();
        
        getContentPane().add(jlText);
        
        jtaText = new JTextArea();
        jtaText.setPreferredSize(null);
        
        jspText = new JScrollPane(jtaText);
        jspText.setPreferredSize(null);
        
        jbDone = new JButton();
        jbDone.setText("Done");
        jbDone.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                setVisible(false);
            }
        });
        
        gl.setHorizontalGroup(gl.createParallelGroup(Alignment.CENTER).addComponent(jlText).addComponent(jspText)
                .addComponent(jbDone));
        
        gl.setVerticalGroup(gl.createSequentialGroup().addComponent(jlText).addComponent(jspText).addComponent(jbDone));
        
    }
    
    /**
     * Shows the dialog
     * 
     * @param sw
     *            Worker in which the translation is done
     * @param text
     *            Title
     */
    public void show(SwingWorker<?, ?> sw, String text)
    {
        jlText.setText(text);
        jtaText.setText("");
        appender = new AppenderSkeleton()
        {
            public boolean requiresLayout()
            {
                return false;
            }
            
            public void close()
            {
            }
            
            protected void append(LoggingEvent event)
            {
                jtaText.append(event.getLevel() + ": " + event.getMessage() + "\n");
                jtaText.setCaretPosition(jtaText.getDocument().getLength());
            }
        };
        appender.setThreshold(Level.DEBUG);
        pack();
        setVisible(true);
        Logger.getRootLogger().addAppender(appender);
        sw.execute();
        jbDone.setEnabled(false);
    }
    
    /**
     * Called when the worker is done.
     */
    public void finish()
    {
        Logger.getRootLogger().removeAppender(appender);
        jbDone.setEnabled(true);
    }
    
    /**
     * Worker in which the translation is performed
     * 
     * @author barbau
     *
     * @param <T1>
     *            first parameter of Swing worker
     * @param <T2>
     *            second parameter of Swing worker
     */
    public abstract class Worker<T1, T2> extends SwingWorker<T1, T2>
    {
        protected void done()
        {
            WorkerDialog.this.finish();
        }
    }
}
