grammar MATLABCore;

// see MATLAB operator precedence

expr :
    expr2 (LOG_OR expr2)*
    ;

expr2 :
    expr3 (LOG_AND expr3)*
    ;

expr3 :
    expr4 (BIN_OR expr4)*
    ;
    
expr4 :    
    expr5 (BIN_AND expr5)*
    ;

expr5 :
   expr6 (relational_op expr6)*
   ;

relational_op:
    LST|LSTE|GRT|GRTE|DOUBLE_EQ|NEQ
    ;

expr6:
    expr7 (COLON expr7)*
    ;

expr7:
    expr8 (add_op expr8)*
    ;

add_op:
    PLUS|MINUS;

expr8:
    expr9 (mul_op expr9)*
    ;

mul_op:
    EL_TIMES|EL_LEFTDIV|EL_RIGHTDIV|TIMES|LEFTDIV|RIGHTDIV
    ;

expr9:
    unary? expr10
    ;

unary:
    PLUS|MINUS|NEG
    ;
    
expr10:
    expr11 (pow_op expr11)*
    ;

pow_op:
    EL_CCT|EL_EXP|CCT|EXP
    ;

expr11:
    INT|
    FLOAT|
    BOOL|
    STRING|
    AT ID|
    array|
    reference|
    LPAREN expr RPAREN|
    object
    ;
    
reference :
    id_arg (DOT id_arg)* 
    ;
    
id_arg :
    ID (LPAREN argument_list RPAREN)?
    ;    

argument_list:
    (COLON | expr) (COMMA (COLON | expr))* 
	;
	
array:
    LSBRACE (row (SEMI row)*)? RSBRACE // matrix?
    ;
    
row:
	expr+
	;

object:
    LBRACE (val (COMMA val)*)? RBRACE
    ;

val:
    (ID EQ)? expr
   ;
   
   

// statement end

stmt_end : (NL | COMMA | SEMI)+;   
   
//
// ==================================================================
//
// LEXER RULES
//

DOUBLE_EQ : '==';
LOG_OR	  : '||';
LOG_AND	  : '&&';
LSTE	  : '<=';
GRTE	  : '>=';
NEQ	  : '~=';

EL_TIMES	: '.*';
EL_LEFTDIV	: './';
EL_RIGHTDIV	: '.\\';
EL_EXP	: '.^';
EL_CCT	: '.\'';

EQ	: '=';

BIN_OR	: '|';
BIN_AND	: '&';

LST	: '<';
GRT	: '>';

COLON	: ':';

PLUS	: '+';
MINUS	: '-';
NEG	: '~';
TIMES	: '*';

LEFTDIV	: '/';
RIGHTDIV: '\\';

EXP	: '^';

CCT	: '\'';

SEMI	: ';';
LPAREN	: '(';
RPAREN	: ')';
LBRACE	: '{';
RBRACE	: '}';
LSBRACE	: '[';
RSBRACE	: ']';
AT	: '@';
DOT	: '.';
COMMA	: ',';

//
// language keywords
//


NL : ('\r'?'\n');

//
// comments
//

BLOCKCOMMENT
        : '%{' .*?  '%}' -> skip
	;

COMMENT :   '%' ~[\r\n]*  -> channel(HIDDEN);

THREEDOTS
	: ( '...' NL ) -> skip
	;

//
// identifiers, strings, numbers, whitespace
//

ID  : [a-zA-Z] [a-zA-Z0-9_]* ;

INT : DIGIT+ ;

FLOAT:  DIGIT+ '.' DIGIT* EXPONENT? 
    |   DIGIT+ EXPONENT 
    |   '.' DIGIT+ EXPONENT? 
    ;

BOOL:
    'true'|'false'|'unknown'
    ;

fragment
EXPONENT
	: ('e'|'E') ('+'|'-')? DIGIT+ ;

fragment
DIGIT : [0-9] ;

STRING
//	: '\'' ( ESC_SEQ | ~('\\'|'\'') )* '\''
	: '\'' ( ~('\\'|'\'') )* '\''
	;

WS
	: [ \t] -> skip ;
	