/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexOperations
extends NamedElementOperations {
    protected VertexOperations() {
    }

    public static StateMachine containingStateMachine(Vertex vertex) {
        State state;
        Region container = vertex.getContainer();
        if (container != null) {
            return container.containingStateMachine();
        }
        if (vertex instanceof Pseudostate) {
            Pseudostate pseudostate = (Pseudostate)vertex;
            PseudostateKind kind = pseudostate.getKind();
            if (kind == PseudostateKind.ENTRY_POINT_LITERAL || kind == PseudostateKind.EXIT_POINT_LITERAL) {
                return pseudostate.getStateMachine();
            }
        } else if (vertex instanceof ConnectionPointReference && (state = ((ConnectionPointReference)vertex).getState()) != null) {
            return state.containingStateMachine();
        }
        return null;
    }

    public static EList<Transition> getIncomings(Vertex vertex) {
        UniqueEList.FastCompare<Transition> incomings = new UniqueEList.FastCompare<Transition>();
        for (EStructuralFeature.Setting setting : VertexOperations.getNonNavigableInverseReferences(vertex)) {
            if (setting.getEStructuralFeature() != UMLPackage.Literals.TRANSITION__TARGET) continue;
            incomings.add((Transition)setting.getEObject());
        }
        return new IncomingEList((InternalEObject)((Object)vertex), UMLPackage.Literals.VERTEX__INCOMING, incomings);
    }

    public static EList<Transition> getOutgoings(Vertex vertex) {
        UniqueEList.FastCompare<Transition> outgoings = new UniqueEList.FastCompare<Transition>();
        for (EStructuralFeature.Setting setting : VertexOperations.getNonNavigableInverseReferences(vertex)) {
            if (setting.getEStructuralFeature() != UMLPackage.Literals.TRANSITION__SOURCE) continue;
            outgoings.add((Transition)setting.getEObject());
        }
        return new OutgoingEList((InternalEObject)((Object)vertex), UMLPackage.Literals.VERTEX__OUTGOING, outgoings);
    }

    public static boolean isContainedInState(Vertex vertex, State s) {
        Region container = vertex.getContainer();
        if (!s.isComposite() || container == null) {
            return false;
        }
        State containerState = container.getState();
        return containerState == s || containerState != null && containerState.isContainedInState(s);
    }

    public static boolean isContainedInRegion(Vertex vertex, Region r) {
        Region container = vertex.getContainer();
        if (container == r) {
            return true;
        }
        if (r.getState() == null) {
            return false;
        }
        State containerState = container.getState();
        return containerState != null && containerState.isContainedInRegion(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IncomingEList
    extends DelegatingEcoreEList<Transition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<Transition> delegateList;

        protected IncomingEList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegateList = delegateList;
        }

        @Override
        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        @Override
        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), Vertex.class);
        }

        @Override
        protected List<Transition> delegateList() {
            return this.delegateList;
        }

        @Override
        protected void delegateAdd(int index, Transition transition) {
            int delegateIndex = this.delegateList.indexOf(transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegateList.move(index, transition);
                }
            } else if (index < this.delegateList.size()) {
                this.delegateList.add(index, transition);
            } else {
                this.delegateList.add(transition);
            }
        }

        @Override
        protected void didAdd(int index, Transition newTransition) {
            super.didAdd(index, newTransition);
            newTransition.setTarget((Vertex)((Object)this.owner));
        }

        @Override
        protected void didRemove(int index, Transition oldTransition) {
            super.didRemove(index, oldTransition);
            oldTransition.setTarget(null);
        }

        @Override
        protected void didSet(int index, Transition newTransition, Transition oldTransition) {
            super.didSet(index, newTransition, oldTransition);
            newTransition.setTarget((Vertex)((Object)this.owner));
            oldTransition.setTarget(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OutgoingEList
    extends DelegatingEcoreEList<Transition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<Transition> delegateList;

        protected OutgoingEList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegateList = delegateList;
        }

        @Override
        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        @Override
        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), Vertex.class);
        }

        @Override
        protected List<Transition> delegateList() {
            return this.delegateList;
        }

        @Override
        protected void delegateAdd(int index, Transition transition) {
            int delegateIndex = this.delegateList.indexOf(transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegateList.move(index, transition);
                }
            } else if (index < this.delegateList.size()) {
                this.delegateList.add(index, transition);
            } else {
                this.delegateList.add(transition);
            }
        }

        @Override
        protected void didAdd(int index, Transition newTransition) {
            super.didAdd(index, newTransition);
            newTransition.setSource((Vertex)((Object)this.owner));
        }

        @Override
        protected void didRemove(int index, Transition oldTransition) {
            super.didRemove(index, oldTransition);
            oldTransition.setSource(null);
        }

        @Override
        protected void didSet(int index, Transition newTransition, Transition oldTransition) {
            super.didSet(index, newTransition, oldTransition);
            newTransition.setSource((Vertex)((Object)this.owner));
            oldTransition.setSource(null);
        }
    }
}

