/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIPreReader
implements Runnable {
    private static final Logger log = Logger.getLogger(XMIPreReader.class);
    private ResourceSet rs;
    private OutputStreamWriter osw;
    private OutputStreamWriter osw2;
    private XMLStreamReader xmlr;
    private List<URI> baseuris;
    private Hashtable<String, String> idmaps;
    private Hashtable<String, String> nsmaps;
    private boolean WRITE = false;

    public XMIPreReader(ResourceSet rs, InputStream inputstream, OutputStream os, URI baseuri, Hashtable<String, String> idmaps, Hashtable<String, String> nsmaps, String[] paths) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
        this.rs = rs;
        this.baseuris = new ArrayList<URI>(paths != null ? paths.length : 1);
        this.baseuris.add(baseuri);
        if (paths != null) {
            for (String path : paths) {
                this.baseuris.add(URI.createFileURI(path));
            }
        }
        this.osw = new OutputStreamWriter(os, Charset.forName("UTF-8").newEncoder());
        if (this.WRITE) {
            this.osw2 = new OutputStreamWriter(new FileOutputStream(new File(baseuri.appendFileExtension("filtered").lastSegment())));
        }
        this.idmaps = idmaps;
        this.nsmaps = nsmaps;
        XMLInputFactory xmlif = XMLInputFactory.newFactory();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlr = xmlif.createXMLStreamReader(inputstream);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        skip = 0;
        try {
            while (this.xmlr.hasNext()) {
                eventType = this.xmlr.next();
                switch (eventType) {
                    case 1: {
                        if (skip == 0) {
                            if ("xmi".equals(this.xmlr.getPrefix()) && "Extension".equals(this.xmlr.getLocalName())) {
                                ++skip;
                            }
                        } else {
                            ++skip;
                        }
                        if (skip > 0) break;
                        this.write("<");
                        prefix = this.xmlr.getPrefix();
                        if (prefix != null && !prefix.isEmpty()) {
                            this.write(prefix + ":");
                        }
                        this.write(this.xmlr.getLocalName());
                        href = "";
                        for (i = 0; i < this.xmlr.getAttributeCount(); ++i) {
                            this.write(" ");
                            prefix = this.xmlr.getAttributePrefix(i);
                            name = this.xmlr.getAttributeLocalName(i);
                            value = this.xmlr.getAttributeValue(i);
                            if ("href".equals(name)) {
                                if (this.idmaps != null && this.idmaps.containsKey(value)) {
                                    value = this.idmaps.get(value);
                                }
                                if ("local".equals((uriref = URI.createURI(value)).scheme())) {
                                    value = "#" + uriref.fragment();
                                }
                                if (uriref.isRelative() && !uriref.hasEmptyPath()) {
                                    changed = false;
                                    for (URI baseuri : this.baseuris) {
                                        resuriref = uriref.resolve(baseuri);
                                        if (!resuriref.isFile() || !new File(resuriref.toFileString()).exists()) continue;
                                        value = resuriref.toString();
                                        XMIPreReader.log.debug("Changing ID " + uriref + " to " + resuriref);
                                        changed = true;
                                        break;
                                    }
                                    if (!changed) {
                                        XMIPreReader.log.warn("Could not revolve relative uri " + uriref);
                                    }
                                }
                            }
                            if ("href".equals(name) && value.startsWith("#")) {
                                this.write("xmi:idref=\"" + XMIPreReader.escape(value.substring(1)) + "\"");
                            } else {
                                if (prefix != null && !prefix.isEmpty()) {
                                    this.write(prefix + ":");
                                }
                                value = XMIPreReader.escape(value);
                                this.write(name + "=\"" + value + "\"");
                            }
                            if ("href".equals(name) && href != null) {
                                href = value;
                            }
                            if (!"type".equals(name) || !"xmi".equals(prefix)) continue;
                            href = null;
                        }
                        if (href == null || href.isEmpty()) ** GOTO lbl76
                        written = false;
                        urihref = URI.createURI(href);
                        if (urihref.hasEmptyPath()) ** GOTO lbl73
                        if (!urihref.isFile()) ** GOTO lbl63
                        eo = this.rs.getEObject(urihref, true);
                        if (eo == null) ** GOTO lbl73
                        ec = eo.eClass();
                        this.write(" xmi:type=\"uml:" + ec.getName() + "\"");
                        written = true;
                        ** GOTO lbl73
lbl63:
                        // 3 sources

                        for (URI mapped : this.rs.getURIConverter().getURIMap().keySet()) {
                            if (!urihref.toString().startsWith(mapped.toString())) continue;
                            eo = this.rs.getEObject(urihref, true);
                            if (eo == null) {
                                XMIPreReader.log.error("Unable to get " + urihref);
                                continue;
                            }
                            ec = eo.eClass();
                            this.write(" xmi:type=\"uml:" + ec.getName() + "\"");
                            written = true;
                            break;
                        }
lbl73:
                        // 5 sources

                        if (!written) {
                            loc = this.xmlr.getLocation();
                            XMIPreReader.log.warn("Couldn't find the xmi:type for element at " + loc.getLineNumber() + ":" + loc.getColumnNumber());
                        }
lbl76:
                        // 5 sources

                        for (i = 0; i < this.xmlr.getNamespaceCount(); ++i) {
                            namespace = this.xmlr.getNamespaceURI(i);
                            if (this.nsmaps != null && (rep = this.nsmaps.get(namespace)) != null) {
                                XMIPreReader.log.debug("Changing NS " + namespace + " to " + rep);
                                namespace = rep;
                            }
                            this.write(" xmlns:" + this.xmlr.getNamespacePrefix(i) + "=\"" + namespace + "\"");
                        }
                        this.write(">");
                        break;
                    }
                    case 2: {
                        if (skip > 0) {
                            --skip;
                            break;
                        }
                        this.write("</");
                        if (this.xmlr.getPrefix() != null && !this.xmlr.getPrefix().isEmpty()) {
                            this.write(this.xmlr.getPrefix() + ":");
                        }
                        this.write(this.xmlr.getLocalName() + ">");
                        break;
                    }
                    case 3: {
                        if (skip > 0) break;
                        this.write("<?" + this.xmlr.getText() + "?>");
                        break;
                    }
                    case 4: {
                        if (skip > 0) break;
                        this.write(XMIPreReader.escape(new String(this.xmlr.getTextCharacters(), this.xmlr.getTextStart(), this.xmlr.getTextLength())));
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        break;
                    }
                    case 8: {
                        this.osw.close();
                        if (!this.WRITE) break;
                        this.osw2.close();
                        break;
                    }
                    case 9: {
                        if (skip > 0) break;
                        this.write("&" + this.xmlr.getLocalName() + ";");
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        if (skip > 0) break;
                        this.write("<![CDATA[" + new String(this.xmlr.getTextCharacters(), this.xmlr.getTextStart(), this.xmlr.getTextLength()) + "]]>");
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            XMIPreReader.log.error("Error while parsing the file", e);
        }
        catch (IOException e) {
            XMIPreReader.log.error("Error while parsing the file", e);
        }
        catch (Exception e) {
            XMIPreReader.log.error("Error while parsing the file", e);
        }
    }

    private void write(String str) throws IOException {
        this.osw.write(str);
        this.osw.flush();
        if (this.WRITE) {
            this.osw2.write(str);
            this.osw2.flush();
        }
    }

    private static String escape(String str) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

