/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    private static final Logger log = Logger.getLogger(Dispatcher.class);
    private List<Visitor> visitors = new ArrayList<Visitor>();

    public void addVisitor(Visitor visitor) {
        if (visitor.dispatcher != null) {
            visitor.dispatcher.removeVisitor(visitor);
        }
        if (!this.visitors.contains(visitor)) {
            this.visitors.add(visitor);
        }
        visitor.dispatcher = this;
    }

    public void removeVisitor(Visitor visitor) {
        this.visitors.remove(visitor);
        visitor.dispatcher = null;
    }

    List<Visitor> getVisitors() {
        return this.visitors;
    }

    public void dispatch(Object o) {
        Class<?> c = o.getClass();
        do {
            for (Visitor visitor : this.visitors) {
                Method[] methods = visitor.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!m.getName().equals("visit") || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != c) continue;
                    try {
                        m.invoke((Object)visitor, o);
                    }
                    catch (Exception e) {
                        log.error("Failed to execute visit on " + o.getClass().getName(), e);
                    }
                    return;
                }
            }
        } while ((c = c.getSuperclass()) != Object.class);
        throw new UnsupportedOperationException("A visitor method couldn't be found for the class " + o.getClass().getName());
    }
}

