/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.generation.simulink.SimscapeBaseListener;
import com.engisis.sysphs.generation.simulink.SimscapeParser;
import java.util.Hashtable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimscapeExpressionExtractor
extends SimscapeBaseListener {
    private static final Logger log = Logger.getLogger(SimscapeExpressionExtractor.class);
    private ParseTreeProperty<String> ptp = new ParseTreeProperty();
    private Hashtable<String, String> substitutions;

    public void prepareNextEquationParsing(Hashtable<String, String> substitutions) {
        this.substitutions = substitutions;
    }

    public String getValue(ParseTree pt) {
        String v = this.ptp.get(pt);
        return v;
    }

    public void setValue(ParseTree pt, String str) {
        this.ptp.put(pt, str);
    }

    @Override
    public void exitEquation(SimscapeParser.EquationContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitLet_clause(SimscapeParser.Let_clauseContext ctx) {
        this.setValue(ctx, "");
        log.error("Let clause can't be translated");
    }

    @Override
    public void exitIf_clause(SimscapeParser.If_clauseContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                sb.append(pt.getText());
                if (((TerminalNode)pt).getSymbol().getType() != 19) continue;
                sb.append(" if");
                continue;
            }
            String v = this.getValue(pt);
            if (v == null) continue;
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(v);
            if (pt instanceof SimscapeParser.ExprContext) {
                sb.append(" then");
                continue;
            }
            if (!(pt instanceof SimscapeParser.EquationContext)) continue;
            sb.append(";");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitExpr(SimscapeParser.ExprContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr2(SimscapeParser.Expr2Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr3(SimscapeParser.Expr3Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr4(SimscapeParser.Expr4Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr5(SimscapeParser.Expr5Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitRelational_op(SimscapeParser.Relational_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr6(SimscapeParser.Expr6Context ctx) {
        if (ctx.expr7().size() > 1) {
            log.error("Colon operator not supported");
            this.setValue(ctx, "");
        } else {
            this.setValue(ctx, this.getValue(ctx.expr7(0)));
        }
    }

    @Override
    public void exitExpr7(SimscapeParser.Expr7Context ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.expr8().size(); ++i) {
            String s = this.getValue(ctx.expr8(i));
            if (sb.length() != 0 && i > 0) {
                sb.append(this.getValue(ctx.add_op(i - 1)));
            }
            sb.append(s);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitAdd_op(SimscapeParser.Add_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr8(SimscapeParser.Expr8Context ctx) {
        StringBuilder sb = new StringBuilder();
        String s = this.getValue(ctx.expr9(0));
        if (!"1".equals(s) || ctx.mul_op().size() <= 0 || !this.getValue(ctx.mul_op(0)).equals("*")) {
            sb.append(s);
        }
        for (int i = 1; i < ctx.expr9().size(); ++i) {
            s = this.getValue(ctx.expr9(i));
            if ("1".equals(s)) continue;
            if (sb.length() != 0) {
                sb.append(this.getValue(ctx.mul_op(i - 1)));
            }
            sb.append(s);
        }
        if (sb.length() == 0) {
            sb.append("1");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitMul_op(SimscapeParser.Mul_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr9(SimscapeParser.Expr9Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitUnary(SimscapeParser.UnaryContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr10(SimscapeParser.Expr10Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitPow_op(SimscapeParser.Pow_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr11(SimscapeParser.Expr11Context ctx) {
        if (ctx.AT() != null) {
            log.error("Operator @ not supported");
        } else {
            this.processStraight(ctx);
        }
    }

    @Override
    public void exitArray(SimscapeParser.ArrayContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (SimscapeParser.RowContext rc : ctx.row()) {
            sb.append(this.getValue(rc));
        }
        sb.append('}');
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitRow(SimscapeParser.RowContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < ctx.expr().size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.getValue(ctx.expr(i)));
        }
        sb.append('}');
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitReference(SimscapeParser.ReferenceContext ctx) {
        String v;
        this.processStraight(ctx);
        if (this.substitutions != null && (v = this.substitutions.get(this.getValue(ctx))) != null) {
            this.setValue(ctx, v);
        }
    }

    @Override
    public void exitId_arg(SimscapeParser.Id_argContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitArgument_list(SimscapeParser.Argument_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitObject(SimscapeParser.ObjectContext ctx) {
        if (ctx.val().size() == 2) {
            String v0 = this.getValue(ctx.val(0).expr());
            String v1 = this.getValue(ctx.val(1).expr());
            if ("1".equals(v0) && v1.startsWith("'") && v1.endsWith("'")) {
                this.setValue(ctx, "1");
                return;
            }
        }
        log.error("Objects can't be translated");
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int t = node.getSymbol().getType();
        if (t == 25) {
            this.setValue(node, "=");
        } else if (t == 44) {
            this.setValue(node, " not ");
        } else if (t == 27) {
            this.setValue(node, " and ");
        } else if (t == 26) {
            this.setValue(node, " or ");
        } else if (t == 49) {
            log.error("Operator ' not supported");
        } else if (t == 35) {
            log.error("Operator .' not supported");
        } else if (t == 34) {
            log.error("Operator .^ not supported");
        } else if (t == 32) {
            log.error("Operator ./ not supported");
        } else if (t == 33) {
            log.error("Operator .\\ not supported");
        } else if (t == 31) {
            log.error("Operator .* not supported");
        } else {
            this.setValue(node, node.getText());
        }
    }

    protected void processStraight(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v = this.getValue(ctx.getChild(i));
            if (v == null) continue;
            sb.append(v);
        }
        this.setValue(ctx, sb.toString());
    }

    protected void processWithSpaces(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v;
            if (i != 0) {
                sb.append(" ");
            }
            if ((v = this.getValue(ctx.getChild(i))) == null) continue;
            sb.append(v);
        }
        this.setValue(ctx, sb.toString());
    }
}

