/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SEvent;
import com.engisis.sysphs.language.stateflow.SIdentifiedElement;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SJunction;
import com.engisis.sysphs.language.stateflow.SLinkNode;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STarget;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.STreeNode;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;

public class StateflowMDLWriter
extends TextWriter {
    public StateflowMDLWriter(Writer w) {
        super(w);
    }

    public void positionState(SState sstate) throws IOException {
        if (sstate.getOwningTreeNode() != null) {
            int pos = sstate.getOwningTreeNode().getTreeNode().indexOf(sstate);
            int w = 100;
            int h = 40;
            int m = 20;
            int x1 = m + m * pos + pos * w;
            int x2 = w;
            int y1 = m;
            int y2 = h;
            String position = "[" + x1 + " " + y1 + " " + x2 + " " + y2 + "]";
            this.append("position " + position, 3);
        }
    }

    public void visit(SChart object) throws IOException {
        this.append("chart", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getName() != null) {
            this.append("name \"" + object.getName() + "\"", 3);
        }
        if (object.getOwningMachine() != null) {
            this.append("machine " + object.getOwningMachine().getId(), 3);
        }
        this.append("treeNode " + object.getTreeNodeString(), 3);
        for (SLinkNode sln : object.getLinkNode()) {
            if (!(sln instanceof SData)) continue;
            this.append("firstData " + sln.getId(), 3);
            break;
        }
        this.append("chartFileNumber " + String.valueOf(object.getOwningMachine().getChart().indexOf(object) + 1), 3);
        this.append("saturateOnIntegerOverflow 1", 3);
        this.append("userSpecifiedStateTransitionExecutionOrder 1", 3);
        this.append("disableImplicitCasting 1", 3);
        this.append("actionLanguage 2", 3);
        this.unindent();
        this.append("}", 3);
        for (STreeNode streenode : object.getTreeNode()) {
            streenode.accept(this.getDispatcher());
        }
        for (SLinkNode slinknode : object.getLinkNode()) {
            slinknode.accept(this.getDispatcher());
        }
    }

    public void visit(SData object) throws IOException {
        this.append("data", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getName() != null) {
            this.append("name \"" + object.getName() + "\"", 3);
        }
        if (object.getMachine() != null) {
            this.append("machine " + object.getMachine().getId(), 3);
        }
        this.append("linkNode " + StateflowMDLWriter.getLinkNodeString(object), 3);
        if (object.getScope() == SDataScope.INPUT) {
            this.append("scope INPUT_DATA", 3);
        } else if (object.getScope() == SDataScope.OUTPUT) {
            this.append("scope OUTPUT_DATA", 3);
        } else if (object.getScope() == SDataScope.CONSTANT) {
            this.append("scope CONSTANT_DATA", 3);
        }
        if (object.getValue() != null) {
            this.append("props", 3);
            this.append("{", 3);
            this.append("initialValue \"", 1);
            object.getValue().accept(this.getDispatcher());
            this.append("\"", 2);
            this.append("}", 3);
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SEvent object) throws IOException {
        this.append("event", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getName() != null) {
            this.append("name " + object.getName(), 3);
        }
        if (object.getMachine() != null) {
            this.append("machine " + object.getMachine().getId(), 3);
        }
        this.append("linkNode " + object.getLinkNodeString(), 3);
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SExpressionValue object) throws IOException {
        this.append(object.getValue());
    }

    public void visit(SInstance object) throws IOException {
        this.append("instance", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getName() != null) {
            this.append("name \"" + object.getName() + "\"", 3);
        }
        if (object.getMachine() != null) {
            this.append("machine " + object.getMachine().getId(), 3);
        }
        if (object.getChart() != null) {
            this.append("chart " + object.getChart().getId(), 3);
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SJunction object) throws IOException {
        this.append("junction", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getChart() != null) {
            this.append("chart " + object.getChart().getId(), 3);
        }
        this.append("linkNode " + StateflowMDLWriter.getLinkNodeString(object), 3);
        this.unindent();
        this.append("}");
    }

    public static String getLinkNodeString(SLinkNode sln) {
        int owner = 0;
        int pre = 0;
        int nex = 0;
        if (sln.getOwningTreeNode() != null) {
            owner = sln.getOwningTreeNode().getId();
            LinkedList<SLinkNode> list = new LinkedList<SLinkNode>();
            for (SLinkNode slinknode : sln.getOwningTreeNode().getLinkNode()) {
                if (slinknode.getClass() != sln.getClass()) continue;
                list.add(slinknode);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != sln) continue;
                if (i - 1 >= 0) {
                    pre = ((SLinkNode)list.get(i - 1)).getId();
                }
                if (i + 1 >= list.size()) break;
                nex = ((SLinkNode)list.get(i + 1)).getId();
                break;
            }
        }
        return "[" + owner + " " + pre + " " + nex + "]";
    }

    public void visit(SMachine object) throws IOException {
        this.append("machine", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getName() != null) {
            this.append("name \"" + object.getName() + "\"", 3);
        }
        this.append("isLibrary 0", 3);
        if (object.getTarget() != null) {
            this.append("firstTarget " + object.getTarget().getId(), 3);
        }
        this.unindent();
        this.append("}", 3);
        for (SChart schart : object.getChart()) {
            schart.accept(this.getDispatcher());
        }
        if (object.getTarget() != null) {
            object.getTarget().accept(this.getDispatcher());
        }
    }

    public void visit(SDoubleValue object) throws IOException {
        this.append(String.valueOf(object.getValue()));
    }

    public void visit(SState object) throws IOException {
        this.append("state", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        String label = object.getLabel() == null ? object.getName() : object.getName() + "\n" + object.getLabel();
        this.append("labelString \"" + label + "\"", 3);
        this.positionState(object);
        if (object.getChart() != null) {
            this.append("chart " + object.getChart().getId(), 3);
        }
        this.append("treeNode " + StateflowMDLWriter.getTreeNodeString(object), 3);
        this.unindent();
        this.append("}", 3);
        for (STreeNode streenode : object.getTreeNode()) {
            streenode.accept(this.getDispatcher());
        }
        for (SLinkNode slinknode : object.getLinkNode()) {
            slinknode.accept(this.getDispatcher());
        }
    }

    public void visit(SStateflow object) throws IOException {
        this.append("Stateflow", 3);
        this.append("{", 3);
        this.indent();
        if (object.getMachine() != null) {
            object.getMachine().accept(this.getDispatcher());
        }
        for (SInstance sinstance : object.getInstance()) {
            sinstance.accept(this.getDispatcher());
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(STarget object) throws IOException {
        this.append("target", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        this.append("name \"sfun\"", 3);
        if (object.getOwningMachine() != null) {
            this.append("machine " + object.getOwningMachine().getId(), 3);
            this.append("linkNode [" + object.getOwningMachine().getId() + " 0 0]", 3);
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(STransition object) throws IOException {
        this.append("transition", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + object.getId(), 3);
        if (object.getLabel() != null) {
            this.append("labelString \"" + object.getLabel() + "\"", 3);
        }
        if (object.getChart() != null) {
            this.append("chart " + object.getChart().getId(), 3);
        }
        this.append("linkNode " + StateflowMDLWriter.getLinkNodeString(object), 3);
        this.append("src", 3);
        this.append("{", 3);
        this.indent();
        if (object.getSrc() != null) {
            this.append("id " + ((SIdentifiedElement)((Object)object.getSrc())).getId(), 3);
        }
        this.unindent();
        this.append("}", 3);
        this.append("dst", 3);
        this.append("{", 3);
        this.indent();
        this.append("id " + ((SIdentifiedElement)((Object)object.getDst())).getId(), 3);
        this.unindent();
        this.append("}", 3);
        if (object.getSrc() != null) {
            this.append("executionOrder " + (object.getSrc().getOutgoing().indexOf(object) + 1), 3);
        } else {
            this.append("executionOrder 1", 3);
        }
        this.unindent();
        this.append("}", 3);
    }

    public static String getTreeNodeString(STreeNode stn) {
        int owner = 0;
        int owned = 0;
        int pre = 0;
        int nex = 0;
        if (stn.getOwningTreeNode() != null) {
            owner = stn.getOwningTreeNode().getId();
            LinkedList<STreeNode> list = new LinkedList<STreeNode>();
            for (STreeNode streenode : stn.getOwningTreeNode().getTreeNode()) {
                if (streenode.getClass() != stn.getClass()) continue;
                list.add(streenode);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != stn) continue;
                if (i - 1 >= 0) {
                    pre = ((STreeNode)list.get(i - 1)).getId();
                }
                if (i + 1 >= list.size()) break;
                nex = ((STreeNode)list.get(i + 1)).getId();
                break;
            }
        }
        if (stn.getTreeNode().size() != 0) {
            owned = ((STreeNode)stn.getTreeNode().get(0)).getId();
        }
        return "[" + owner + " " + owned + " " + pre + " " + nex + "]";
    }
}

