/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.serialization.simulink.SimulinkXMLWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SimulinkSimscapeXMLWriter
extends SimulinkXMLWriter {
    public SimulinkSimscapeXMLWriter(XMLStreamWriter xmlsw) {
        super(xmlsw);
    }

    public void visit(SPhysicalBlock object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "Reference");
        this.defaultBlock(object);
        SComponent scomponent = object.getComponent();
        if (scomponent != null) {
            this.property("Ports", "[" + scomponent.getInports().size() + "," + scomponent.getOutports().size() + ",0,0,0," + scomponent.getLConnectionPorts().size() + "," + scomponent.getRConnectionPorts().size() + "]");
            this.property("SourceBlock", scomponent.getBlockName());
            this.property("SourceType", scomponent.getName());
            if (scomponent.getSubClass() == null) {
                this.property("SourceFile", scomponent.getQualifiedName());
                this.property("ComponentPath", scomponent.getQualifiedName());
                this.property("ClassName", scomponent.getName());
            } else {
                this.property("PhysicalDomain", scomponent.getPhysicalDomain());
                this.property("SubClassName", scomponent.getSubClass());
            }
            for (SMemberAssignment sassignment : object.getAssignments()) {
                SParameter sp;
                SMember sm;
                SMember svar = sassignment.getMemberPath().size() == 1 ? (SMember)sassignment.getMemberPath().get(0) : null;
                if (svar == null) continue;
                this.startElement("P");
                this.attribute("Name", svar.getName());
                if (sassignment.getAssignedValue() != null) {
                    sassignment.getAssignedValue().accept(this.getDispatcher());
                } else if (sassignment.getAssignedReference().size() == 1 && (sm = (SMember)sassignment.getAssignedReference().get(0)) instanceof SParameter && (sp = (SParameter)sm).getValue() != null) {
                    sp.accept(this.getDispatcher());
                }
                this.endElement();
                if (!(svar instanceof SVariable)) continue;
                this.property(svar.getName() + "_specify", "on");
                this.property(svar.getName() + "_priority", "High");
            }
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SConnectionPortBlock object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "PMIOPort");
        this.defaultBlock(object);
        if (object.getLocation() == SLocation.LEFT) {
            this.attribute("Side", "Left");
        } else if (object.getLocation() == SLocation.RIGHT) {
            this.attribute("Side", "Right");
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SPhysicalLine object) throws XMLStreamException {
        this.startElement("Line");
        this.attribute("LineType", "Connection");
        if (object.getPoints().size() > 0) {
            SPhysicalConnectionPoint sconnector = (SPhysicalConnectionPoint)object.getPoints().get(0);
            this.property("Src", sconnector.getBlock().getSID() + "#" + SimulinkSimscapeXMLWriter.getPortString(sconnector.getPort()));
        }
        if (object.getPoints().size() == 2) {
            SPhysicalConnectionPoint sdestination = (SPhysicalConnectionPoint)object.getPoints().get(1);
            this.property("Dst", sdestination.getBlock().getSID() + "#" + SimulinkSimscapeXMLWriter.getPortString(sdestination.getPort()));
        } else if (object.getPoints().size() > 2) {
            for (int i = 1; i < object.getPoints().size(); ++i) {
                SPhysicalConnectionPoint ssource = (SPhysicalConnectionPoint)object.getPoints().get(i);
                if (i > 1 && i < object.getPoints().size() - 1) {
                    this.startElement("Branch");
                    this.attribute("ConnectType", "DEST_SRC");
                }
                this.startElement("Branch");
                this.attribute("ConnectType", "DEST_DEST");
                this.property("Src", ssource.getBlock().getSID() + "#" + SimulinkSimscapeXMLWriter.getPortString(ssource.getPort()));
                this.endElement();
            }
            for (int j = 2; j < object.getPoints().size() - 1; ++j) {
                this.endElement();
            }
        }
        this.endElement();
    }

    public static String getPortString(SConnectionPortBlock scpb) {
        SSystem ssystem = scpb.getOwningSystem();
        int i = ssystem.getLConnectionPorts().indexOf(scpb);
        if (i != -1) {
            return "lconn:" + (i + 1);
        }
        i = ssystem.getRConnectionPorts().indexOf(scpb);
        if (i != -1) {
            return "rconn:" + (i + 1);
        }
        return "";
    }
}

