/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDWorkAssignment;
import com.engisis.sysphs.language.simulink.SFDWorkVariable;
import com.engisis.sysphs.language.simulink.SFDerivativeAssignment;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputAssignment;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFUpdateAssignment;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFVariableAssignment;
import com.engisis.sysphs.language.simulink.SFunction1;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SimulinkSF1Writer
extends TextWriter {
    protected SimulinkSF1Writer(Writer w) {
        super(w);
    }

    public void visit(SFunction1 object) throws IOException {
        List<SFInputVariable> in = object.getInputs();
        List<SFContinuousStateVariable> cst = object.getContinuousStates();
        List<SFDiscreteStateVariable> dst = object.getDiscreteStates();
        List<SFOutputVariable> out = object.getOutputs();
        ArrayList<SFContinuousStateVariable> st = new ArrayList<SFContinuousStateVariable>(cst);
        st.addAll(dst);
        StringBuilder sbpar = new StringBuilder();
        for (SFDWorkVariable sdw : object.getDWorkStates()) {
            sbpar.append("," + sdw.getName());
        }
        LinkedList<String> lUpdate = new LinkedList<String>();
        LinkedList<String> lDeriv = new LinkedList<String>();
        LinkedList<String> lOutput = new LinkedList<String>();
        LinkedList<String> lDWork = new LinkedList<String>();
        for (SFVariableAssignment sFVariableAssignment : object.getAssignments()) {
            String expr = sFVariableAssignment.getExpression() + ";";
            if (sFVariableAssignment instanceof SFUpdateAssignment) {
                lUpdate.add(expr);
                continue;
            }
            if (sFVariableAssignment instanceof SFDerivativeAssignment) {
                lDeriv.add(expr);
                continue;
            }
            if (sFVariableAssignment instanceof SFOutputAssignment) {
                lOutput.add(expr);
                continue;
            }
            if (!(sFVariableAssignment instanceof SFDWorkAssignment)) continue;
            lDWork.add(expr);
        }
        this.append("function [sys,x0,str,ts] = " + object.getName() + "(t,x,u,flag)", 3);
        this.indent();
        for (String string : lDWork) {
            this.append(string, 3);
        }
        this.append("switch flag,", 3);
        this.append("case 0,", 3);
        this.append("[sys,x0,str,ts]=mdlInitializeSizes;", 3);
        this.append("case 1,", 3);
        this.indent();
        if (cst.size() != 0) {
            this.append("sys=mdlDerivatives(t,x,u" + sbpar.toString() + ");", 3);
        } else {
            this.append("sys=[];", 3);
        }
        this.unindent();
        this.append("case 2,", 3);
        this.indent();
        if (dst.size() != 0) {
            this.append("sys=mdlUpdate(t,x,u" + sbpar.toString() + ");", 3);
        } else {
            this.append("sys=[];", 3);
        }
        this.unindent();
        this.append("case 3,", 3);
        this.indent();
        if (out.size() != 0) {
            this.append("sys=mdlOutputs(t,x,u" + sbpar.toString() + ");", 3);
        } else {
            this.append("sys=[];", 3);
        }
        this.unindent();
        this.append("case 4,", 3);
        this.indent();
        this.append("sys=[];", 3);
        this.unindent();
        this.append("case 9,", 3);
        this.indent();
        this.append("sys=[];", 3);
        this.unindent();
        this.append("end", 3);
        this.append("function [sys,x0,str,ts] = mdlInitializeSizes()", 3);
        this.indent();
        this.append("sizes = simsizes;", 3);
        if (cst.size() == 1 && cst.get(0).getDimensions().size() == 1) {
            this.append("sizes.NumContStates = " + cst.get(0).getDimensions().get(0) + ";", 3);
        } else {
            this.append("sizes.NumContStates = " + cst.size() + ";", 3);
        }
        this.append("sizes.NumDiscStates = " + dst.size() + ";", 3);
        this.append("sizes.NumOutputs = " + out.size() + ";", 3);
        this.append("sizes.NumInputs = " + in.size() + ";", 3);
        this.append("sizes.DirFeedthrough = 1;", 3);
        this.append("sizes.NumSampleTimes = 1;", 3);
        this.append("sys = simsizes(sizes);", 3);
        this.append("str = [];", 3);
        this.append("x0  = [", 1);
        for (SFVariable sFVariable : st) {
            if (sFVariable != st.get(0)) {
                this.append(";");
            }
            if (sFVariable.getValue() != null) {
                String v = SimulinkSF1Writer.getValue(sFVariable);
                if (v.isEmpty()) {
                    this.append("0");
                    continue;
                }
                this.append(v);
                continue;
            }
            if (sFVariable.getDimensions().size() == 0) {
                this.append("0");
                continue;
            }
            for (int i = 0; i < (Integer)sFVariable.getDimensions().get(0); ++i) {
                if (i != 0) {
                    this.append(";");
                }
                this.append("0");
            }
        }
        this.append("];", 2);
        this.append("ts  = [0 0];", 3);
        this.unindent();
        this.append("end", 3);
        if (cst.size() != 0) {
            this.append("function sys=mdlDerivatives(t,x,u" + sbpar.toString() + ")", 3);
            this.indent();
            for (String string : lDeriv) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (dst.size() != 0) {
            this.append("function sys=mdlUpdate(t,x,u" + sbpar.toString() + ")", 3);
            this.indent();
            for (String string : lUpdate) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (out.size() != 0) {
            this.append("function sys=mdlOutputs(t,x,u" + sbpar.toString() + ")", 3);
            this.indent();
            for (String string : lOutput) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        this.append("end", 3);
    }

    public static String getValue(SFVariable svar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < svar.getValue().size(); ++i) {
            SDataValue sdv = (SDataValue)svar.getValue().get(i);
            if (i != 0) {
                sb.append(";");
            }
            if (sdv instanceof SExpressionValue) {
                sb.append(((SExpressionValue)sdv).getValue());
                continue;
            }
            if (!(sdv instanceof SDoubleValue)) continue;
            sb.append(((SDoubleValue)sdv).getValue());
        }
        return sb.toString();
    }
}

