/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.deserialization.simulink.SimulinkXMLReaderPass1;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SConnectionPoint;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import com.engisis.sysphs.util.Util;
import com.engisis.sysphs.util.XMLLocation;
import com.engisis.sysphs.util.XMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulinkXMLReaderPass2
extends XMLReader
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(SimulinkXMLReaderPass2.class);
    private SModel smodel;
    private Hashtable<XMLLocation, SElement> objects;
    private Collection<SimulinkReference> references;
    private InputStream is;

    public SimulinkXMLReaderPass2(SimulinkXMLReaderPass1 sxmlr, InputStream inputStream) {
        this.objects = sxmlr.getObjects();
        this.references = sxmlr.getReferences();
        this.is = inputStream;
    }

    @Override
    public void process() {
        if (this.objects == null || this.references == null) {
            throw new RuntimeException("Objects and references must be provided to the reader");
        }
        try {
            XmlPullParserFactory xmlppf = XmlPullParserFactory.newInstance();
            this.xmlpp = xmlppf.newPullParser();
            this.xmlpp.setInput(this.is, null);
            this.lookForElement("Model", "Library");
            this.smodel = (SModel)this.objects.get(this.getLocation());
            this.processModelOrLibrary();
        }
        catch (XmlPullParserException e) {
            log.error(e);
        }
        catch (IOException e) {
            log.error(e);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {}
        }
    }

    private SModel processModelOrLibrary() throws XmlPullParserException, IOException {
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("System")) {
                this.processSystem();
                continue;
            }
            this.skipToEnd();
        }
        return this.smodel;
    }

    private SSystem processSystem() throws XmlPullParserException, IOException {
        log.info("Parsing system for lines");
        SElement selement = this.objects.get(this.getLocation());
        if (!(selement instanceof SSystem)) {
            log.error("System badly associated");
            return null;
        }
        SSystem ssystem = (SSystem)selement;
        log.info("System " + ssystem);
        if (ssystem.getOwningModel() != null) {
            SimulinkUtil.setName(ssystem, ssystem.getOwningModel().getName());
        } else if (ssystem.getOwningSubsystem() != null) {
            SimulinkUtil.setName(ssystem, ssystem.getOwningSubsystem().getName());
        }
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("Block")) {
                this.processBlock();
                continue;
            }
            if (ln2.equals("Line")) {
                SLine sline = this.processLine();
                if (sline == null) continue;
                log.debug("Adding line to system " + ssystem.getName());
                ssystem.getOwnedLines().add(sline);
                continue;
            }
            this.skipToEnd();
        }
        LinkedList<SFunction1Block> sf1s = new LinkedList<SFunction1Block>();
        LinkedList<SFunction2Block> sf2s = new LinkedList<SFunction2Block>();
        LinkedList<SInport> sis = new LinkedList<SInport>();
        LinkedList<SOutport> sos = new LinkedList<SOutport>();
        for (SBlock sb : ssystem.getOwnedBlocks()) {
            if (sb instanceof SFunction1Block) {
                sf1s.add((SFunction1Block)sb);
                continue;
            }
            if (sb instanceof SFunction2Block) {
                sf2s.add((SFunction2Block)sb);
                continue;
            }
            if (sb instanceof SInport) {
                sis.add((SInport)sb);
                continue;
            }
            if (!(sb instanceof SOutport)) continue;
            sos.add((SOutport)sb);
        }
        block2: for (SLine sl : ssystem.getOwnedLines()) {
            SConnectionPoint src = sl.getSource();
            if (src == null) continue;
            for (SConnectionPoint dst : sl.getDestinations()) {
                int i;
                SFunction2 sf2;
                if (src.getBlock() instanceof SInport && dst.getBlock() instanceof SFunction2Block) {
                    sf2 = ((SFunction2Block)dst.getBlock()).getSfunction();
                    i = sf2.getInports().indexOf(dst.getPort());
                    if (i != -1) {
                        SFInputVariable sfiv = sf2.getInputs().get(i);
                        sfiv.setInport((SInport)src.getBlock());
                        continue block2;
                    }
                    log.error("Couldn't find the block in the SFunction: ");
                    continue block2;
                }
                if (!(src.getBlock() instanceof SFunction2Block) || !(dst.getBlock() instanceof SOutport)) continue;
                sf2 = ((SFunction2Block)src.getBlock()).getSfunction();
                i = sf2.getOutports().indexOf(src.getPort());
                if (i != -1) {
                    SFOutputVariable sfov = sf2.getOutputs().get(i);
                    sfov.setOutport((SOutport)dst.getBlock());
                    continue block2;
                }
                log.error("Couldn't find the block in the SFunction");
                continue block2;
            }
        }
        return ssystem;
    }

    private SLine processLine() throws XmlPullParserException, IOException {
        log.info("Parsing line");
        if ("Connection".equals(this.xmlpp.getAttributeValue(null, "LineType"))) {
            SPhysicalLine spline = SimscapeFactory.eINSTANCE.createSPhysicalLine();
            int et = this.xmlpp.getEventType();
            int depth = this.xmlpp.getDepth();
            while (et != 3 || depth != this.xmlpp.getDepth()) {
                String name2;
                et = this.xmlpp.next();
                String name = this.xmlpp.getName();
                if (et != 2 || !name.equals("P") || !"Src".equals(name2 = this.xmlpp.getAttributeValue(null, "Name")) && !"Dst".equals(name2)) continue;
                SPhysicalConnectionPoint spcp = this.getPhysicalConnectionPoint(this.xmlpp.nextText());
                if (spcp != null) {
                    log.info("Adding physical point");
                    spline.getPoints().add(spcp);
                    continue;
                }
                log.error("Null physical line point");
            }
            return spline;
        }
        SLine sline = SimulinkFactory.eINSTANCE.createSLine();
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            SConnectionPoint scp;
            et = this.xmlpp.next();
            String name = this.xmlpp.getName();
            if (et != 2 || !name.equals("P")) continue;
            String name2 = this.xmlpp.getAttributeValue(null, "Name");
            if ("Src".equals(name2)) {
                scp = this.getConnectionPoint(this.xmlpp.nextText());
                if (scp != null) {
                    log.info("Adding source");
                    sline.setSource(scp);
                    continue;
                }
                log.error("Null line source");
                continue;
            }
            if (!"Dst".equals(name2)) continue;
            scp = this.getConnectionPoint(this.xmlpp.nextText());
            if (scp != null) {
                log.info("Adding destination");
                sline.getDestinations().add(scp);
                continue;
            }
            log.error("Null line destination");
        }
        return sline;
    }

    private void processBlock() throws XmlPullParserException, IOException {
        block7: {
            SElement selement;
            block6: {
                log.info("Parsing block");
                selement = this.objects.get(this.getLocation());
                if (!(selement instanceof SPhysicalBlock)) break block6;
                SPhysicalBlock sblock = (SPhysicalBlock)selement;
                int et = this.xmlpp.getEventType();
                int depth = this.xmlpp.getDepth();
                while (et != 3 || depth != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (et != 2) continue;
                    if (this.xmlpp.getName().equals("P")) {
                        String name = this.xmlpp.getAttributeValue(null, "Name");
                        SMember sm = sblock.getComponent().getMember(name);
                        if (sm != null) {
                            try {
                                SMemberAssignment sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                                sma.getMemberPath().add(sm);
                                double d = Double.parseDouble(this.xmlpp.nextText().trim());
                                SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
                                sdv.setValue(d);
                                sma.setAssignedValue(sdv);
                                sblock.getAssignments().add(sma);
                                log.info("Adding assignment for " + sblock.getName() + "." + sm.getName());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        log.warn("Skipped property " + name);
                        continue;
                    }
                    this.skipToEnd();
                }
                break block7;
            }
            if (selement == null) break block7;
            int et = this.xmlpp.getEventType();
            int depth = this.xmlpp.getDepth();
            while (et != 3 || depth != this.xmlpp.getDepth()) {
                et = this.xmlpp.next();
                if (et != 2 || !this.xmlpp.getName().equals("System")) continue;
                this.processSystem();
            }
        }
    }

    private SConnectionPoint getConnectionPoint(String str) {
        SConnectionPoint scp;
        block18: {
            scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
            String[] spl = str.split("#");
            if (spl.length != 2) {
                log.warn("Bad line string: " + str);
                return null;
            }
            SBlock sbl = this.smodel.getBlockBySID(spl[0]);
            if (sbl == null) {
                log.warn("Can't find block " + spl[0]);
                return null;
            }
            scp.setBlock(sbl);
            if (sbl instanceof SInport || sbl instanceof SOutport) {
                return scp;
            }
            SSystem ss = null;
            if (sbl instanceof SSubsystem) {
                ss = ((SSubsystem)sbl).getSystem();
            } else if (sbl instanceof SReference) {
                ss = ((SReference)sbl).getSystem();
            } else if (sbl instanceof SInterface) {
                ss = ((SInterface)sbl).getSystem();
            } else if (sbl instanceof SFunction2Block) {
                ss = ((SFunction2Block)sbl).getSfunction();
            }
            if (ss == null) {
                log.debug("The block has no system: " + sbl.getName());
                return scp;
            }
            String[] spl2 = spl[1].split(":");
            if (spl2.length != 2) {
                log.warn("Bad line string: " + spl[1]);
                return null;
            }
            try {
                int p = Util.toInt(spl2[1], 0);
                if (spl2[0].equals("in")) {
                    if (p < 1 || p > ss.getInports().size()) {
                        log.error("Inport index out of bound in block " + sbl.getName() + "/" + ss.getName());
                        return null;
                    }
                    scp.setPort(ss.getInports().get(p - 1));
                    break block18;
                }
                if (spl2[0].equals("out")) {
                    if (p < 1 || p > ss.getOutports().size()) {
                        log.error("Outport index out of bound in block " + sbl.getName() + "/" + ss.getName());
                        return null;
                    }
                    scp.setPort(ss.getOutports().get(p - 1));
                    break block18;
                }
                log.error("Unsupported port " + spl2[0]);
                return null;
            }
            catch (NumberFormatException e) {
                log.warn("Bad port number string: " + spl[1]);
                return null;
            }
        }
        return scp;
    }

    private SPhysicalConnectionPoint getPhysicalConnectionPoint(String str) {
        SPhysicalConnectionPoint scp;
        block15: {
            scp = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
            String[] spl = str.split("#");
            if (spl.length != 2) {
                log.warn("Bad line string: " + str);
                return null;
            }
            SBlock sbl = this.smodel.getBlockBySID(spl[0]);
            SSystem sblocksys = null;
            if (sbl instanceof SPhysicalBlock) {
                sblocksys = ((SPhysicalBlock)sbl).getComponent();
            } else if (sbl instanceof SSubsystem) {
                sblocksys = ((SSubsystem)sbl).getSystem();
            } else if (sbl instanceof SReference) {
                sblocksys = ((SReference)sbl).getSystem();
            } else {
                log.warn("Not a physical, subsystem, or reference block: " + sbl.getName());
                return null;
            }
            if (sblocksys == null) {
                log.debug("The block has no component or system: " + sbl.getName());
                return null;
            }
            scp.setBlock(sbl);
            String[] spl2 = spl[1].split(":");
            if (spl2.length != 2) {
                log.warn("Bad line string: " + spl[1]);
                return null;
            }
            try {
                int p = Integer.parseInt(spl2[1]);
                if (spl2[0].equals("lconn")) {
                    if (p < 1 || p > sblocksys.getLConnectionPorts().size()) {
                        log.error("Left connection port index out of bound in component " + sblocksys.getName());
                        return null;
                    }
                    scp.setPort(sblocksys.getLConnectionPorts().get(p - 1));
                    break block15;
                }
                if (spl2[0].equals("rconn")) {
                    if (p < 1 || p > sblocksys.getRConnectionPorts().size()) {
                        log.error("R connection port index out of bound in component " + sblocksys.getName());
                        return null;
                    }
                    scp.setPort(sblocksys.getRConnectionPorts().get(p - 1));
                    break block15;
                }
                log.error("Unsupported port " + spl2[0]);
                return null;
            }
            catch (NumberFormatException e) {
                log.warn("Bad port number string: " + spl[1]);
                return null;
            }
        }
        return scp;
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    @Override
    public int getPriority() {
        return 11;
    }

    @Override
    public SElement getRootElement() {
        return this.smodel;
    }
}

