/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SSystemParameter;
import com.engisis.sysphs.language.simulink.SSystemParameterAssignment;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.language.stateflow.StateflowFactory;
import com.engisis.sysphs.translation.simulink.SimscapeUtil;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import com.engisis.sysphs.util.Util;
import com.engisis.sysphs.util.XMLLocation;
import com.engisis.sysphs.util.XMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulinkXMLReaderPass1
extends XMLReader
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(SimulinkXMLReaderPass1.class);
    private SModel smodel;
    private Hashtable<XMLLocation, SElement> objects = new Hashtable();
    private Collection<SimulinkReference> references = new LinkedList<SimulinkReference>();
    private InputStream is;

    public SimulinkXMLReaderPass1(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public void process() {
        try {
            XmlPullParserFactory xmlppf = XmlPullParserFactory.newInstance();
            this.xmlpp = xmlppf.newPullParser();
            this.xmlpp.setInput(this.is, null);
            this.lookForElement("Model", "Library");
            this.smodel = this.processModelOrLibrary();
        }
        catch (XmlPullParserException e) {
            log.error(e);
        }
        catch (IOException e) {
            log.error(e);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {}
        }
    }

    private SModel processModelOrLibrary() throws XmlPullParserException, IOException {
        String ln = this.xmlpp.getName();
        String name = this.xmlpp.getAttributeValue(null, "Name");
        if (ln.equals("Library")) {
            this.smodel = SimulinkFactory.eINSTANCE.createSModel();
            SimulinkUtil.setName(this.smodel, name);
            log.info("Parsing library " + name);
        } else if (ln.equals("Model")) {
            this.smodel = SimulinkFactory.eINSTANCE.createSLibrary();
            SimulinkUtil.setName(this.smodel, name);
            log.info("Parsing model " + name);
        }
        this.objects.put(this.getLocation(), this.smodel);
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || this.xmlpp.getDepth() != depth) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("System")) {
                SSystem ssystem = this.processSystem(false);
                ssystem.setOwningModel(this.smodel);
                if (ssystem.getName() != null) continue;
                SimulinkUtil.setName(ssystem, this.smodel.getName());
                continue;
            }
            this.skipToEnd();
        }
        return this.smodel;
    }

    private SSystem processSystem(boolean ischart) throws XmlPullParserException, IOException {
        log.info("Parsing system");
        SSystem ssystem = ischart ? StateflowFactory.eINSTANCE.createSChartSystem() : SimulinkFactory.eINSTANCE.createSSystem();
        this.objects.put(this.getLocation(), ssystem);
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("Block")) {
                SBlock sblock = this.processBlock();
                if (sblock == null) {
                    log.error("block not recognized");
                    continue;
                }
                sblock.setOwningSystem(ssystem);
                continue;
            }
            if (ln2.equals("Line")) continue;
            this.skipToEnd();
        }
        return ssystem;
    }

    private SBlock processBlock() throws XmlPullParserException, IOException {
        XMLLocation loc;
        String sid;
        SBlock sb;
        block42: {
            Hashtable<String, String> params;
            String[] ports;
            String functionname;
            String side;
            String name;
            String type;
            block43: {
                String sfbt;
                SSystem ssystem;
                block41: {
                    sb = null;
                    type = null;
                    name = null;
                    sid = null;
                    side = null;
                    String sourceblock = null;
                    String componentpath = null;
                    ssystem = null;
                    functionname = null;
                    sfbt = null;
                    ports = new String[]{"1", "1"};
                    name = this.xmlpp.getAttributeValue(null, "Name");
                    type = this.xmlpp.getAttributeValue(null, "BlockType");
                    sid = this.xmlpp.getAttributeValue(null, "SID");
                    side = this.xmlpp.getAttributeValue(null, "Side");
                    params = new Hashtable<String, String>();
                    loc = this.getLocation();
                    int et = this.xmlpp.getEventType();
                    int depth = this.xmlpp.getDepth();
                    while (et != 3 || depth != this.xmlpp.getDepth()) {
                        et = this.xmlpp.next();
                        if (et != 2) continue;
                        String ln = this.xmlpp.getName();
                        if (ln.equals("P")) {
                            ln = this.xmlpp.getAttributeValue(null, "Name");
                            if (ln.equals("SourceBlock")) {
                                sourceblock = this.xmlpp.nextText();
                                continue;
                            }
                            if (ln.equals("ComponentPath")) {
                                componentpath = this.xmlpp.nextText();
                                continue;
                            }
                            if (ln.equals("FunctionName")) {
                                functionname = this.xmlpp.nextText();
                                continue;
                            }
                            if (ln.equals("SFBlockType")) {
                                sfbt = this.xmlpp.nextText();
                                continue;
                            }
                            if (ln.equals("Ports")) {
                                String s = this.xmlpp.nextText().trim();
                                ports = s.substring(1, s.length() - 1).split(",");
                                continue;
                            }
                            params.put(ln, this.xmlpp.nextText());
                            continue;
                        }
                        if (ln.equals("System")) {
                            ssystem = this.processSystem("Chart".equals(sfbt));
                            continue;
                        }
                        this.skipToEnd();
                    }
                    if (!"Reference".equals(type)) break block41;
                    if (componentpath == null) {
                        log.info("Found Reference block " + name);
                        sb = SimulinkFactory.eINSTANCE.createSReference();
                        SimulinkUtil.setName(sb, name);
                        this.references.add(new SimulinkReference(sb, sourceblock, SimulinkReference.ReferenceType.BLOCK));
                    } else {
                        log.info("Found Physical block " + name);
                        sb = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
                        SimulinkUtil.setName(sb, name);
                        this.references.add(new SimulinkReference(sb, componentpath, SimulinkReference.ReferenceType.COMPONENT));
                    }
                    break block42;
                }
                if (!"SubSystem".equals(type)) break block43;
                log.info("Found Subsystem block " + name);
                if ("Chart".equals(sfbt)) {
                    sb = StateflowFactory.eINSTANCE.createSChartBlock();
                    SimulinkUtil.setName(sb, name);
                } else {
                    sb = SimulinkFactory.eINSTANCE.createSSubsystem();
                    SimulinkUtil.setName(sb, name);
                }
                if (ssystem == null) break block42;
                ssystem.setOwningSubsystem((SSubsystem)sb);
                if (ssystem.getName() != null) break block42;
                SimulinkUtil.setName(ssystem, sb.getName());
                break block42;
            }
            if ("S-Function".equals(type)) {
                log.info("Found S-function level 1 block " + name);
                sb = SimulinkFactory.eINSTANCE.createSFunction1Block();
                SimulinkUtil.setName(sb, name);
                if (functionname != null) {
                    if (!functionname.equals("sf_sfun")) {
                        this.references.add(new SimulinkReference(sb, functionname, SimulinkReference.ReferenceType.SF1));
                    }
                } else {
                    log.warn("S-Function without function");
                }
            } else if ("M-S-Function".equals(type)) {
                log.info("Found S-function level 2 block " + name);
                sb = SimulinkFactory.eINSTANCE.createSFunction2Block();
                SimulinkUtil.setName(sb, name);
                if (functionname != null) {
                    this.references.add(new SimulinkReference(sb, functionname, SimulinkReference.ReferenceType.SF2));
                } else {
                    log.warn("S-Function without function");
                }
            } else if ("Inport".equals(type)) {
                log.info("Found Inport block " + name);
                sb = SimulinkFactory.eINSTANCE.createSInport();
                SimulinkUtil.setName(sb, name);
            } else if ("Outport".equals(type)) {
                log.info("Found Outport block " + name);
                sb = SimulinkFactory.eINSTANCE.createSOutport();
                SimulinkUtil.setName(sb, name);
            } else if ("PMIOPort".equals(type)) {
                log.info("Found Physical port " + type + ":" + name);
                SConnectionPortBlock sbpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
                sb = sbpb;
                SimulinkUtil.setName(sbpb, name);
                sbpb.setComponent(SimscapeUtil.getConnectionPortComponent());
                if (side != null) {
                    if ("Left".equals(side)) {
                        sbpb.setLocation(SLocation.LEFT);
                    } else if ("Right".equals(side)) {
                        sbpb.setLocation(SLocation.RIGHT);
                    } else {
                        log.warn("No location for block " + name);
                    }
                } else {
                    log.warn("No location for block " + name);
                }
            } else {
                log.info("Found Interface " + type + ":" + name);
                SInterface si = SimulinkFactory.eINSTANCE.createSInterface();
                sb = si;
                SimulinkUtil.setName(sb, name);
                SSystem sbsys = SimulinkFactory.eINSTANCE.createSSystem();
                SimulinkUtil.setName(sbsys, type);
                si.setSystem(sbsys);
                if (ports != null) {
                    int i;
                    if (ports.length > 0) {
                        for (i = 0; i < Util.toInt(ports[0], 0); ++i) {
                            SInport sinport = SimulinkFactory.eINSTANCE.createSInport();
                            sinport.setOwningSystem(sbsys);
                        }
                    }
                    if (ports.length > 1) {
                        for (i = 0; i < Util.toInt(ports[1], 0); ++i) {
                            SOutport soutport = SimulinkFactory.eINSTANCE.createSOutport();
                            soutport.setOwningSystem(sbsys);
                        }
                    }
                }
                for (Map.Entry param : params.entrySet()) {
                    SSystemParameter ssp = SimulinkFactory.eINSTANCE.createSSystemParameter();
                    sbsys.getSystemparameters().add(ssp);
                    SSystemParameterAssignment sspa = SimulinkFactory.eINSTANCE.createSSystemParameterAssignment();
                    si.getAssignments().add(sspa);
                    SimulinkUtil.setName(ssp, (String)param.getKey());
                    sspa.setParameter(ssp);
                    try {
                        double d = Double.parseDouble((String)param.getValue());
                        SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
                        sdv.setValue(d);
                        sspa.setValue(sdv);
                    }
                    catch (NumberFormatException e) {
                        SExpressionValue sev = SimulinkFactory.eINSTANCE.createSExpressionValue();
                        sev.setValue((String)param.getValue());
                        sspa.setValue(sev);
                    }
                }
            }
        }
        sb.setSID(sid);
        this.objects.put(loc, sb);
        return sb;
    }

    public SModel getModel() {
        return this.smodel;
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    public Hashtable<XMLLocation, SElement> getObjects() {
        return this.objects;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public SElement getRootElement() {
        return this.smodel;
    }
}

