/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimscapeReaderPass1;
import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.generation.simulink.SimscapeBaseListener;
import com.engisis.sysphs.generation.simulink.SimscapeParser;
import com.engisis.sysphs.language.simscape.SBranch;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SConnection;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SMemberPath;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SElement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimscapeReaderPass2
extends SimscapeBaseListener
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(SimscapeReaderPass2.class);
    private Collection<SimulinkReference> references;
    private ParseTreeProperty<SElement> objects;
    private SComponent scomponent = null;
    private SDomain sdomain = null;
    private ParserRuleContext prc;
    private SimscapeReaderPass1 srd;

    public SimscapeReaderPass2(SimscapeReaderPass1 srd, ParserRuleContext prc) {
        this.prc = prc;
        this.srd = srd;
        this.references = srd.getReferences();
        this.objects = srd.getObjects();
    }

    @Override
    public void process() {
        new ParseTreeWalker().walk(this, this.prc);
    }

    @Override
    public void enterComponent(SimscapeParser.ComponentContext ctx) {
        this.scomponent = (SComponent)this.objects.get(ctx);
        if (this.scomponent != null) {
            log.info("Retrieving component " + this.scomponent.getName());
        }
    }

    @Override
    public void enterDomain(SimscapeParser.DomainContext ctx) {
        this.sdomain = (SDomain)this.objects.get(ctx);
        if (this.sdomain != null) {
            log.info("Retrieving domain " + this.sdomain.getName());
        }
    }

    @Override
    public void enterBranches(SimscapeParser.BranchesContext ctx) {
        for (SimscapeParser.BranchContext bc : ctx.branch()) {
            SMemberPath smp;
            log.info("Resolving branch");
            SBranch sbranch = (SBranch)this.objects.get(bc);
            SMember smember = this.scomponent.getMember(bc.ID().getText());
            if (smember instanceof SVariable) {
                sbranch.setVariable((SVariable)smember);
            }
            SimscapeParser.ReferenceContext rc0 = bc.branchpoint(0).reference();
            SimscapeParser.ReferenceContext rc1 = bc.branchpoint(1).reference();
            if (rc0 != null) {
                smp = SimscapeFactory.eINSTANCE.createSMemberPath();
                smp.getPath().addAll(this.getListMembers(rc0));
                sbranch.setFrom(smp);
                continue;
            }
            if (rc1 == null) continue;
            smp = SimscapeFactory.eINSTANCE.createSMemberPath();
            smp.getPath().addAll(this.getListMembers(rc1));
            sbranch.setTo(smp);
        }
    }

    @Override
    public void enterSetup(SimscapeParser.SetupContext ctx) {
        for (SimscapeParser.StatementContext sc : ctx.statement()) {
            SimscapeParser.AssignmentContext ac = sc.assignment();
            if (ac != null) {
                SMemberAssignment sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                sma.getMemberPath().addAll(this.getListMembers(ac.reference()));
                sma.setAssignedValue(this.srd.getValue(ac.expr()));
                this.scomponent.getOwnedAssignments().add(sma);
                log.info("Adding member assignment for " + sc.getText());
                continue;
            }
            log.info("Skipping statement " + sc.getText());
        }
    }

    @Override
    public void enterConnection(SimscapeParser.ConnectionContext ctx) {
        SConnection sc = (SConnection)this.objects.get(ctx);
        if (sc != null) {
            log.info("Resolving connection " + ctx.getText());
            for (SimscapeParser.ReferenceContext rc : ctx.reference()) {
                SMemberPath smp = SimscapeFactory.eINSTANCE.createSMemberPath();
                smp.getPath().addAll(this.getListMembers(rc));
                sc.getPoints().add(smp);
                log.info("Added point for " + rc.getText());
            }
        } else {
            log.error("Can't resolve connection " + ctx.getText());
        }
    }

    private List<SMember> getListMembers(SimscapeParser.ReferenceContext rc) {
        LinkedList<SMember> ret = new LinkedList<SMember>();
        SMember sm = null;
        if (this.scomponent != null) {
            sm = this.scomponent.getMember(rc.id_arg(0).getText());
            ret.add(sm);
        }
        for (int i = 1; i < rc.id_arg().size() && sm != null; ++i) {
            String id = rc.id_arg(i).getText();
            if (sm instanceof SComponentReference) {
                if (((SComponentReference)sm).getComponent() == null) {
                    log.error("The member has no component: " + id + " of " + rc.getText());
                    break;
                }
                sm = ((SComponentReference)sm).getComponent().getMember(id);
                ret.add(sm);
                if (sm != null) continue;
                log.error("can't find reference " + id + " of " + rc.getText());
                break;
            }
            if (sm instanceof SNode) {
                if (((SNode)sm).getDomain() == null) {
                    log.error("The member has no domain: " + id + " of " + rc.getText());
                    break;
                }
                sm = ((SNode)sm).getDomain().getMember(id);
                ret.add(sm);
                if (sm != null) continue;
                log.error("can't find reference " + id + " of " + rc.getText());
                break;
            }
            sm = null;
        }
        return ret;
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public SElement getRootElement() {
        return this.scomponent != null ? this.scomponent : this.sdomain;
    }
}

