/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import junit.framework.TestCase;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlexusTestCase
extends TestCase {
    private PlexusContainer container;
    private static String basedir;

    @Override
    protected void setUp() throws Exception {
        basedir = PlexusTestCase.getBasedir();
    }

    protected void setupContainer() {
        DefaultContext context = new DefaultContext();
        context.put("basedir", PlexusTestCase.getBasedir());
        this.customizeContext(context);
        boolean hasPlexusHome = context.contains("plexus.home");
        if (!hasPlexusHome) {
            File f = PlexusTestCase.getTestFile("target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            context.put("plexus.home", f.getAbsolutePath());
        }
        String config = this.getCustomConfigurationName();
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setName("test").setContext(context.getContextData());
        if (config != null) {
            containerConfiguration.setContainerConfiguration(config);
        } else {
            String resource = this.getConfigurationName(null);
            containerConfiguration.setContainerConfiguration(resource);
        }
        this.customizeContainerConfiguration(containerConfiguration);
        try {
            this.container = new DefaultPlexusContainer(containerConfiguration);
        }
        catch (PlexusContainerException e) {
            e.printStackTrace();
            PlexusTestCase.fail("Failed to create plexus container.");
        }
    }

    protected void customizeContainerConfiguration(ContainerConfiguration containerConfiguration) {
    }

    protected void customizeContext(Context context) {
    }

    protected PlexusConfiguration customizeComponentConfiguration() {
        return null;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String subname) throws Exception {
        return this.getResourceAsStream(this.getConfigurationName(subname));
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getConfigurationName(String subname) {
        return this.getClass().getName().replace('.', '/') + ".xml";
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.getClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected Object lookup(String componentKey) throws Exception {
        return this.getContainer().lookup(componentKey);
    }

    protected Object lookup(String role, String roleHint) throws Exception {
        return this.getContainer().lookup(role, roleHint);
    }

    protected <T> T lookup(Class<T> componentClass) throws Exception {
        return this.getContainer().lookup(componentClass);
    }

    protected <T> T lookup(Class<T> componentClass, String roleHint) throws Exception {
        return this.getContainer().lookup(componentClass, roleHint);
    }

    protected void release(Object component) throws Exception {
        this.getContainer().release(component);
    }

    public static File getTestFile(String path) {
        return new File(PlexusTestCase.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusTestCase.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusTestCase.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusTestCase.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }

    public String getTestConfiguration() {
        return PlexusTestCase.getTestConfiguration(this.getClass());
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String s = clazz.getName().replace('.', '/');
        return s.substring(0, s.indexOf("$")) + ".xml";
    }
}

