/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Supplier;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.CustomConcurrentHashMap;
import com.google.common.collect.ForwardingConcurrentMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputingCache<K, V>
extends AbstractCache<K, V> {
    final CustomConcurrentHashMap<K, V> map;
    ConcurrentMap<K, V> asMap;

    ComputingCache(CacheBuilder<? super K, ? super V> builder, Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier, CacheLoader<? super K, V> loader) {
        this.map = new CustomConcurrentHashMap<K, V>(builder, statsCounterSupplier, loader);
    }

    @Override
    public V get(K key) throws ExecutionException {
        return this.map.getOrCompute(key);
    }

    @Override
    public void invalidate(@Nullable Object key) {
        this.map.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        ConcurrentMap<K, V> am = this.asMap;
        return am != null ? am : (this.asMap = new CacheAsMap<K, V>(this.map));
    }

    @Override
    public CacheStats stats() {
        AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
        for (CustomConcurrentHashMap.Segment segment : this.map.segments) {
            aggregator.incrementBy(segment.statsCounter);
        }
        return aggregator.snapshot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CacheAsMap<K, V>
    extends ForwardingConcurrentMap<K, V> {
        private final CustomConcurrentHashMap<K, V> delegate;

        CacheAsMap(CustomConcurrentHashMap<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V get(@Nullable Object key) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> e = this.delegate.getEntry(key);
            return e == null ? null : (V)e.getValueReference().get();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }
    }
}

