/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIPostWriter
implements Runnable {
    private static final Logger log = Logger.getLogger(XMIPostWriter.class);
    private InputStream is;
    private OutputStreamWriter osw;
    private Hashtable<String, String> idmaps;
    private Hashtable<String, String> nsmaps;

    public XMIPostWriter(InputStream is, String file, Hashtable<String, String> idmaps, Hashtable<String, String> nsmaps) throws FileNotFoundException {
        this.is = is;
        this.osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        this.idmaps = idmaps;
        this.nsmaps = nsmaps;
    }

    @Override
    public void run() {
        int skip = 0;
        try {
            XMLInputFactory xmlif = XMLInputFactory.newFactory();
            xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLStreamReader xmlr = xmlif.createXMLStreamReader(this.is);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        if (skip == 0) {
                            if ("eAnnotations".equals(xmlr.getLocalName())) {
                                ++skip;
                            }
                        } else {
                            ++skip;
                        }
                        if (skip > 0) break;
                        this.write("<");
                        String prefix = xmlr.getPrefix();
                        if (prefix != null && !prefix.isEmpty()) {
                            this.write(prefix + ":");
                        }
                        this.write(xmlr.getLocalName());
                        for (i = 0; i < xmlr.getAttributeCount(); ++i) {
                            String rep;
                            this.write(" ");
                            prefix = xmlr.getAttributePrefix(i);
                            String name = xmlr.getAttributeLocalName(i);
                            String value = xmlr.getAttributeValue(i);
                            if ("href".equals(name) && this.idmaps != null && (rep = this.idmaps.get(value)) != null) {
                                value = rep;
                            }
                            if ("xmi".equals(prefix) && "version".equals(name)) continue;
                            if (prefix != null && !prefix.isEmpty()) {
                                this.write(prefix + ":");
                            }
                            this.write(name + "=\"" + XMIPostWriter.escape(value) + "\"");
                        }
                        for (i = 0; i < xmlr.getNamespaceCount(); ++i) {
                            String rep;
                            String namespace = xmlr.getNamespaceURI(i);
                            if (this.nsmaps != null && (rep = this.nsmaps.get(namespace)) != null) {
                                namespace = rep;
                            }
                            this.write(" xmlns:" + xmlr.getNamespacePrefix(i) + "=\"" + namespace + "\"");
                        }
                        this.write(">");
                        break;
                    }
                    case 2: {
                        if (skip > 0) {
                            --skip;
                            break;
                        }
                        this.write("</");
                        if (xmlr.getPrefix() != null && !xmlr.getPrefix().isEmpty()) {
                            this.write(xmlr.getPrefix() + ":");
                        }
                        this.write(xmlr.getLocalName() + ">");
                        break;
                    }
                    case 3: {
                        if (skip > 0) break;
                        this.write("<?" + xmlr.getText() + "?>");
                        break;
                    }
                    case 4: {
                        if (skip > 0) break;
                        this.write(XMIPostWriter.escape(new String(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength())));
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        break;
                    }
                    case 8: {
                        this.osw.flush();
                        this.osw.close();
                        break;
                    }
                    case 9: {
                        if (skip > 0) break;
                        this.write("&" + xmlr.getLocalName() + ";");
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        if (skip > 0) break;
                        this.write("<![CDATA[" + new String(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength()) + "]]>");
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.error("Error while parsing the file", e);
        }
        catch (IOException e) {
            log.error("Error while parsing the file", e);
        }
    }

    private void write(String str) throws IOException {
        this.osw.write(str);
    }

    private static String escape(String str) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

