/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.EMFUtil;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.resource.UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingGenerator {
    public static final Logger log = Logger.getLogger(MappingGenerator.class);
    private Hashtable<String, TreeSet<NamedElement>> resources = new Hashtable();
    private Comparator<NamedElement> comp = new Comparator<NamedElement>(){

        @Override
        public int compare(NamedElement o1, NamedElement o2) {
            return o1.getQualifiedName().compareTo(o2.getQualifiedName());
        }
    };
    private ResourceSet rs = EMFUtil.createBasicResourceSet();

    public void map() {
        String idUsed;
        int c;
        NamedElement ne1;
        NamedElement ne0;
        Iterator<NamedElement> it1;
        Iterator<NamedElement> it0;
        String id;
        int i;
        String[][] sources = new String[][]{{"SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20120401/SysML.xmi"}, {"SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20131201/SysML.xmi"}, {"SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20150709/SysML.xmi"}, {"SysML_1.4.xmi", "http://www.omg.org/spec/SysML/20150709/SysML.xmi"}};
        String[] used = new String[]{"SysML.xmi", "http://www.omg.org/spec/SysML/20161101/SysML.xmi"};
        String[][] targets = new String[][]{{"MD", "SysML_1.3.xmi", "http://www.omg.org/spec/SysML/20120401/SysML.xmi"}, {"OMG", "SysML.xmi", "http://www.omg.org/spec/SysML/20161101/SysML.xmi"}};
        TreeSet<NamedElement> tsUsed = this.getTreeSet(used[0]);
        block0: for (i = 0; i < sources.length; ++i) {
            TreeSet<NamedElement> tsSource = this.getTreeSet(sources[i][0]);
            if (tsSource == tsUsed) {
                for (NamedElement ne : tsUsed) {
                    id = ((UMLResource)ne.eResource()).getID(ne);
                    System.out.println("idmap_r\t" + sources[i][1] + "#" + id + "\t" + used[1] + "#" + id);
                }
                continue;
            }
            it0 = tsSource.iterator();
            it1 = tsUsed.iterator();
            if (!it0.hasNext() || !it1.hasNext()) continue;
            ne0 = it0.next();
            ne1 = it1.next();
            while (true) {
                if ((c = this.comp.compare(ne0, ne1)) == 0) {
                    String idSource = ((UMLResource)ne0.eResource()).getID(ne0);
                    idUsed = ((UMLResource)ne1.eResource()).getID(ne1);
                    System.out.println("idmap_r\t" + sources[i][1] + "#" + idSource + "\t" + used[1] + "#" + idUsed);
                    if (!it0.hasNext() || !it1.hasNext()) continue block0;
                    ne0 = it0.next();
                    ne1 = it1.next();
                    continue;
                }
                if (c > 0) {
                    if (!it1.hasNext()) continue block0;
                    ne1 = it1.next();
                    continue;
                }
                if (!it0.hasNext()) continue block0;
                ne0 = it0.next();
            }
        }
        block3: for (i = 0; i < targets.length; ++i) {
            TreeSet<NamedElement> tsTarget = this.getTreeSet(targets[i][1]);
            if (tsTarget == tsUsed) {
                for (NamedElement ne : tsUsed) {
                    id = ((UMLResource)ne.eResource()).getID(ne);
                    System.out.println("idmap_w\t" + targets[i][0] + "\t" + used[1] + "#" + id + "\t" + targets[i][2] + "#" + id);
                }
                continue;
            }
            it0 = tsTarget.iterator();
            it1 = tsUsed.iterator();
            if (!it0.hasNext() || !it1.hasNext()) continue;
            ne0 = it0.next();
            ne1 = it1.next();
            while (true) {
                if ((c = this.comp.compare(ne0, ne1)) == 0) {
                    String idTarget = ((UMLResource)ne0.eResource()).getID(ne0);
                    idUsed = ((UMLResource)ne1.eResource()).getID(ne1);
                    System.out.println("idmap_w\t" + targets[i][0] + "\t" + used[1] + "#" + idUsed + "\t" + targets[i][2] + "#" + idTarget);
                    if (!it0.hasNext() || !it1.hasNext()) continue block3;
                    ne0 = it0.next();
                    ne1 = it1.next();
                    continue;
                }
                if (c > 0) {
                    if (!it1.hasNext()) continue block3;
                    ne1 = it1.next();
                    continue;
                }
                if (!it0.hasNext()) continue block3;
                ne0 = it0.next();
            }
        }
    }

    private TreeSet<NamedElement> getTreeSet(String resourcefile) {
        TreeSet<NamedElement> ret = this.resources.get(resourcefile);
        if (ret == null) {
            ret = new TreeSet<NamedElement>(this.comp);
            URL res = MappingGenerator.class.getResource("/" + resourcefile);
            log.info("Populating " + res + " for " + resourcefile);
            UMLResource r0 = (UMLResource)this.rs.createResource(URI.createURI(res.toString()));
            try {
                r0.load(null);
            }
            catch (Exception e) {
                log.error(e);
            }
            TreeIterator<EObject> ti0 = r0.getAllContents();
            while (ti0.hasNext()) {
                NamedElement ne;
                EObject eo = (EObject)ti0.next();
                if (!(eo instanceof NamedElement) || (ne = (NamedElement)eo).getName() == null) continue;
                ret.add(ne);
            }
            log.info(ret.size() + " elements added");
            this.resources.put(resourcefile, ret);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            MappingGenerator mg = new MappingGenerator();
            mg.map();
        }
        catch (FileNotFoundException e) {
            log.error("Error", e);
        }
    }
}

