/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.ExpressionLanguageBaseListener;
import com.engisis.sysphs.util.ExpressionLanguageParser;
import java.util.Hashtable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionLanguageToSimulation
extends ExpressionLanguageBaseListener {
    private static final Logger log = Logger.getLogger(ExpressionLanguageToSimulation.class);
    private Hashtable<String, String> substitutions;
    private ParseTreeProperty<String> ptp;
    private ParseTree root = null;

    public void setSubstitutions(Hashtable<String, String> substitutions) {
        this.substitutions = substitutions;
    }

    protected void beforeParsing() {
        this.ptp = new ParseTreeProperty();
    }

    protected void afterParsing() {
    }

    public String getValue(ParseTree pt) {
        String v = this.ptp.get(pt);
        if (v == null) {
            log.error("The value of " + pt.getClass() + " is null");
        }
        return v;
    }

    public void setValue(ParseTree pt, String str) {
        this.ptp.put(pt, str);
    }

    @Override
    public void enterEquation(ExpressionLanguageParser.EquationContext ctx) {
        if (this.root == null) {
            this.root = ctx;
            this.beforeParsing();
        }
        super.enterEquation(ctx);
    }

    @Override
    public void exitEquation(ExpressionLanguageParser.EquationContext ctx) {
        if (ctx == this.root) {
            this.afterParsing();
            this.root = null;
        }
        this.processStraight(ctx);
    }

    @Override
    public void enterStatements(ExpressionLanguageParser.StatementsContext ctx) {
        if (this.root == null) {
            this.root = ctx;
            this.beforeParsing();
        }
        super.enterStatements(ctx);
    }

    @Override
    public void exitStatements(ExpressionLanguageParser.StatementsContext ctx) {
        if (ctx == this.root) {
            this.afterParsing();
            this.root = null;
        }
        this.processStraight(ctx);
    }

    @Override
    public void exitStatement(ExpressionLanguageParser.StatementContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitIf_equation(ExpressionLanguageParser.If_equationContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 2) {
                    sb.append("if");
                    continue;
                }
                if (t == 3) {
                    sb.append("then\n");
                    continue;
                }
                if (t == 4) {
                    sb.append("elseif");
                    continue;
                }
                if (t == 5) {
                    sb.append("else\n");
                    continue;
                }
                if (t != 6) continue;
                sb.append("end ");
                continue;
            }
            if (pt instanceof ExpressionLanguageParser.ExpressionContext) {
                sb.append(" " + this.getValue(pt) + " ");
                continue;
            }
            if (!(pt instanceof ExpressionLanguageParser.EquationContext)) continue;
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitIf_statement(ExpressionLanguageParser.If_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 2) {
                    sb.append("if");
                    continue;
                }
                if (t == 3) {
                    sb.append("then\n");
                    continue;
                }
                if (t == 4) {
                    sb.append("elseif");
                    continue;
                }
                if (t == 5) {
                    sb.append("else\n");
                    continue;
                }
                if (t != 6) continue;
                sb.append("end ");
                continue;
            }
            if (pt instanceof ExpressionLanguageParser.ExpressionContext) {
                sb.append(" " + this.getValue(pt) + " ");
                continue;
            }
            if (!(pt instanceof ExpressionLanguageParser.StatementContext)) continue;
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_statement(ExpressionLanguageParser.For_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("for " + this.getValue(ctx.for_indices()) + " loop\n");
        for (ExpressionLanguageParser.StatementContext sc : ctx.statement()) {
            sb.append(this.getValue(sc) + ";\n");
        }
        sb.append("end for");
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_indices(ExpressionLanguageParser.For_indicesContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFor_index(ExpressionLanguageParser.For_indexContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitWhile_statement(ExpressionLanguageParser.While_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("while " + this.getValue(ctx.expression()) + " loop");
        for (ExpressionLanguageParser.StatementContext sc : ctx.statement()) {
            sb.append(this.getValue(sc) + ";\n");
        }
        sb.append("end while");
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void enterExpression(ExpressionLanguageParser.ExpressionContext ctx) {
        if (this.root == null) {
            this.root = ctx;
            this.beforeParsing();
        }
        super.enterExpression(ctx);
    }

    @Override
    public void exitExpression(ExpressionLanguageParser.ExpressionContext ctx) {
        if (ctx == this.root) {
            this.afterParsing();
            this.root = null;
        }
        this.processWithSpaces(ctx);
    }

    @Override
    public void exitSimple_expression(ExpressionLanguageParser.Simple_expressionContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitLogical_expression(ExpressionLanguageParser.Logical_expressionContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (ExpressionLanguageParser.Logical_termContext ltc : ctx.logical_term()) {
            if (ltc != ctx.logical_term(0)) {
                sb.append(" " + this.getValue(ctx.OR(0)) + " ");
            }
            sb.append(this.getValue(ltc));
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitLogical_term(ExpressionLanguageParser.Logical_termContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (ExpressionLanguageParser.Logical_factorContext lfc : ctx.logical_factor()) {
            if (lfc != ctx.logical_factor(0)) {
                sb.append(" " + this.getValue(ctx.AND(0)) + " ");
            }
            sb.append(this.getValue(lfc));
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitLogical_factor(ExpressionLanguageParser.Logical_factorContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.NOT() != null) {
            sb.append(this.getValue(ctx.NOT()) + " ");
        }
        sb.append(this.getValue(ctx.relation()));
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitRelation(ExpressionLanguageParser.RelationContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitRel_op(ExpressionLanguageParser.Rel_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitArithmetic_expression(ExpressionLanguageParser.Arithmetic_expressionContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitAdd_op(ExpressionLanguageParser.Add_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitTerm(ExpressionLanguageParser.TermContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitMul_op(ExpressionLanguageParser.Mul_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFactor(ExpressionLanguageParser.FactorContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitPrimary(ExpressionLanguageParser.PrimaryContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.UNSIGNED_NUMBER() != null) {
            sb.append(ctx.getText());
        } else if (ctx.STRING() != null) {
            sb.append(ctx.STRING());
        } else if (ctx.TRUE() != null) {
            sb.append("true");
        } else if (ctx.FALSE() != null) {
            sb.append("false");
        } else if (ctx.function_call_args() != null) {
            if (ctx.name_path() != null) {
                sb.append(this.getValue(ctx.name_path()));
            } else if (ctx.DER() != null) {
                sb.append("der");
            }
            sb.append(this.getValue(ctx.function_call_args()));
        } else if (ctx.component_reference() != null) {
            sb.append(this.getValue(ctx.component_reference()));
        } else if (ctx.output_expression_list() != null) {
            sb.append("(" + this.getValue(ctx.output_expression_list()) + ")");
        } else if (ctx.expression_list().size() != 0) {
            sb.append("[");
            for (ExpressionLanguageParser.Expression_listContext elc : ctx.expression_list()) {
                if (elc != ctx.expression_list(0)) {
                    sb.append(";");
                }
                sb.append(this.getValue(elc));
            }
            sb.append("]");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFunction_call_args(ExpressionLanguageParser.Function_call_argsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitName_path(ExpressionLanguageParser.Name_pathContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitComponent_reference(ExpressionLanguageParser.Component_referenceContext ctx) {
        String v;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            sb.append(this.getValue(ctx.getChild(i)));
        }
        String s = sb.toString();
        if (this.substitutions != null && (v = this.substitutions.get(s)) != null) {
            this.setValue(ctx, v);
            return;
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFunction_arguments(ExpressionLanguageParser.Function_argumentsContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.named_arguments() != null) {
            sb.append(this.getValue(ctx.named_arguments()));
        } else {
            sb.append(this.getValue(ctx.function_argument()));
            if (ctx.function_arguments() != null) {
                sb.append("," + this.getValue(ctx.function_arguments()));
            }
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitNamed_arguments(ExpressionLanguageParser.Named_argumentsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitNamed_argument(ExpressionLanguageParser.Named_argumentContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFunction_argument(ExpressionLanguageParser.Function_argumentContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.expression() != null) {
            sb.append(this.getValue(ctx.expression()));
        } else {
            sb.append("function " + this.getValue(ctx.IDENT()) + "(");
            sb.append(this.getValue(ctx.named_arguments()));
            sb.append(")");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitOutput_expression_list(ExpressionLanguageParser.Output_expression_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpression_list(ExpressionLanguageParser.Expression_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitArray_subscripts(ExpressionLanguageParser.Array_subscriptsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitSubscript(ExpressionLanguageParser.SubscriptContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        this.setValue(node, node.getText());
    }

    protected void processStraight(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            sb.append(this.getValue(ctx.getChild(i)));
        }
        this.setValue(ctx, sb.toString());
    }

    protected void processWithSpaces(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.getValue(ctx.getChild(i)));
        }
        this.setValue(ctx, sb.toString());
    }
}

