/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.Configuration;
import com.engisis.sysphs.util.Util;
import com.engisis.sysphs.util.XMIPostWriter;
import com.engisis.sysphs.util.XMIPreReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public class EMFUtil {
    private static final Logger log = Logger.getLogger(EMFUtil.class);

    public static ResourceSet createBasicResourceSet() throws FileNotFoundException {
        String[] umluris;
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put("RECORD_ANY_TYPE_NAMESPACE_DECLARATIONS", Boolean.TRUE);
        rs.getLoadOptions().put("DEFER_IDREF_RESOLUTION", false);
        EPackage.Registry registry = rs.getPackageRegistry();
        registry.put("http://www.eclipse.org/uml2/5.0.0/UML", UMLPackage.eINSTANCE);
        registry.put("http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard", StandardPackage.eINSTANCE);
        Map<URI, URI> urimap = rs.getURIConverter().getURIMap();
        Class<UMLResourcesUtil> umlre = UMLResourcesUtil.class;
        String url = umlre.getResource("/" + umlre.getName().replace('.', '/') + ".class").toExternalForm();
        if (url.indexOf("!/") == -1) {
            throw new FileNotFoundException("The UML2 resource library must be in a JAR: " + url);
        }
        URI umljar = URI.createURI(url.substring(0, url.lastIndexOf(33) + 2));
        UMLPlugin.getEPackageNsURIToProfileLocationMap().put("http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard", umljar.appendSegment("profiles").appendSegment("Standard.profile.uml").appendFragment("_0"));
        urimap.put(URI.createURI("pathmap://UML_METAMODELS/UML.metamodel.uml"), umljar.appendSegment("metamodels").appendSegment("UML.metamodel.uml"));
        urimap.put(URI.createURI("pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), umljar.appendSegment("libraries").appendSegment("UMLPrimitiveTypes.library.uml"));
        for (String umluri : umluris = new String[]{"http://www.omg.org/spec/UML/20110701", "http://www.omg.org/spec/UML/20131001"}) {
            registry.put(umluri, UMLPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put(umluri, UMLPackage.eINSTANCE);
            registry.put(umluri + "/StandardProfile", StandardPackage.eINSTANCE);
            UMLPlugin.getEPackageNsURIToProfileLocationMap().put(umluri + "/StandardProfile", umljar.appendSegment("profiles").appendSegment("Standard.profile.uml").appendFragment("_0"));
            urimap.put(URI.createURI(umluri + "/UML.xmi"), umljar.appendSegment("metamodels").appendSegment("UML.metamodel.uml"));
            urimap.put(URI.createURI(umluri + "/PrimitiveTypes.xmi"), umljar.appendSegment("libraries").appendSegment("UMLPrimitiveTypes.library.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfile.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfileL2.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfileL3.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
        }
        Map<String, Object> extension2factory = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extension2factory.put("uml", UMLResource.Factory.INSTANCE);
        extension2factory.put("xmi", UMLResource.Factory.INSTANCE);
        extension2factory.put("xml", UMLResource.Factory.INSTANCE);
        urimap.put(URI.createURI("pathmap://UML_LIBRARIES/"), umljar.appendSegment("libraries").appendSegment(""));
        urimap.put(URI.createURI("pathmap://UML_METAMODELS/"), umljar.appendSegment("metamodels").appendSegment(""));
        urimap.put(URI.createURI("pathmap://UML_PROFILES/"), umljar.appendSegment("profiles").appendSegment(""));
        return rs;
    }

    public static ResourceSet createResourceSet() throws FileNotFoundException {
        ResourceSet rs = EMFUtil.createBasicResourceSet();
        Map<URI, URI> urimap = rs.getURIConverter().getURIMap();
        for (Map.Entry<URI, URI> localmapentry : Configuration.getLocationMappings().entrySet()) {
            urimap.put(localmapentry.getKey(), localmapentry.getValue());
        }
        return rs;
    }

    public static Resource loadResource(ResourceSet rs, URI fileuri, String[] paths) {
        log.info("Loading file " + fileuri);
        Resource r = rs.createResource(fileuri);
        try {
            PipedInputStream pis = new PipedInputStream(2048);
            PipedOutputStream pos = new PipedOutputStream(pis);
            XMIPreReader xmif = new XMIPreReader(rs, rs.getURIConverter().createInputStream(fileuri), pos, fileuri, Configuration.getReaderIDMappings(), Configuration.getReaderNSMappings(), paths);
            Thread th = new Thread(xmif);
            th.start();
            try {
                r.load(pis, null);
            }
            catch (Exception e) {
                log.error(e);
            }
            pis.close();
            pos.close();
            log.debug("Resource " + r + " loaded");
            LinkedList<Profile> profiles = new LinkedList<Profile>();
            Hashtable applications = new Hashtable();
            TreeIterator<EObject> allcontent = r.getAllContents();
            while (allcontent.hasNext()) {
                EObject eo = (EObject)allcontent.next();
                if (!(eo instanceof Package)) {
                    allcontent.prune();
                    continue;
                }
                Package p = (Package)eo;
                LinkedList<Profile> linkedList = new LinkedList<Profile>();
                applications.put(p, linkedList);
                for (Profile prof : p.getAppliedProfiles()) {
                    log.info("Identified applied profile " + prof + " in " + p);
                    linkedList.add(prof);
                }
                if (!(p instanceof Profile)) continue;
                Profile prof = (Profile)p;
                profiles.add(prof);
                EMFUtil.flatten(prof);
                String profURI = prof.getURI();
                if (!prof.isDefined()) {
                    EPackage definition = prof.define();
                    log.debug("Definition: " + definition.getName() + "  with " + definition.getNsPrefix() + " :" + definition.getNsURI() + " at " + EcoreUtil.getURI(definition) + "--" + EcoreUtil.getURI(prof));
                    log.debug("Registering " + profURI + " for " + definition.getNsURI());
                    UMLPlugin.getEPackageNsURIToProfileLocationMap().put(profURI, EcoreUtil.getURI(definition));
                    rs.getPackageRegistry().put(profURI, definition);
                    String alt = Configuration.getReaderNSMappings().get(profURI);
                    if (alt != null) {
                        log.debug("Registering " + alt + " for " + definition.getNsURI());
                        UMLPlugin.getEPackageNsURIToProfileLocationMap().put(alt, EcoreUtil.getURI(definition));
                        rs.getPackageRegistry().put(alt, definition);
                    }
                } else {
                    log.debug("Profile " + profURI + " defined");
                }
                log.debug("Profile " + prof + " defined by " + prof.getDefinition());
            }
            LinkedList<DynamicEObjectImpl> ldeos = new LinkedList<DynamicEObjectImpl>();
            for (EObject eObject : r.getContents()) {
                if (!(eObject instanceof AnyTypeImpl)) continue;
                AnyTypeImpl at = (AnyTypeImpl)eObject;
                String name = at.eClass().getName();
                for (Profile profile : profiles) {
                    for (EClassifier ec : profile.getDefinition().getEClassifiers()) {
                        if (!(ec instanceof EClass) || !ec.getName().equals(name)) continue;
                        DynamicEObjectImpl deo = new DynamicEObjectImpl((EClass)ec);
                        ldeos.add(deo);
                        for (FeatureMap.Entry fm : at.getAnyAttribute()) {
                            String attname = fm.getEStructuralFeature().getName();
                            EStructuralFeature esf = ((EClass)ec).getEStructuralFeature(attname);
                            if (esf != null) {
                                if (esf instanceof EAttribute) {
                                    String etypename = ((EAttribute)esf).getEType().getInstanceClassName();
                                    try {
                                        if (etypename.equals("boolean")) {
                                            deo.eSet(esf, (Object)Util.toBoolean(fm.getValue().toString(), false));
                                            continue;
                                        }
                                        if (etypename.equals("int")) {
                                            deo.eSet(esf, (Object)Util.toInt(fm.getValue().toString(), 0));
                                            continue;
                                        }
                                        if (etypename.equals("double")) {
                                            deo.eSet(esf, (Object)Util.toDouble(fm.getValue().toString(), 0.0));
                                            continue;
                                        }
                                        if (etypename.equals("java.lang.String")) {
                                            deo.eSet(esf, (Object)fm.getValue().toString());
                                            continue;
                                        }
                                        log.warn("Unsupported type: " + etypename);
                                    }
                                    catch (Exception e) {
                                        log.warn("Can't assign value " + fm.getValue() + " to " + esf);
                                    }
                                    continue;
                                }
                                if (esf instanceof EReference) {
                                    deo.eSet(esf, (Object)r.getEObject(fm.getValue().toString()));
                                    continue;
                                }
                            }
                            log.error("Coundn't set value of " + ec + "::" + esf);
                        }
                    }
                }
            }
            r.getContents().addAll(ldeos);
            for (Map.Entry entry : applications.entrySet()) {
                for (Profile prof : (LinkedList)entry.getValue()) {
                    log.info("Applying profile " + prof + " at " + EcoreUtil.getURI(prof) + " defined by " + prof.getDefinition());
                    ((Package)entry.getKey()).applyProfile(prof);
                }
            }
        }
        catch (IOException e) {
            log.error("Couldn't read the file", e);
        }
        catch (XMLStreamException e) {
            log.error("Error during the XML parsing", e);
        }
        catch (FactoryConfigurationError e) {
            log.error("Error during the StAX configuration", e);
        }
        catch (Exception e) {
            log.error("Reading error", e);
        }
        EcoreUtil.resolveAll(r);
        return r;
    }

    public static void saveResource(final Resource r, String target) throws IOException {
        final HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("DECLARE_XML", Boolean.TRUE);
        opts.put("ENCODING", "UTF-8");
        if (r instanceof XMLResource) {
            ((XMLResource)r).setEncoding("UTF-8");
        }
        PipedInputStream pis = new PipedInputStream();
        final PipedOutputStream pos = new PipedOutputStream(pis);
        XMIPostWriter cleaner = new XMIPostWriter(pis, r.getURI().toFileString(), Configuration.getWriterIDMappings(target), Configuration.getWriterNSMappings(target));
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    r.save(pos, opts);
                    pos.close();
                }
                catch (IOException e) {
                    log.error("Can't save " + r.getURI(), e);
                }
            }
        });
        t.start();
        cleaner.run();
        pis.close();
        pos.close();
        log.info("Saved " + r.getURI());
    }

    private static void flatten(Profile profile) {
        EMFUtil.move(profile, profile);
    }

    private static void move(Package from, Profile to) {
        int i = 0;
        while (i != from.getPackagedElements().size()) {
            PackageableElement pe = (PackageableElement)from.getPackagedElements().get(i);
            if (pe instanceof Package) {
                EMFUtil.move((Package)pe, to);
                from.getPackagedElements().remove(i);
                continue;
            }
            if (from != to) {
                from.getPackagedElements().remove(i);
                to.getPackagedElements().add(pe);
                continue;
            }
            ++i;
        }
    }

    public static Resource createSysMLModel(ResourceSet rs, URI file, String[] paths) {
        log.info("Creating " + file);
        Resource r = rs.createResource(file);
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName("data");
        r.getContents().add(model);
        Resource sysml = EMFUtil.loadResource(rs, URI.createURI("http://www.omg.org/spec/SysML/20161101/SysML.xmi"), null);
        Profile sysmlprofile = (Profile)EcoreUtil.getObjectByType(sysml.getContents(), UMLPackage.Literals.PROFILE);
        model.applyProfile(sysmlprofile);
        Resource sysphs = EMFUtil.loadResource(rs, URI.createURI("http://www.omg.org/spec/SysPhS/20171215/SysPhSProfile.xmi"), null);
        Profile sysphsprofile = (Profile)EcoreUtil.getObjectByType(sysphs.getContents(), UMLPackage.Literals.PROFILE);
        model.applyProfile(sysphsprofile);
        return r;
    }

    public static Resource getSimulationLibrary(ResourceSet rs, URI file, String[] paths) {
        return EMFUtil.loadResource(rs, URI.createURI("http://www.omg.org/spec/SysPhS/20171215/SysPhSLibrary.xmi"), null);
    }

    private static File locateFile(String[] paths, String name) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            sb.append(" " + path);
            File f = new File(path, name);
            if (!f.exists()) continue;
            return f;
        }
        log.error("Couldn't locate " + name + " in" + sb.toString());
        return null;
    }
}

